/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.Extended;
import apoc.export.parquet.ApocParquetReader;
import apoc.export.parquet.ParquetConfig;
import apoc.export.parquet.ParquetReadUtil;
import apoc.result.MapResult;
import apoc.util.Util;
import java.io.IOException;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class LoadParquet {
    @Context
    public Log log;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(name="apoc.load.parquet")
    @Description(value="Load parquet from the provided file or binary")
    public Stream<MapResult> load(@Name(value="input") Object input, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws IOException {
        ParquetConfig conf = new ParquetConfig(config);
        ApocParquetReader reader = ParquetReadUtil.getReader(input, conf, this.urlAccessChecker);
        return (Stream)StreamSupport.stream(new ParquetSpliterator(reader), false).onClose(() -> Util.close((AutoCloseable)reader));
    }

    private static class ParquetSpliterator
    extends Spliterators.AbstractSpliterator<MapResult> {
        private final ApocParquetReader reader;

        public ParquetSpliterator(ApocParquetReader reader) {
            super(Long.MAX_VALUE, 16);
            this.reader = reader;
        }

        @Override
        public synchronized boolean tryAdvance(Consumer<? super MapResult> action) {
            try {
                Map<String, Object> read = this.reader.getRecord();
                if (read != null) {
                    MapResult result = new MapResult(read);
                    action.accept((MapResult)result);
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

