/*
 * Decompiled with CFR 0.152.
 */
package apoc.load.jdbc;

import apoc.Extended;
import apoc.load.jdbc.Jdbc;
import apoc.load.util.JdbcUtil;
import apoc.load.util.LoadJdbcConfig;
import apoc.result.RowResult;
import apoc.util.ExtendedUtil;
import apoc.util.Util;
import java.sql.Connection;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class Analytics {
    public static final String PROVIDER_CONF_KEY = "provider";
    public static final String TABLE_NAME_CONF_KEY = "tableName";
    public static final String BATCH_SIZE_CONF_KEY = "batchSize";
    public static final String WRITE_MODE_CONF_KEY = "writeMode";
    public static final int BATCH_SIZE_DEFAULT = 10000;
    public static final String TABLE_NAME_DEFAULT_CONF_KEY = "neo4j_tmp_table";
    public static final String EMPTY_SQL_QUERY_ERROR = "The SQL query is empty";
    public static final String EMPTY_NEO4J_QUERY_ERROR = "The Neo4j query is empty";
    public static final String WRONG_BATCH_SIZE_ERR = "The batchSize value is invalid";
    @Context
    public Log log;
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;

    @Procedure(value="apoc.jdbc.analytics")
    @Description(value="apoc.jdbc.analytics(<cypherQuery>, <jdbcUrl>, <sqlQueryOverTemporaryTable>, <paramsList>, $config) - to create a temporary table starting from a Cypher query and delegate complex analytics to the database defined JDBC URL ")
    public Stream<RowResult> aggregate(@Name(value="neo4jQuery") String neo4jQuery, @Name(value="jdbc") String urlOrKey, @Name(value="sqlQuery") String sqlQuery, @Name(value="params", defaultValue="[]") List<Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        Connection connection;
        AtomicReference createTable = new AtomicReference();
        Provider provider = Provider.valueOf((String)config.getOrDefault(PROVIDER_CONF_KEY, Provider.DUCKDB.name()));
        String tableName = (String)config.getOrDefault(TABLE_NAME_CONF_KEY, TABLE_NAME_DEFAULT_CONF_KEY);
        int batchSize = Util.toInteger((Object)config.getOrDefault(BATCH_SIZE_CONF_KEY, 10000));
        String writeModeString = (String)config.getOrDefault(WRITE_MODE_CONF_KEY, WriteMode.CREATE.toString());
        WriteMode writeMode = WriteMode.valueOf(writeModeString.toUpperCase());
        AtomicReference columns = new AtomicReference();
        AtomicReference queriesInsert = new AtomicReference();
        if (StringUtils.isBlank((CharSequence)neo4jQuery)) {
            throw new RuntimeException(EMPTY_NEO4J_QUERY_ERROR);
        }
        if (StringUtils.isBlank((CharSequence)sqlQuery)) {
            throw new RuntimeException(EMPTY_SQL_QUERY_ERROR);
        }
        if (batchSize < 1) {
            throw new RuntimeException(WRONG_BATCH_SIZE_ERR);
        }
        boolean isCreate = writeMode.equals((Object)WriteMode.CREATE);
        this.db.executeTransactionally(neo4jQuery, Map.of(), result -> {
            List<String> insertClause = ExtendedUtil.batchIterator(result, batchSize, map -> {
                if (isCreate && createTable.get() == null) {
                    String tempTableClause = this.getTempTableClause((Map<String, Object>)map, provider, tableName);
                    createTable.set(tempTableClause);
                }
                String row = Analytics.getStreamSortedByKey(map).map(Map.Entry::getValue).map(i -> Analytics.formatSqlValue(i, provider)).collect(Collectors.joining(","));
                return "(" + row + ")";
            }).map(i -> {
                String sqlValues = String.join((CharSequence)",", i);
                return String.format("INSERT INTO %s VALUES %s", tableName, sqlValues);
            }).toList();
            queriesInsert.set(insertClause);
            if (columns.get() == null) {
                String neo4jResultColumns = result.columns().stream().sorted().collect(Collectors.joining(","));
                columns.set(neo4jResultColumns);
            }
            return null;
        });
        String url = JdbcUtil.getUrlOrKey(urlOrKey);
        LoadJdbcConfig jdbcConfig = new LoadJdbcConfig(config);
        try {
            connection = (Connection)JdbcUtil.getConnection(url, jdbcConfig, Connection.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Connection error", e);
        }
        Object[] paramsArray = params.toArray(new Object[params.size()]);
        if (isCreate) {
            Jdbc.executeUpdate(urlOrKey, (String)createTable.get(), config, connection, this.log, paramsArray);
        }
        ((List)queriesInsert.get()).forEach(query -> Jdbc.executeUpdate(urlOrKey, query, config, connection, this.log, paramsArray));
        try {
            return Jdbc.executeQuery(urlOrKey, sqlQuery, config, connection, this.log, paramsArray);
        }
        catch (Exception e) {
            String checkColConsistency = String.format("Make sure the SQL is consistent with Cypher query which has columns: %s", columns.get());
            throw new RuntimeException(checkColConsistency, e);
        }
    }

    private String getTempTableClause(Map<String, Object> map, Provider provider, String tableName) {
        String sqlFields = Analytics.getStreamSortedByKey(map).map(e -> {
            String type = this.mapSqlType(provider, e.getValue());
            return provider.tableTypeTemplate.formatted(e.getKey(), type);
        }).collect(Collectors.joining(","));
        return "CREATE TEMPORARY TABLE %s (%s)".formatted(tableName, sqlFields);
    }

    private static Stream<Map.Entry<String, Object>> getStreamSortedByKey(Map<String, Object> map) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByKey());
    }

    private static String formatSqlValue(Object val, Provider provider) {
        Comparable<ChronoZonedDateTime<?>> zonedDateTime;
        String stringValue = val.toString();
        if (val instanceof Number) {
            return stringValue;
        }
        if (val instanceof ZonedDateTime) {
            zonedDateTime = (ZonedDateTime)val;
            stringValue = JdbcUtil.toSqlCompatibleDateTime(zonedDateTime);
        }
        if (val instanceof OffsetTime) {
            zonedDateTime = (OffsetTime)val;
            stringValue = JdbcUtil.toSqlCompatibleTimeFormat((OffsetTime)zonedDateTime);
        }
        if (val instanceof byte[]) {
            byte[] bytes = (byte[])val;
            stringValue = provider.byteArrayToBlobString(bytes);
        }
        return String.format("'%s'", stringValue.replace("'", "''"));
    }

    private String mapSqlType(Provider provider, Object value) {
        if (value == null) {
            return "VARCHAR(1000)";
        }
        Class<?> clazz = value.getClass();
        return provider.typeMap.getOrDefault(clazz, "VARCHAR(1000)");
    }

    public static enum Provider {
        DUCKDB(JdbcUtil.DUCK_TYPE_MAP, "\"%s\" %s"),
        POSTGRES(JdbcUtil.POSTGRES_TYPE_MAP, "\"%s\" %s"),
        MYSQL(JdbcUtil.MYSQL_TYPE_MAP, "`%s` %s");

        public final Map<Class<?>, String> typeMap;
        public final String tableTypeTemplate;

        private Provider(Map<Class<?>, String> typeMap, String tableTypeTemplate) {
            this.typeMap = typeMap;
            this.tableTypeTemplate = tableTypeTemplate;
        }

        public String byteArrayToBlobString(byte[] data2) {
            if (data2 == null) {
                throw new IllegalArgumentException("Data and database type must not be null");
            }
            String hexString = Hex.encodeHexString((byte[])data2);
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "X'%s'".formatted(hexString);
                case 2 -> "0x" + hexString;
                case 1 -> "decode('%s', 'hex')".formatted(hexString);
            };
        }
    }

    public static enum WriteMode {
        APPEND,
        CREATE;

    }
}

