/*
 * Decompiled with CFR 0.152.
 */
package apoc.load.partial;

import apoc.ApocConfig;
import apoc.Extended;
import apoc.load.partial.LoadPartialAws;
import apoc.load.partial.LoadPartialConfig;
import apoc.result.StringResult;
import apoc.util.ArchiveType;
import apoc.util.CompressionAlgo;
import apoc.util.FileUtils;
import apoc.util.StreamConnection;
import apoc.util.SupportedProtocols;
import apoc.util.Util;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class LoadPartial {
    @Context
    public GraphDatabaseService db;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(value="apoc.load.stringPartial")
    @Description(value="apoc.load.stringPartial")
    public Stream<StringResult> offset(@Name(value="urlOrBinary") Object urlOrBinary, @Name(value="offset") long offset, @Name(value="limit", defaultValue="0") long limit, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws Exception {
        String value = this.getStringResultStream(urlOrBinary, Math.toIntExact(offset), Math.toIntExact(limit), config);
        return Stream.of(new StringResult(value));
    }

    private String getStringResultStream(Object urlOrBinary, int offset, int limit, Map<String, Object> config) throws Exception {
        LoadPartialConfig conf = new LoadPartialConfig(config);
        if (urlOrBinary instanceof String) {
            String filePath = (String)urlOrBinary;
            ApocConfig.apocConfig().checkReadAllowed(filePath, this.urlAccessChecker);
            ArchiveType archiveType = ArchiveType.from((String)filePath);
            if (archiveType.isArchive()) {
                String[] tokens = filePath.split("!");
                return this.readFromArchive(archiveType, tokens[0], tokens[1], offset, limit, conf);
            }
            return this.readFromFile(filePath, offset, limit, conf);
        }
        if (urlOrBinary instanceof byte[]) {
            byte[] bytes = (byte[])urlOrBinary;
            return this.readFromByteArray(bytes, offset, limit, conf);
        }
        throw new RuntimeException("The first parameter must be a String URL or a byte[]");
    }

    public String readFromFile(String path, int offset, int limit, LoadPartialConfig conf) throws Exception {
        SupportedProtocols protocol = FileUtils.from((String)path);
        if (!protocol.equals((Object)SupportedProtocols.file)) {
            return this.getPartialString(path, offset, limit, protocol, conf);
        }
        return this.readFromLocalFile(path, offset, limit, conf);
    }

    private String getPartialString(String path, int offset, int limit, SupportedProtocols protocol, LoadPartialConfig conf) throws Exception {
        boolean s3Protocol = protocol.equals((Object)SupportedProtocols.s3);
        HashMap<String, Object> headers = new HashMap<String, Object>(conf.getHeaders());
        String httpLimit = limit == 0 ? "-" : "-" + (offset + limit - 1);
        headers.putIfAbsent("Range", "bytes=" + offset + httpLimit);
        try (InputStream inputStream = this.getInputStream(path, offset, limit, s3Protocol, conf, headers);){
            if (s3Protocol || protocol.equals((Object)SupportedProtocols.hdfs)) {
                inputStream.skip(offset);
            }
            String string = this.getPartialString(limit, inputStream, conf);
            return string;
        }
    }

    private InputStream getInputStream(String path, int offset, int limit, boolean s3Protocol, LoadPartialConfig conf, Map<String, Object> headers) throws IOException, URISyntaxException, URLAccessValidationError {
        if (s3Protocol) {
            return LoadPartialAws.getS3ObjectInputStream(path, offset, limit);
        }
        StreamConnection streamConnection = Util.getStreamConnection((String)path, headers, null, (URLAccessChecker)this.urlAccessChecker);
        InputStream inputStream = streamConnection.getInputStream();
        return inputStream;
    }

    private String readFromLocalFile(String filePath, int offset, int limit, LoadPartialConfig conf) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(filePath, "r");){
            int bytesRead;
            raf.seek(offset);
            StringBuilder result = new StringBuilder();
            byte[] buffer = new byte[conf.getBufferLimit().intValue()];
            int totalRead = 0;
            while ((bytesRead = raf.read(buffer)) != -1) {
                if ((long)limit != 0L && totalRead + bytesRead > limit) {
                    bytesRead = limit - totalRead;
                }
                result.append(new String(buffer, 0, bytesRead, StandardCharsets.UTF_8));
                if ((long)limit == 0L || (totalRead += bytesRead) < limit) continue;
            }
            String string = result.toString();
            return string;
        }
    }

    public String readFromArchive(ArchiveType type, String path, String csvFileName, int offset, int limit, LoadPartialConfig conf) throws IOException, URISyntaxException, URLAccessValidationError {
        SupportedProtocols from = FileUtils.from((String)path);
        boolean s3Protocol = from.equals((Object)SupportedProtocols.s3);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.putIfAbsent("Range", "bytes=0-" + conf.getArchiveLimit());
        try (InputStream inputStream = this.getInputStream(path, offset, limit, s3Protocol, conf, headers);){
            String string;
            block12: {
                ArchiveInputStream is = type.getInputStream(inputStream);
                try {
                    string = this.getPartialString(csvFileName, offset, limit, is, conf);
                    if (is == null) break block12;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return string;
        }
    }

    private String getPartialString(String fileName, int offset, int limit, ArchiveInputStream is, LoadPartialConfig conf) throws IOException {
        ArchiveEntry archiveEntry;
        while ((archiveEntry = is.getNextEntry()) != null) {
            if (archiveEntry.isDirectory() || !archiveEntry.getName().equals(fileName)) continue;
            is.skip((long)offset);
            return this.getPartialString(limit, (InputStream)is, conf);
        }
        throw new FileNotFoundException("File not found in archive: " + fileName);
    }

    private String readFromByteArray(byte[] data2, int offset, int limit, LoadPartialConfig config) throws Exception {
        if (offset >= data2.length) {
            return "";
        }
        CompressionAlgo algo = CompressionAlgo.valueOf((String)config.getCompressionAlgo());
        try (ByteArrayInputStream stream = new ByteArrayInputStream(data2);){
            String string;
            block12: {
                InputStream inputStream = algo.getInputStream((InputStream)stream);
                try {
                    inputStream.skip(offset);
                    string = this.getPartialString(limit, inputStream, config);
                    if (inputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return string;
        }
    }

    private String getPartialString(int limit, InputStream inputStream, LoadPartialConfig config) throws IOException {
        int bytesRead;
        StringBuilder result = new StringBuilder();
        int totalRead = 0;
        byte[] buffer = new byte[limit == 0 ? config.getBufferLimit() : limit];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            if ((long)limit != 0L && totalRead + bytesRead > limit) {
                bytesRead = limit - totalRead;
            }
            result.append(new String(buffer, 0, bytesRead, StandardCharsets.UTF_8));
            if ((long)limit == 0L || (totalRead += bytesRead) < limit) continue;
            break;
        }
        return result.toString();
    }
}

