/*
 * Decompiled with CFR 0.152.
 */
package apoc.load.partial;

import apoc.util.s3.S3Aws;
import apoc.util.s3.S3Params;
import apoc.util.s3.S3ParamsExtractor;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.model.GetObjectRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class LoadPartialAws {
    public static InputStream getS3ObjectInputStream(String path, int offset, int limit) throws IOException {
        S3Params s3Params = S3ParamsExtractor.extract((String)path);
        String region = Objects.nonNull(s3Params.getRegion()) ? s3Params.getRegion() : Regions.US_EAST_1.getName();
        S3Aws s3Aws = new S3Aws(s3Params, region);
        GetObjectRequest request = new GetObjectRequest(s3Params.getBucket(), s3Params.getKey());
        if (limit == 0) {
            request.withRange((long)offset);
        } else {
            request.withRange((long)offset, (long)(offset + limit - 1));
        }
        return s3Aws.getS3AwsInputStream(s3Params).getInputStream();
    }
}

