/*
 * Decompiled with CFR 0.152.
 */
package apoc.load.util;

import apoc.load.util.LoadJdbcConfig;
import apoc.util.Util;
import java.math.BigDecimal;
import java.net.URI;
import java.security.PrivilegedActionException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSources;
import us.fatehi.utility.datasource.MultiUseUserCredentials;
import us.fatehi.utility.datasource.UserCredentials;

public class JdbcUtil {
    public static final Map<Class<?>, String> DUCK_TYPE_MAP = new HashMap();
    public static final Map<Class<?>, String> POSTGRES_TYPE_MAP = new HashMap();
    public static final Map<Class<?>, String> MYSQL_TYPE_MAP = new HashMap();
    public static final String VARCHAR_TYPE = "VARCHAR(1000)";
    public static final String KEY_NOT_FOUND_MESSAGE = "No apoc.jdbc.%s.url url specified";
    private static final String LOAD_TYPE = "jdbc";

    private JdbcUtil() {
    }

    public static String toSqlCompatibleDateTime(ZonedDateTime zonedDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
        return localDateTime.format(formatter);
    }

    public static String toSqlCompatibleTimeFormat(OffsetTime zonedDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        LocalTime localTime = zonedDateTime.toLocalTime();
        return localTime.format(formatter);
    }

    public static Object getConnection(String jdbcUrl, LoadJdbcConfig config, Class<?> classType) throws Exception {
        if (config.hasCredentials()) {
            return JdbcUtil.createConnection(jdbcUrl, config.getCredentials().getUser(), config.getCredentials().getPassword(), classType);
        }
        String userInfo = null;
        try {
            URI uri = new URI(jdbcUrl.substring("jdbc:".length()));
            userInfo = uri.getUserInfo();
        }
        catch (Exception uri) {
            // empty catch block
        }
        if (userInfo != null) {
            String cleanUrl = jdbcUrl.substring(0, jdbcUrl.indexOf("://") + 3) + jdbcUrl.substring(jdbcUrl.indexOf("@") + 1);
            String[] user = userInfo.split(":");
            return JdbcUtil.createConnection(cleanUrl, user[0], user[1], classType);
        }
        return DriverManager.getConnection(jdbcUrl);
    }

    private static Object createConnection(String jdbcUrl, String userName, String password, Class<?> classType) throws Exception {
        if (jdbcUrl.contains(";auth=kerberos")) {
            String client = System.getProperty("java.security.auth.login.config.client", "KerberosClient");
            LoginContext lc = new LoginContext(client, callbacks -> {
                for (Callback cb : callbacks) {
                    if (cb instanceof NameCallback) {
                        ((NameCallback)cb).setName(userName);
                    }
                    if (!(cb instanceof PasswordCallback)) continue;
                    ((PasswordCallback)cb).setPassword(password.toCharArray());
                }
            });
            lc.login();
            Subject subject = lc.getSubject();
            try {
                return Subject.doAs(subject, () -> JdbcUtil.createConnectionByClass(jdbcUrl, userName, password, classType));
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        return JdbcUtil.createConnectionByClass(jdbcUrl, userName, password, classType);
    }

    private static Object createConnectionByClass(String jdbcUrl, String userName, String password, Class<?> classType) throws SQLException {
        if (classType.isAssignableFrom(DatabaseConnectionSource.class)) {
            return DatabaseConnectionSources.newDatabaseConnectionSource((String)jdbcUrl, (UserCredentials)new MultiUseUserCredentials(userName, password));
        }
        return DriverManager.getConnection(jdbcUrl, userName, password);
    }

    public static String getUrlOrKey(String urlOrKey) {
        return urlOrKey.contains(":") ? urlOrKey : (String)Util.getLoadUrlByConfigFile((String)LOAD_TYPE, (String)urlOrKey, (String)"url").orElseThrow(() -> new RuntimeException(String.format(KEY_NOT_FOUND_MESSAGE, urlOrKey)));
    }

    public static String getSqlOrKey(String sqlOrKey) {
        return sqlOrKey.contains(" ") ? sqlOrKey : (String)((Object)Util.getLoadUrlByConfigFile((String)LOAD_TYPE, (String)sqlOrKey, (String)"sql").orElse("SELECT * FROM " + sqlOrKey));
    }

    public static String obfuscateJdbcUrl(String query) {
        query = query.replaceAll("(jdbc:[^:]+://)[^\\s\\\"']+", "$1*******");
        query = query.replaceAll("(jdbc:oracle:thin:)[^\\s\\\"']+", "$1*******");
        return query;
    }

    static {
        DUCK_TYPE_MAP.put(String.class, "VARCHAR");
        DUCK_TYPE_MAP.put(Integer.class, "INTEGER");
        DUCK_TYPE_MAP.put(Integer.TYPE, "INTEGER");
        DUCK_TYPE_MAP.put(Long.class, "BIGINT");
        DUCK_TYPE_MAP.put(Long.TYPE, "BIGINT");
        DUCK_TYPE_MAP.put(Double.class, "DOUBLE");
        DUCK_TYPE_MAP.put(Double.TYPE, "DOUBLE");
        DUCK_TYPE_MAP.put(Float.class, "FLOAT");
        DUCK_TYPE_MAP.put(Float.TYPE, "FLOAT");
        DUCK_TYPE_MAP.put(Boolean.class, "BOOLEAN");
        DUCK_TYPE_MAP.put(Boolean.TYPE, "BOOLEAN");
        DUCK_TYPE_MAP.put(BigDecimal.class, "DECIMAL");
        DUCK_TYPE_MAP.put(Date.class, "DATE");
        DUCK_TYPE_MAP.put(Time.class, "TIME");
        DUCK_TYPE_MAP.put(Timestamp.class, "TIMESTAMP");
        DUCK_TYPE_MAP.put(LocalDate.class, "DATE");
        DUCK_TYPE_MAP.put(LocalTime.class, "TIME");
        DUCK_TYPE_MAP.put(OffsetTime.class, "TIME");
        DUCK_TYPE_MAP.put(Instant.class, "DATETIME");
        DUCK_TYPE_MAP.put(LocalDateTime.class, "TIMESTAMP");
        DUCK_TYPE_MAP.put(ZonedDateTime.class, "DATETIME");
        DUCK_TYPE_MAP.put(OffsetDateTime.class, "DATETIME");
        DUCK_TYPE_MAP.put(Duration.class, "INTERVAL");
        DUCK_TYPE_MAP.put(byte[].class, "BLOB");
        POSTGRES_TYPE_MAP.putAll(DUCK_TYPE_MAP);
        POSTGRES_TYPE_MAP.put(Double.class, "FLOAT");
        POSTGRES_TYPE_MAP.put(Double.TYPE, "FLOAT");
        POSTGRES_TYPE_MAP.put(LocalDateTime.class, "DATE");
        POSTGRES_TYPE_MAP.put(ZonedDateTime.class, "DATE");
        POSTGRES_TYPE_MAP.put(OffsetDateTime.class, "DATE");
        POSTGRES_TYPE_MAP.put(String.class, VARCHAR_TYPE);
        POSTGRES_TYPE_MAP.put(byte[].class, "bytea");
        MYSQL_TYPE_MAP.putAll(DUCK_TYPE_MAP);
        MYSQL_TYPE_MAP.put(String.class, VARCHAR_TYPE);
        MYSQL_TYPE_MAP.put(LocalDateTime.class, "DATETIME");
        MYSQL_TYPE_MAP.put(Duration.class, VARCHAR_TYPE);
    }
}

