/*
 * Decompiled with CFR 0.152.
 */
package apoc.load.xls;

import apoc.Extended;
import apoc.export.util.CountingInputStream;
import apoc.load.xls.LoadXlsHandler;
import apoc.meta.Types;
import apoc.util.DateParseUtil;
import apoc.util.ExtendedUtil;
import apoc.util.FileUtils;
import apoc.util.MissingDependencyException;
import apoc.util.Util;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class LoadXls {
    public static final char DEFAULT_ARRAY_SEP = ';';
    @Context
    public GraphDatabaseService db;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(value="apoc.load.xls")
    @Description(value="apoc.load.xls('url','selector',{config}) YIELD lineNo, list, map - load XLS fom URL as stream of row values,\n config contains any of: {skip:1,limit:5,header:false,ignore:['tmp'],arraySep:';',mapping:{years:{type:'int',arraySep:'-',array:false,name:'age',ignore:false, dateFormat:'iso_date', dateParse:['dd-MM-yyyy']}}")
    public Stream<XLSResult> xls(@Name(value="url") String url, @Name(value="selector") String selector, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        Stream<XLSResult> stream;
        block10: {
            boolean failOnError = this.booleanValue(config, "failOnError", true);
            CountingInputStream stream2 = FileUtils.inputStreamFor((Object)url, null, null, null, (URLAccessChecker)this.urlAccessChecker);
            try {
                Selection selection = new Selection(selector);
                char arraySep = this.separator(config, "arraySep", ';');
                long skip = this.longValue(config, "skip", 0L);
                boolean hasHeader = this.booleanValue(config, "header", true);
                boolean skipNulls = this.booleanValue(config, "skipNulls", false);
                long limit = this.longValue(config, "limit", Long.MAX_VALUE);
                List<String> ignore = this.value(config, "ignore", Collections.emptyList());
                List<Object> nullValues = this.value(config, "nullValues", Collections.emptyList());
                Map<String, Map<String, Object>> mapping = this.value(config, "mapping", Collections.emptyMap());
                Map<String, Mapping> mappings = this.createMapping(mapping, arraySep, ignore);
                LoadXlsHandler.XLSSpliterator xlsSpliterator = LoadXlsHandler.getXlsSpliterator(url, stream2, selection, skip, hasHeader, limit, ignore, nullValues, mappings, skipNulls);
                stream = StreamSupport.stream(xlsSpliterator, false);
                if (stream2 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream2 != null) {
                        try {
                            stream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoClassDefFoundError e) {
                    throw new MissingDependencyException("Cannot find the needed jar into the plugins folder in order to use . \nPlease see the documentation: https://neo4j.com/labs/apoc/5/overview/apoc.export/apoc.export.xls.all/#_install_dependencies");
                }
                catch (Exception e) {
                    if (!failOnError) {
                        return Stream.of(new XLSResult(new String[0], new Object[0], 0L, true, Collections.emptyMap(), Collections.emptyList()));
                    }
                    throw new RuntimeException("Can't read XLS from URL " + Util.cleanUrl((String)url), e);
                }
            }
            stream2.close();
        }
        return stream;
    }

    private Map<String, Mapping> createMapping(Map<String, Map<String, Object>> mapping, char arraySep, List<String> ignore) {
        if (mapping.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Mapping> result = new HashMap<String, Mapping>(mapping.size());
        for (Map.Entry<String, Map<String, Object>> entry : mapping.entrySet()) {
            String name = entry.getKey();
            result.put(name, new Mapping(name, entry.getValue(), arraySep, ignore.contains(name)));
        }
        return result;
    }

    private static String[] convertFormat(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof List)) {
            throw new RuntimeException("Only array of Strings are allowed!");
        }
        List strings = (List)value;
        return strings.toArray(new String[strings.size()]);
    }

    private boolean booleanValue(Map<String, Object> config, String key, boolean defaultValue) {
        if (config == null || !config.containsKey(key)) {
            return defaultValue;
        }
        Object value = config.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    private long longValue(Map<String, Object> config, String key, long defaultValue) {
        if (config == null || !config.containsKey(key)) {
            return defaultValue;
        }
        Object value = config.get(key);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    private <T> T value(Map<String, Object> config, String key, T defaultValue) {
        if (config == null || !config.containsKey(key)) {
            return defaultValue;
        }
        return (T)config.get(key);
    }

    private char separator(Map<String, Object> config, String key, char defaultValue) {
        if (config == null) {
            return defaultValue;
        }
        Object value = config.get(key);
        if (value == null) {
            return defaultValue;
        }
        return LoadXls.separator(value.toString(), defaultValue);
    }

    private static char separator(String separator, char defaultSep) {
        if (separator == null) {
            return defaultSep;
        }
        if ("TAB".equalsIgnoreCase(separator)) {
            return '\t';
        }
        return separator.charAt(0);
    }

    static class Selection {
        private static final Pattern PATTERN = Pattern.compile("([a-z]+)(\\d+)?(?::([a-z]+)(\\d+)?)?", 2);
        private static final int DEFAULT = -1;
        String sheet;
        int top = -1;
        int left = -1;
        int bottom = -1;
        int right = -1;

        public Selection(String selector) {
            String range;
            Matcher matcher;
            String[] parts = selector.split("!");
            this.sheet = parts[0];
            if (parts.length > 1 && !parts[1].trim().isEmpty() && (matcher = PATTERN.matcher(range = parts[1].trim().replace("$", ""))).matches()) {
                this.left = this.toCol(matcher.group(1), -1);
                this.top = this.toRow(matcher.group(2), -1);
                this.right = this.toCol(matcher.group(3), this.left);
                if (this.right != -1) {
                    ++this.right;
                }
                this.bottom = this.toRow(matcher.group(4), -1);
            }
        }

        int getOrDefault(int value, int given) {
            return value == -1 ? given : value;
        }

        private int toCol(String col, int defaultValue) {
            if (col == null || col.trim().isEmpty()) {
                return defaultValue;
            }
            AtomicInteger index = new AtomicInteger(0);
            return Stream.of(col.trim().toUpperCase().split("")).map(str -> new AbstractMap.SimpleEntry<Integer, Integer>(index.getAndIncrement(), str.charAt(0) - 65)).map(e -> 26 * (Integer)e.getKey() + (Integer)e.getValue()).reduce(0, Math::addExact);
        }

        private int toRow(String row, int defaultValue) {
            if (row == null || row.trim().isEmpty()) {
                return defaultValue;
            }
            row = row.trim();
            try {
                return Integer.parseInt(row) - 1;
            }
            catch (NumberFormatException nfe) {
                return (short)defaultValue;
            }
        }

        public void updateVertical(int firstRowNum, int lastRowNum) {
            if (this.top == -1) {
                this.top = firstRowNum;
            }
            if (this.bottom == -1) {
                this.bottom = lastRowNum;
            }
        }

        public void updateHorizontal(short firstCellNum, short lastCellNum) {
            if (this.left == -1) {
                this.left = firstCellNum;
            }
            if (this.right == -1) {
                this.right = lastCellNum;
            }
        }
    }

    public static class XLSResult {
        public long lineNo;
        public List<Object> list;
        public Map<String, Object> map;

        public XLSResult(String[] header, Object[] list, long lineNo, boolean ignore, Map<String, Mapping> mapping, List<Object> nullValues) {
            this.lineNo = lineNo;
            this.removeNullValues(list, nullValues);
            this.map = this.createMap(header, list, ignore, mapping);
            this.list = this.createList(header, list, ignore, mapping);
        }

        public void removeNullValues(Object[] list, List<Object> nullValues) {
            if (nullValues.isEmpty()) {
                return;
            }
            for (int i = 0; i < list.length; ++i) {
                if (list[i] == null || !nullValues.contains(list[i])) continue;
                list[i] = null;
            }
        }

        private List<Object> createList(String[] header, Object[] list, boolean ignore, Map<String, Mapping> mappings) {
            if (!ignore && mappings.isEmpty()) {
                return Arrays.asList(list);
            }
            ArrayList<Object> result = new ArrayList<Object>(list.length);
            for (int i = 0; i < header.length; ++i) {
                String name = header[i];
                if (name == null) continue;
                Mapping mapping = mappings.get(name);
                if (mapping != null) {
                    if (mapping.ignore) continue;
                    result.add(mapping.convert(list[i]));
                    continue;
                }
                result.add(list[i]);
            }
            return result;
        }

        private Map<String, Object> createMap(String[] header, Object[] list, boolean ignore, Map<String, Mapping> mappings) {
            if (header == null) {
                return null;
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(header.length, 1.0f);
            for (int i = 0; i < header.length; ++i) {
                String name = header[i];
                if (ignore && name == null) continue;
                Mapping mapping = mappings.get(name);
                if (mapping == null) {
                    map.put(name, list[i]);
                    continue;
                }
                if (mapping.ignore) continue;
                map.put(mapping.name, mapping.convert(list[i]));
            }
            return map;
        }
    }

    static class Mapping {
        public static final Mapping EMPTY = new Mapping("", Collections.emptyMap(), ';', false);
        final String name;
        final Collection<Object> nullValues;
        final Types type;
        final boolean array;
        final boolean ignore;
        final char arraySep;
        final String dateFormat;
        private final String[] dateParse;
        private final Pattern arrayPattern;

        public Mapping(String name, Map<String, Object> mapping, char arraySep, boolean ignore) {
            this.name = mapping.getOrDefault("name", name).toString();
            this.array = (Boolean)mapping.getOrDefault("array", false);
            this.ignore = (Boolean)mapping.getOrDefault("ignore", ignore);
            this.nullValues = mapping.getOrDefault("nullValues", Collections.emptyList());
            this.arraySep = LoadXls.separator(mapping.getOrDefault("arraySep", Character.valueOf(arraySep)).toString(), ';');
            this.type = Types.from((String)mapping.getOrDefault("type", "STRING").toString());
            this.arrayPattern = Pattern.compile(String.valueOf(this.arraySep), 16);
            this.dateFormat = mapping.getOrDefault("dateFormat", "").toString();
            this.dateParse = LoadXls.convertFormat(mapping.getOrDefault("dateParse", null));
        }

        public Object convert(Object value) {
            return this.array ? this.convertArray(value) : this.convertType(value);
        }

        private Object convertArray(Object value) {
            if (value == null) {
                return Collections.emptyList();
            }
            String[] values = this.arrayPattern.split(value.toString());
            ArrayList<Object> result = new ArrayList<Object>(values.length);
            for (String v : values) {
                result.add(this.convertType(v));
            }
            return result;
        }

        private Object convertType(Object value) {
            if (this.nullValues.contains(value) || value == null) {
                return null;
            }
            switch (this.type) {
                case STRING: {
                    if (value instanceof TemporalAccessor && !this.dateFormat.isEmpty()) {
                        return ExtendedUtil.dateFormat((TemporalAccessor)value, this.dateFormat);
                    }
                    return value.toString();
                }
                case INTEGER: {
                    return Util.toLong((Object)value);
                }
                case FLOAT: {
                    return Util.toDouble((Object)value);
                }
                case BOOLEAN: {
                    return Util.toBoolean((Object)value);
                }
                case NULL: {
                    return null;
                }
                case LIST: {
                    return Arrays.stream(this.arrayPattern.split(value.toString())).map(this::convertType).collect(Collectors.toList());
                }
                case DATE: {
                    return DateParseUtil.dateParse((String)value.toString(), LocalDate.class, (String[])this.dateParse);
                }
                case DATE_TIME: {
                    return DateParseUtil.dateParse((String)value.toString(), ZonedDateTime.class, (String[])this.dateParse);
                }
                case LOCAL_DATE_TIME: {
                    return DateParseUtil.dateParse((String)value.toString(), LocalDateTime.class, (String[])this.dateParse);
                }
                case LOCAL_TIME: {
                    return DateParseUtil.dateParse((String)value.toString(), LocalTime.class, (String[])this.dateParse);
                }
                case TIME: {
                    return DateParseUtil.dateParse((String)value.toString(), OffsetTime.class, (String[])this.dateParse);
                }
                case DURATION: {
                    return ExtendedUtil.durationParse(value.toString());
                }
            }
            return value;
        }
    }

    static enum Results {
        map,
        list,
        strings,
        stringMap;

    }
}

