/*
 * Decompiled with CFR 0.152.
 */
package apoc.log;

import apoc.Extended;
import apoc.ExtendedApocConfig;
import java.util.List;
import java.util.function.Consumer;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class Logging {
    @Context
    public Log log;
    @Context
    public ExtendedApocConfig extendedApocConfig;

    @Procedure
    @Description(value="apoc.log.error(message, params) - logs error message")
    public void error(@Name(value="message") String message, @Name(value="params", defaultValue="[]") List<Object> params) {
        this.log(logMessage -> this.log.error(logMessage), message, params);
    }

    @Procedure
    @Description(value="apoc.log.warn(message, params) - logs warn message")
    public void warn(@Name(value="message") String message, @Name(value="params", defaultValue="[]") List<Object> params) {
        this.log(logMessage -> this.log.warn(logMessage), message, params);
    }

    @Procedure
    @Description(value="apoc.log.info(message, params) - logs info message")
    public void info(@Name(value="message") String message, @Name(value="params", defaultValue="[]") List<Object> params) {
        this.log(logMessage -> this.log.info(logMessage), message, params);
    }

    @Procedure
    @Description(value="apoc.log.debug(message, params) - logs debug message")
    public void debug(@Name(value="message") String message, @Name(value="params", defaultValue="[]") List<Object> params) {
        this.log(logMessage -> this.log.debug(logMessage), message, params);
    }

    public String format(String message, List<Object> params) {
        if (this.canLog()) {
            String formattedMessage = String.format(message, params.isEmpty() ? new Object[]{} : params.toArray(new Object[params.size()]));
            if (ExtendedApocConfig.LoggingType.safe == this.extendedApocConfig.getLoggingType()) {
                return formattedMessage.replaceAll("\\.| |\\t", "_").toLowerCase();
            }
            return formattedMessage;
        }
        return null;
    }

    private void log(Consumer<String> consumer, String message, List<Object> params) {
        String format = this.format(message, params);
        if (format != null) {
            consumer.accept(format);
        }
    }

    private boolean canLog() {
        if (ExtendedApocConfig.LoggingType.none == this.extendedApocConfig.getLoggingType()) {
            return false;
        }
        return this.extendedApocConfig.getRateLimiter().canExecute();
    }
}

