/*
 * Decompiled with CFR 0.152.
 */
package apoc.map;

import apoc.Extended;
import apoc.util.Util;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

@Extended
public class MapsExtended {
    @UserFunction(value="apoc.map.renameKey")
    @Description(value="Rename the given key(s) in the `MAP`.")
    public Map<String, Object> renameKeyRecursively(@Name(value="map") Map<String, Object> map, @Name(value="keyFrom") String keyFrom, @Name(value="keyTo") String keyTo, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        boolean recursive = Util.toBoolean((Object)config.getOrDefault("recursive", true));
        if (recursive) {
            return (Map)this.renameKeyRecursively(map, keyFrom, keyTo);
        }
        if (map.containsKey(keyFrom)) {
            Object value = map.remove(keyFrom);
            map.put(keyTo, value);
        }
        return map;
    }

    private Object renameKeyRecursively(Object object, String keyFrom, String keyTo) {
        if (object instanceof Map) {
            return ((Map)object).entrySet().stream().collect(Collectors.toMap(e -> {
                String key = (String)e.getKey();
                return key.equals(keyFrom) ? keyTo : key;
            }, e -> this.renameKeyRecursively(e.getValue(), keyFrom, keyTo)));
        }
        if (object instanceof List) {
            List subList = (List)object;
            return subList.stream().map(v -> this.renameKeyRecursively(v, keyFrom, keyTo)).toList();
        }
        return object;
    }
}

