/*
 * Decompiled with CFR 0.152.
 */
package apoc.ml;

import apoc.ApocConfig;
import apoc.ml.OpenAI;
import apoc.ml.OpenAIRequestHandler;
import apoc.result.ObjectResult;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class MixedbreadAI {
    public static final String ENDPOINT_CONF_KEY = "endpoint";
    public static final String DEFAULT_MODEL_ID = "mxbai-embed-large-v1";
    public static final String MIXEDBREAD_BASE_URL = "https://api.mixedbread.ai/v1";
    public static final String ERROR_MSG_MISSING_ENDPOINT = "The endpoint must be defined via config `%s` or via apoc.conf `%s`".formatted("endpoint", "apoc.ml.openai.url");
    public static final String ERROR_MSG_MISSING_MODELID = "The model must be defined via config `%s`".formatted("model");
    @Context
    public URLAccessChecker urlAccessChecker;
    @Context
    public ApocConfig apocConfig;

    @Procedure(value="apoc.ml.mixedbread.custom")
    @Description(value="apoc.mixedbread.custom(, configuration) - returns the embeddings for a given text")
    public Stream<ObjectResult> custom(@Name(value="api_key") String apiKey, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        if (!configuration.containsKey("model")) {
            throw new RuntimeException(ERROR_MSG_MISSING_MODELID);
        }
        configuration.put("apiType", OpenAIRequestHandler.Type.MIXEDBREAD_CUSTOM.name());
        return OpenAI.executeRequest(apiKey, configuration, null, null, null, null, null, this.apocConfig, this.urlAccessChecker).map(ObjectResult::new);
    }

    @Procedure(value="apoc.ml.mixedbread.embedding")
    @Description(value="apoc.mixedbread.mixedbread([texts], api_key, configuration) - returns the embeddings for a given text")
    public Stream<EmbeddingResult> getEmbedding(@Name(value="texts") List<String> texts, @Name(value="api_key") String apiKey, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        configuration.putIfAbsent("model", DEFAULT_MODEL_ID);
        configuration.put("apiType", OpenAIRequestHandler.Type.MIXEDBREAD_EMBEDDING.name());
        return OpenAI.getEmbeddingResult(texts, apiKey, configuration, this.apocConfig, this.urlAccessChecker, (map, text) -> {
            Long index = (Long)map.get("index");
            return new EmbeddingResult(index, (String)text, map.get("embedding"));
        }, m -> new EmbeddingResult(-1L, (String)m, List.of()));
    }

    public record EmbeddingResult(long index, String text, Object embedding) {
    }
}

