/*
 * Decompiled with CFR 0.152.
 */
package apoc.ml;

import apoc.util.Util;
import java.util.Map;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;

public class RagConfig {
    public static final String UNKNOWN_ANSWER = "Sorry, I don't know";
    public static final String DEFAULT_BASE_PROMPT = "You are a customer service agent that helps a customer with answering questions about a service.\nUse the following context to answer the `user question` at the end. Make sure not to make any changes to the context if possible when prepare answers to provide accurate responses.\nIf you don't know the answer, just say `%s`, don't try to make up an answer.\n".formatted("Sorry, I don't know");
    public static final String EMBEDDINGS_CONF = "embeddings";
    public static final String GET_LABEL_TYPES_CONF = "getLabelTypes";
    public static final String TOP_K_CONF = "topK";
    public static final String PROMPT_CONF = "prompt";
    private final boolean getLabelTypes;
    private final EmbeddingQuery embeddings;
    private final Integer topK;
    private final String apiKey;
    private final String basePrompt;
    private final Map<String, Object> confMap;

    public RagConfig(Map<String, Object> confMap) {
        if (confMap == null) {
            confMap = Map.of();
        }
        this.confMap = confMap;
        this.getLabelTypes = Util.toBoolean((Object)confMap.getOrDefault(GET_LABEL_TYPES_CONF, true));
        String embeddingString = (String)confMap.getOrDefault(EMBEDDINGS_CONF, EmbeddingQuery.Type.FALSE.name());
        this.embeddings = EmbeddingQuery.Type.valueOf(embeddingString).get();
        this.topK = Util.toInteger((Object)confMap.getOrDefault(TOP_K_CONF, 40));
        this.apiKey = (String)confMap.get("apiKey");
        this.basePrompt = (String)confMap.getOrDefault(PROMPT_CONF, DEFAULT_BASE_PROMPT);
    }

    public boolean isGetLabelTypes() {
        return this.getLabelTypes;
    }

    public EmbeddingQuery getEmbeddings() {
        return this.embeddings;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getBasePrompt() {
        return this.basePrompt;
    }

    public Map<String, Object> getConfMap() {
        return this.confMap;
    }

    public static interface EmbeddingQuery {
        public static final String BASE_EMBEDDING_QUERY = "CALL apoc.ml.openai.embedding([$question], $key , $conf)\nYIELD index, text, embedding\nWITH text, embedding\n";

        public Result getQuery(String var1, String var2, Transaction var3, RagConfig var4);

        default public Map<String, Object> getParams(String queryOrIndex, String question, RagConfig config) {
            return Map.of("vectorIndex", queryOrIndex, RagConfig.TOP_K_CONF, config.getTopK(), "question", question, "key", config.getApiKey(), "conf", config.getConfMap());
        }

        public static class Rel
        implements EmbeddingQuery {
            @Override
            public Result getQuery(String queryOrIndex, String question, Transaction tx, RagConfig config) {
                return tx.execute("CALL apoc.ml.openai.embedding([$question], $key , $conf)\nYIELD index, text, embedding\nWITH text, embedding\nCALL db.index.vector.queryRelationships($vectorIndex, $topK, embedding) YIELD relationship\nRETURN relationship", this.getParams(queryOrIndex, question, config));
            }
        }

        public static class Node
        implements EmbeddingQuery {
            @Override
            public Result getQuery(String queryOrIndex, String question, Transaction tx, RagConfig config) {
                return tx.execute("CALL apoc.ml.openai.embedding([$question], $key , $conf)\nYIELD index, text, embedding\nWITH text, embedding\nCALL db.index.vector.queryNodes($vectorIndex, $topK, embedding) YIELD node\nRETURN node", this.getParams(queryOrIndex, question, config));
            }
        }

        public static class False
        implements EmbeddingQuery {
            @Override
            public Result getQuery(String queryOrIndex, String question, Transaction tx, RagConfig config) {
                return tx.execute(queryOrIndex);
            }
        }

        public static enum Type {
            NODE(new Node()),
            REL(new Rel()),
            FALSE(new False());

            private final EmbeddingQuery embedding;

            private Type(EmbeddingQuery embedding) {
                this.embedding = embedding;
            }

            public EmbeddingQuery get() {
                return this.embedding;
            }
        }
    }
}

