/*
 * Decompiled with CFR 0.152.
 */
package apoc.ml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RestAPIConfig {
    public static final String HEADERS_KEY = "headers";
    public static final String METHOD_KEY = "method";
    public static final String ENDPOINT_KEY = "endpoint";
    public static final String JSON_PATH_KEY = "jsonPath";
    public static final String BODY_KEY = "body";
    public static final String BASE_URL_KEY = "baseUrl";
    private final String baseUrl;
    private Map<String, Object> headers;
    private Map body;
    private String endpoint;
    private String jsonPath;

    public RestAPIConfig(Map<String, Object> config) {
        this(config, Map.of(), Map.of());
    }

    public RestAPIConfig(Map<String, Object> config, Map additionalHeaders, Map additionalBodies) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        String httpMethod = (String)config.getOrDefault(METHOD_KEY, "POST");
        this.headers = RestAPIConfig.populateHeaders(config, additionalHeaders, httpMethod);
        this.endpoint = (String)config.get(ENDPOINT_KEY);
        this.baseUrl = (String)config.get(BASE_URL_KEY);
        this.jsonPath = (String)config.get(JSON_PATH_KEY);
        this.body = RestAPIConfig.populateBody(config, additionalBodies);
    }

    private static Map<String, Object> populateHeaders(Map<String, Object> config, Map additionalHeaders, String httpMethod) {
        Map headerConf = config.getOrDefault(HEADERS_KEY, new HashMap());
        headerConf.putIfAbsent("content-type", "application/json");
        headerConf.putIfAbsent(METHOD_KEY, httpMethod);
        additionalHeaders.forEach(headerConf::putIfAbsent);
        return headerConf;
    }

    private static Map populateBody(Map<String, Object> config, Map additionalBodies) {
        Map bodyConf = config.getOrDefault(BODY_KEY, new HashMap());
        if (bodyConf != null) {
            additionalBodies.forEach(bodyConf::putIfAbsent);
        }
        return bodyConf;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getJsonPath() {
        return this.jsonPath;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public void setBody(Map<String, Object> body) {
        this.body = body;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setJsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
    }
}

