/*
 * Decompiled with CFR 0.152.
 */
package apoc.ml;

import apoc.ApocConfig;
import apoc.Extended;
import apoc.ml.VertexAIHandler;
import apoc.result.MapResult;
import apoc.result.ObjectResult;
import apoc.util.JsonUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class VertexAI {
    @Context
    public URLAccessChecker urlAccessChecker;
    @Context
    public ApocConfig apocConfig;

    private Stream<Object> executeRequest(String accessToken, String project, Map<String, Object> configuration, String defaultModel, Object inputs, Collection<String> retainConfigKeys, URLAccessChecker urlAccessChecker) throws JsonProcessingException, MalformedURLException {
        return this.executeRequest(accessToken, project, configuration, defaultModel, inputs, retainConfigKeys, urlAccessChecker, VertexAIHandler.Type.PREDICT);
    }

    private Stream<Object> executeRequest(String accessToken, String project, Map<String, Object> configuration, String defaultModel, Object inputs, Collection<String> retainConfigKeys, URLAccessChecker urlAccessChecker, VertexAIHandler.Type vertexAIHandlerType) throws JsonProcessingException {
        if (accessToken == null || accessToken.isBlank()) {
            throw new IllegalArgumentException("Access Token must not be empty");
        }
        Map headers = configuration.getOrDefault("headers", new HashMap());
        headers.putIfAbsent("Content-Type", "application/json");
        headers.putIfAbsent("Accept", "application/json");
        headers.putIfAbsent("Authorization", "Bearer " + accessToken);
        VertexAIHandler vertexAIHandler = vertexAIHandlerType.get();
        Map<String, Object> data2 = vertexAIHandler.getBody(inputs, configuration, retainConfigKeys);
        String payload = new ObjectMapper().writeValueAsString(data2);
        String url = vertexAIHandler.getFullUrl(configuration, this.apocConfig, defaultModel, project);
        String jsonPath = vertexAIHandler.getJsonPath();
        return JsonUtil.loadJson((Object)url, (Map)headers, (String)payload, (String)jsonPath, (boolean)true, List.of(), (URLAccessChecker)urlAccessChecker);
    }

    @Procedure(value="apoc.ml.vertexai.embedding")
    @Description(value="apoc.vertexai.embedding([texts], accessToken, project, configuration) - returns the embeddings for a given text")
    public Stream<EmbeddingResult> getEmbedding(@Name(value="texts") List<String> texts, @Name(value="accessToken") String accessToken, @Name(value="project") String project, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        if (texts == null) {
            throw new RuntimeException("Null, blank or empty input provided. Please specify a valid input");
        }
        Map<Boolean, List<String>> collect = texts.stream().collect(Collectors.groupingBy(Objects::nonNull));
        List<String> nonNullTexts = collect.get(true);
        List<Map> inputs = texts.stream().map(text -> Map.of("content", text)).toList();
        Stream<Object> resultStream = this.executeRequest(accessToken, project, configuration, "textembedding-gecko", inputs, List.of(), this.urlAccessChecker);
        AtomicInteger ai = new AtomicInteger();
        Stream<EmbeddingResult> embeddingResultStream = resultStream.flatMap(v -> ((List)v).stream()).map(m -> {
            Map embeddings = (Map)m.get("embeddings");
            int index = ai.getAndIncrement();
            return new EmbeddingResult(index, (String)nonNullTexts.get(index), (List)embeddings.get("values"));
        });
        List nullTexts = collect.getOrDefault(false, List.of());
        Stream<EmbeddingResult> nullResultStream = nullTexts.stream().map(text -> new EmbeddingResult(-1L, (String)text, List.of()));
        return Stream.concat(embeddingResultStream, nullResultStream);
    }

    @Procedure(value="apoc.ml.vertexai.completion")
    @Description(value="apoc.ml.vertexai.completion(prompt, accessToken, project, configuration) - prompts the completion API")
    public Stream<MapResult> completion(@Name(value="prompt") String prompt, @Name(value="accessToken") String accessToken, @Name(value="project") String project, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        if (prompt == null) {
            throw new RuntimeException("Null, blank or empty input provided. Please specify a valid input");
        }
        List<Map<String, String>> input = List.of(Map.of("prompt", prompt));
        List<String> parameterKeys = List.of("temperature", "topK", "topP", "maxOutputTokens");
        Stream<Object> resultStream = this.executeRequest(accessToken, project, configuration, "text-bison", input, parameterKeys, this.urlAccessChecker);
        return resultStream.flatMap(v -> ((List)v).stream()).map(v -> v).map(MapResult::new);
    }

    public static Map<String, Object> getParameters(Map<String, Object> config, Collection<String> retainKeys) {
        HashMap<String, Object> result = new HashMap<String, Object>(Map.of("temperature", config.getOrDefault("temperature", 0.3), "maxOutputTokens", config.getOrDefault("maxOutputTokens", 256), "maxDecodeSteps", config.getOrDefault("maxDecodeSteps", 200), "topP", config.getOrDefault("topP", 0.8), "topK", config.getOrDefault("topK", 40)));
        result.keySet().retainAll(retainKeys);
        return result;
    }

    @Procedure(value="apoc.ml.vertexai.chat")
    @Description(value="apoc.ml.vertexai.chat(messages, accessToken, project, configuration]) - prompts the completion API")
    public Stream<MapResult> chatCompletion(@Name(value="messages") List<Map<String, String>> messages, @Name(value="accessToken") String accessToken, @Name(value="project") String project, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration, @Name(value="context", defaultValue="") String context, @Name(value="examples", defaultValue="[]") List<Map<String, Map<String, String>>> examples) throws Exception {
        if (messages == null) {
            throw new RuntimeException("Null, blank or empty input provided. Please specify a valid input");
        }
        List<Map<String, List<Map<String, String>>>> inputs = List.of(Map.of("context", context, "examples", examples, "messages", messages));
        List<String> parameterKeys = List.of("temperature", "topK", "topP", "maxOutputTokens");
        return this.executeRequest(accessToken, project, configuration, "chat-bison", inputs, parameterKeys, this.urlAccessChecker).flatMap(v -> ((List)v).stream()).map(v -> v).map(MapResult::new);
    }

    @Procedure(value="apoc.ml.vertexai.stream")
    @Description(value="apoc.ml.vertexai.stream(contents, accessToken, project, configuration) - prompts the streaming API")
    public Stream<MapResult> stream(@Name(value="messages") List<Map<String, String>> contents, @Name(value="accessToken") String accessToken, @Name(value="project") String project, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        List<String> parameterKeys = List.of("temperature", "topK", "topP", "maxOutputTokens");
        return this.executeRequest(accessToken, project, configuration, "gemini-pro", contents, parameterKeys, this.urlAccessChecker, VertexAIHandler.Type.STREAM).flatMap(v -> ((List)v).stream()).map(MapResult::new);
    }

    @Procedure(value="apoc.ml.vertexai.custom")
    @Description(value="apoc.ml.vertexai.custom(contents, accessToken, project, configuration) - prompts a customizable API")
    public Stream<ObjectResult> custom(@Name(value="body") Map<String, Object> body, @Name(value="accessToken") String accessToken, @Name(value="project") String project, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        return this.executeRequest(accessToken, project, configuration, "gemini-pro", body, Collections.emptyList(), this.urlAccessChecker, VertexAIHandler.Type.CUSTOM).map(ObjectResult::new);
    }

    public static class EmbeddingResult {
        public final long index;
        public final String text;
        public final List<Double> embedding;

        public EmbeddingResult(long index, String text, List<Double> embedding) {
            this.index = index;
            this.text = text;
            this.embedding = embedding;
        }
    }
}

