/*
 * Decompiled with CFR 0.152.
 */
package apoc.ml.aws;

import apoc.ApocConfig;
import java.util.HashMap;
import java.util.Map;

public abstract class AWSConfig {
    public static final String HEADERS_KEY = "headers";
    public static final String BODY_KEY = "body";
    public static final String JSON_PATH = "jsonPath";
    public static final String SECRET_KEY = "secretKey";
    public static final String KEY_ID = "keyId";
    public static final String METHOD_KEY = "method";
    private final String keyId;
    private final String secretKey;
    private final String region;
    private final String endpoint;
    private final String method;
    private final String jsonPath;
    private final Map<String, Object> headers;
    private final Map<String, Object> body;

    abstract String getDefaultEndpoint(Map<String, Object> var1);

    abstract String getDefaultMethod();

    protected AWSConfig(Map<String, Object> config) {
        config = config == null ? Map.of() : config;
        this.keyId = ApocConfig.apocConfig().getString("apoc.aws.key.id", (String)config.get(KEY_ID));
        this.secretKey = ApocConfig.apocConfig().getString("apoc.aws.secret.key", (String)config.get(SECRET_KEY));
        this.region = (String)config.getOrDefault("region", "us-east-1");
        this.endpoint = this.getEndpoint(config, this.getDefaultEndpoint(config));
        this.method = (String)config.getOrDefault(METHOD_KEY, this.getDefaultMethod());
        this.jsonPath = (String)config.get(JSON_PATH);
        this.headers = config.getOrDefault(HEADERS_KEY, new HashMap());
        this.body = config.getOrDefault(BODY_KEY, new HashMap());
    }

    private String getEndpoint(Map<String, Object> config, String defaultEndpoint) {
        String endpointConfig = (String)config.get("endpoint");
        if (endpointConfig != null) {
            return endpointConfig;
        }
        if (defaultEndpoint != null) {
            return defaultEndpoint;
        }
        String errMessage = String.format("An endpoint could not be retrieved.\nExplicit the %s config", "endpoint");
        throw new RuntimeException(errMessage);
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getRegion() {
        return this.region;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    public String getJsonPath() {
        return this.jsonPath;
    }
}

