/*
 * Decompiled with CFR 0.152.
 */
package apoc.ml.watson;

import apoc.ApocConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public interface WatsonHandler {
    public String getDefaultMethod();

    public Map<String, Object> getPayload(Map<String, Object> var1, Object var2);

    default public String getEndpoint(Map<String, Object> config) {
        Object endpoint = config.remove("endpoint");
        if (endpoint != null) {
            return (String)endpoint;
        }
        String version = Objects.requireNonNullElse(config.remove("apiVersion"), "2023-05-29");
        String region = Objects.requireNonNullElse(config.remove("region"), "region");
        String url = "https://%s.ml.cloud.ibm.com/ml/v1/%s?version=%s".formatted(region, this.getDefaultMethod(), version);
        return ApocConfig.apocConfig().getString("apoc.ml.watson.url", url);
    }

    public static class CompletionHandler
    implements WatsonHandler {
        @Override
        public String getDefaultMethod() {
            return "text/generation";
        }

        @Override
        public Map<String, Object> getPayload(Map<String, Object> configuration, Object input) {
            HashMap<String, Object> config = new HashMap<String, Object>(configuration);
            config.putIfAbsent("model_id", "ibm/granite-13b-chat-v2");
            config.put("input", input);
            return config;
        }
    }

    public static class EmbeddingHandler
    implements WatsonHandler {
        @Override
        public String getDefaultMethod() {
            return "text/embeddings";
        }

        @Override
        public Map<String, Object> getPayload(Map<String, Object> configuration, Object input) {
            HashMap<String, Object> config = new HashMap<String, Object>(configuration);
            config.putIfAbsent("model_id", "ibm/slate-30m-english-rtrvr");
            config.put("inputs", input);
            return config;
        }
    }

    public static enum Type {
        EMBEDDING(new EmbeddingHandler()),
        COMPLETION(new CompletionHandler());

        private final WatsonHandler handler;

        private Type(WatsonHandler handler) {
            this.handler = handler;
        }

        public WatsonHandler get() {
            return this.handler;
        }
    }
}

