/*
 * Decompiled with CFR 0.152.
 */
package apoc.nlp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0001J\u001a\u0010\f\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006J\u001a\u0010\r\u001a\u00020\u00072\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006J2\u0010\u000e\u001a\u00020\u00012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u001a\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006J2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0007J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0004J(\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001d\u001a\u00020\u001eJ\"\u0010\u001f\u001a\u00020 2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010!\u001a\u00020\u0007J3\u0010\"\u001a\u00020 2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070$\"\u00020\u0007\u00a2\u0006\u0002\u0010%J\u0016\u0010&\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u0007J\u0018\u0010&\u001a\u00020 2\u0006\u0010(\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0007H\u0002J\u000e\u0010)\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\u0001\u00a8\u0006*"}, d2={"Lapoc/nlp/NLPHelperFunctions;", "", "()V", "categoryRelationshipType", "Lorg/neo4j/graphdb/RelationshipType;", "config", "", "", "convert", "", "Lorg/neo4j/graphdb/Node;", "source", "entityRelationshipType", "getNodeProperty", "getSelectedType", "keys", "default", "keyPhraseRelationshipType", "mergeRelationship", "Lorg/neo4j/graphdb/Relationship;", "sourceNode", "nodesAndScore", "Lkotlin/Pair;", "", "relationshipType", "relProperty", "targetNode", "partition", "nodes", "size", "", "verifyKey", "", "property", "verifyKeys", "properties", "", "(Ljava/util/Map;[Ljava/lang/String;)V", "verifyNodeProperty", "nodeProperty", "node", "verifySource", "apoc"})
@SourceDebugExtension(value={"SMAP\nNLPHelperFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NLPHelperFunctions.kt\napoc/nlp/NLPHelperFunctions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,118:1\n1549#2:119\n1620#2,3:120\n1855#2,2:123\n1855#2,2:125\n1549#2:129\n1620#2,3:130\n13309#3,2:127\n*S KotlinDebug\n*F\n+ 1 NLPHelperFunctions.kt\napoc/nlp/NLPHelperFunctions\n*L\n59#1:119\n59#1:120,3\n64#1:123,2\n76#1:125,2\n100#1:129\n100#1:130,3\n88#1:127,2\n*E\n"})
public final class NLPHelperFunctions {
    @NotNull
    public static final NLPHelperFunctions INSTANCE = new NLPHelperFunctions();

    private NLPHelperFunctions() {
    }

    @NotNull
    public final Relationship mergeRelationship(@NotNull Node sourceNode, @NotNull Pair<? extends Node, ? extends Number> nodesAndScore, @NotNull RelationshipType relationshipType, @NotNull String relProperty) {
        Relationship relationship;
        Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
        Intrinsics.checkNotNullParameter(nodesAndScore, (String)"nodesAndScore");
        Intrinsics.checkNotNullParameter((Object)relationshipType, (String)"relationshipType");
        Intrinsics.checkNotNullParameter((Object)relProperty, (String)"relProperty");
        Relationship relationship2 = new Relationship[]{relationshipType};
        ResourceIterable resourceIterable = sourceNode.getRelationships(Direction.OUTGOING, (RelationshipType[])relationship2);
        Intrinsics.checkNotNullExpressionValue((Object)resourceIterable, (String)"getRelationships(...)");
        Stream existingRelationships = StreamsKt.asStream((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)resourceIterable)));
        Optional<Object> potentialRelationship2 = existingRelationships.filter(arg_0 -> NLPHelperFunctions.mergeRelationship$lambda$0((Function1)new Function1<Relationship, Boolean>(nodesAndScore){
            final /* synthetic */ Pair<Node, Number> $nodesAndScore;
            {
                this.$nodesAndScore = $nodesAndScore;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Relationship r) {
                return Intrinsics.areEqual((Object)r.getEndNode(), (Object)this.$nodesAndScore.getFirst());
            }
        }, arg_0)).findFirst();
        if (potentialRelationship2.isPresent()) {
            Object object = potentialRelationship2.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            Relationship relationship3 = (Relationship)object;
            double d = ((Number)nodesAndScore.getSecond()).doubleValue();
            Object object2 = relationship3.getProperty(relProperty);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Number");
            if (d > ((Number)object2).doubleValue()) {
                relationship3.setProperty(relProperty, nodesAndScore.getSecond());
            }
            relationship = relationship3;
        } else {
            Relationship relationship4 = sourceNode.createRelationshipTo((Node)nodesAndScore.getFirst(), relationshipType);
            relationship4.setProperty(relProperty, nodesAndScore.getSecond());
            relationship2 = relationship4;
            Intrinsics.checkNotNull((Object)relationship2);
            relationship = relationship2;
        }
        return relationship;
    }

    @NotNull
    public final Relationship mergeRelationship(@NotNull Node sourceNode, @NotNull Node targetNode, @NotNull RelationshipType relationshipType) {
        Relationship relationship;
        Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
        Intrinsics.checkNotNullParameter((Object)targetNode, (String)"targetNode");
        Intrinsics.checkNotNullParameter((Object)relationshipType, (String)"relationshipType");
        Relationship relationship2 = new Relationship[]{relationshipType};
        ResourceIterable resourceIterable = sourceNode.getRelationships(Direction.OUTGOING, (RelationshipType[])relationship2);
        Intrinsics.checkNotNullExpressionValue((Object)resourceIterable, (String)"getRelationships(...)");
        Stream existingRelationships = StreamsKt.asStream((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)resourceIterable)));
        Optional<Object> potentialRelationship2 = existingRelationships.filter(arg_0 -> NLPHelperFunctions.mergeRelationship$lambda$1((Function1)new Function1<Relationship, Boolean>(targetNode){
            final /* synthetic */ Node $targetNode;
            {
                this.$targetNode = $targetNode;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Relationship r) {
                return Intrinsics.areEqual((Object)r.getEndNode(), (Object)this.$targetNode);
            }
        }, arg_0)).findFirst();
        if (potentialRelationship2.isPresent()) {
            Relationship relationship3;
            Object object = potentialRelationship2.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            relationship = relationship3 = (Relationship)object;
        } else {
            Relationship relationship4;
            relationship2 = relationship4 = sourceNode.createRelationshipTo(targetNode, relationshipType);
            Intrinsics.checkNotNull((Object)relationship2);
            relationship = relationship2;
        }
        return relationship;
    }

    @NotNull
    public final RelationshipType entityRelationshipType(@NotNull Map<String, ? extends Object> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Object[] objectArray = new String[]{"writeRelationshipType", "relationshipType"};
        Object selectedType = this.getSelectedType(config, CollectionsKt.listOf((Object[])objectArray), "ENTITY");
        RelationshipType relationshipType = RelationshipType.withName((String)selectedType.toString());
        Intrinsics.checkNotNullExpressionValue((Object)relationshipType, (String)"withName(...)");
        return relationshipType;
    }

    @NotNull
    public final RelationshipType categoryRelationshipType(@NotNull Map<String, ? extends Object> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Object[] objectArray = new String[]{"writeRelationshipType", "relationshipType"};
        Object selectedType = this.getSelectedType(config, CollectionsKt.listOf((Object[])objectArray), "CATEGORY");
        RelationshipType relationshipType = RelationshipType.withName((String)selectedType.toString());
        Intrinsics.checkNotNullExpressionValue((Object)relationshipType, (String)"withName(...)");
        return relationshipType;
    }

    @NotNull
    public final RelationshipType keyPhraseRelationshipType(@NotNull Map<String, ? extends Object> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Object[] objectArray = new String[]{"writeRelationshipType", "relationshipType"};
        Object selectedType = this.getSelectedType(config, CollectionsKt.listOf((Object[])objectArray), "KEY_PHRASE");
        RelationshipType relationshipType = RelationshipType.withName((String)selectedType.toString());
        Intrinsics.checkNotNullExpressionValue((Object)relationshipType, (String)"withName(...)");
        return relationshipType;
    }

    @NotNull
    public final String getNodeProperty(@NotNull Map<String, ? extends Object> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        return config.getOrDefault("nodeProperty", "text").toString();
    }

    /*
     * WARNING - void declaration
     */
    private final Object getSelectedType(Map<String, ? extends Object> config, List<String> keys, String string) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = keys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void key;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(config.get(key));
        }
        return CollectionsKt.first((List)CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)string)));
    }

    public final void verifySource(@NotNull Object source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object object = source;
        if (object instanceof Node) {
            return;
        }
        if (object instanceof List) {
            Iterable $this$forEach$iv = (Iterable)source;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object item = element$iv = iterator.next();
                boolean bl = false;
                if (item instanceof Node) continue;
                throw new IllegalArgumentException("`source` must be a node or list of nodes, but was: `" + source + "`");
            }
        } else {
            throw new IllegalArgumentException("`source` must be a node or list of nodes, but was: `" + source + "`");
        }
    }

    public final void verifyNodeProperty(@NotNull Object source, @NotNull String nodeProperty) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)nodeProperty, (String)"nodeProperty");
        Object object = source;
        if (object instanceof Node) {
            this.verifyNodeProperty((Node)source, nodeProperty);
        } else if (object instanceof List) {
            Iterable $this$forEach$iv = (Iterable)source;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object node = element$iv = iterator.next();
                boolean bl = false;
                Intrinsics.checkNotNull(node, (String)"null cannot be cast to non-null type org.neo4j.graphdb.Node");
                INSTANCE.verifyNodeProperty((Node)node, nodeProperty);
            }
        } else {
            throw new IllegalArgumentException("`source` must be a node or list of nodes, but was: `" + source + "`");
        }
    }

    public final void verifyKey(@NotNull Map<String, ? extends Object> config, @NotNull String property) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (!config.containsKey(property)) {
            throw new IllegalArgumentException("Missing parameter `" + property + "`.");
        }
    }

    public final void verifyKeys(@NotNull Map<String, ? extends Object> config, String ... properties) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        String[] $this$forEach$iv = properties;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            INSTANCE.verifyKey(config, it);
        }
    }

    private final void verifyNodeProperty(Node node, String nodeProperty) {
        if (!node.hasProperty(nodeProperty)) {
            throw new IllegalArgumentException(node + " does not have property `" + nodeProperty + "`. Property can be configured using parameter `nodeProperty`.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Node> convert(@NotNull Object source) {
        List list;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object object = source;
        if (object instanceof Node) {
            list = CollectionsKt.listOf((Object)source);
        } else if (object instanceof List) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)source;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void item;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type org.neo4j.graphdb.Node");
                collection.add((Node)item);
            }
            list = (List)destination$iv$iv;
        } else {
            throw new IllegalArgumentException("`source` must be a node or list of nodes, but was: `" + source + "`");
        }
        return list;
    }

    @NotNull
    public final List<List<Node>> partition(@NotNull List<? extends Node> nodes, int size) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        if (size < 1) {
            throw new IllegalArgumentException("size must be >= 1, but was:" + size);
        }
        List result = new ArrayList();
        for (int count = 0; count < nodes.size(); count += size) {
            result.add(nodes.subList(count, RangesKt.coerceAtMost((int)nodes.size(), (int)(count + size))));
        }
        return result;
    }

    private static final boolean mergeRelationship$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean mergeRelationship$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

