/*
 * Decompiled with CFR 0.152.
 */
package apoc.temporal;

import apoc.Extended;
import apoc.util.Util;
import java.util.Map;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValues;
import org.neo4j.values.Comparison;

@Extended
public class TemporalExtended {
    public static final String ACCEPT_ADJACENT_KEY = "acceptAdjacentSpans";
    @Context
    public Transaction tx;

    @UserFunction(value="apoc.temporal.overlap")
    @Description(value="apoc.temporal.overlap(start1,end1,start2,end2,$config) - Check whether the two temporal spans (start1-end1 and start2-end2) overlap or not")
    public Boolean overlap(@Name(value="start1") Object start1, @Name(value="end1") Object end1, @Name(value="start2") Object start2, @Name(value="end2") Object end2, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        boolean acceptAdjacentSpans = Util.toBoolean((Object)config.get(ACCEPT_ADJACENT_KEY));
        AnyValue startValue1 = ValueUtils.of((Object)start1);
        AnyValue endValue2 = ValueUtils.of((Object)end2);
        AnyValue startValue2 = ValueUtils.of((Object)start2);
        AnyValue endValue1 = ValueUtils.of((Object)end1);
        Comparison comparisonLeft = AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)startValue1, (Object)endValue2);
        Comparison comparisonRight = AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)startValue2, (Object)endValue1);
        if (comparisonLeft.equals((Object)Comparison.UNDEFINED) || comparisonRight.equals((Object)Comparison.UNDEFINED)) {
            return null;
        }
        int rangeLeft = comparisonLeft.value();
        int rangeRight = comparisonRight.value();
        if (acceptAdjacentSpans) {
            return rangeLeft <= 0 && rangeRight <= 0;
        }
        return rangeLeft < 0 && rangeRight < 0;
    }
}

