/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.ApocConfig;
import apoc.export.util.CountingReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.neo4j.configuration.GraphDatabaseSettings;

public class ExtendedFileUtils {
    public static final List<String> NEO4J_DIRECTORY_CONFIGURATION_SETTING_NAMES = Arrays.asList("server.directories.data", "server.directories.import", "server.directories.lib", "server.directories.logs", "server.directories.plugins", "server.directories.run", "server.directories.transaction.logs.root", "server.directories.neo4j_home");

    public static File getMetricsDirectory() {
        File metricsDir;
        String neo4jHome = ApocConfig.apocConfig().getString(GraphDatabaseSettings.neo4j_home.name());
        String metricsSetting = ApocConfig.apocConfig().getString("server.directories.metrics", neo4jHome + File.separator + "metrics");
        File file = metricsDir = metricsSetting.isEmpty() ? new File(neo4jHome, "metrics") : new File(metricsSetting);
        if (metricsDir.exists() && metricsDir.canRead() && metricsDir.isDirectory()) {
            return metricsDir;
        }
        return null;
    }

    public static Path getPathFromUrlString(String urlDir) {
        return Paths.get(URI.create(urlDir));
    }

    public static void closeReaderSafely(CountingReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

