/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.export.cypher.formatter.CypherFormatterUtils;
import apoc.util.CollectionUtils;
import apoc.util.JsonUtil;
import apoc.util.Util;
import apoc.util.collection.Iterators;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.Result;
import org.neo4j.procedure.Mode;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;

public class ExtendedUtil {
    public static String dateFormat(TemporalAccessor value, String format) {
        return Util.getFormat((String)format).format(value);
    }

    public static double doubleValue(Entity pc, String prop, Number defaultValue) {
        return Util.toDouble((Object)pc.getProperty(prop, (Object)defaultValue));
    }

    public static Duration durationParse(String value) {
        return Duration.parse(value);
    }

    public static boolean isSumOutOfRange(long ... numbers) {
        try {
            ExtendedUtil.sumLongs(numbers).longValueExact();
            return false;
        }
        catch (ArithmeticException ae) {
            return true;
        }
    }

    private static BigInteger sumLongs(long ... numbers) {
        return LongStream.of(numbers).mapToObj(BigInteger::valueOf).reduce(BigInteger.ZERO, (x, y) -> x.add((BigInteger)y));
    }

    public static String toCypherMap(Map<String, Object> map) {
        StringBuilder builder = CypherFormatterUtils.formatProperties(map);
        return "{" + CypherFormatterUtils.formatToString((StringBuilder)builder) + "}";
    }

    public static Object toValidValue(Object object, String field, Map<String, Object> mapping) {
        Object fieldName = mapping.get(field);
        if (object != null && fieldName != null) {
            return ExtendedUtil.convertValue(object.toString(), fieldName.toString());
        }
        if (object instanceof Collection) {
            List<Object> list = ((Collection)object).stream().map(i -> ExtendedUtil.toValidValue(i, field, mapping)).collect(Collectors.toList());
            try {
                return list.toArray(new String[0]);
            }
            catch (ArrayStoreException e2) {
                return list.toArray(new Object[0]);
            }
        }
        if (object instanceof Map) {
            return ((Map)object).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ExtendedUtil.toValidValue(e.getValue(), field, mapping)));
        }
        return ExtendedUtil.getNeo4jValue(object);
    }

    public static <T> Object toValidYamlValue(Object object, String field, Map<String, Object> mapping, boolean start2) {
        Object fieldName;
        Object object2 = fieldName = field == null ? null : mapping.get(field);
        if (fieldName == null) {
            Object object3 = fieldName = start2 ? mapping.get("_") : null;
        }
        if (object instanceof Collection) {
            return ((Collection)object).stream().map(i -> ExtendedUtil.toValidYamlValue(i, field, mapping, start2)).collect(Collectors.toList()).toArray(i -> new Object[0]);
        }
        if (object instanceof Map) {
            return ((Map)object).entrySet().stream().collect(HashMap::new, (mapAccumulator, entry) -> mapAccumulator.put(entry.getKey(), ExtendedUtil.toValidYamlValue(entry.getValue(), (String)entry.getKey(), mapping, false)), HashMap::putAll);
        }
        if (object != null && fieldName != null) {
            return ExtendedUtil.convertValue(object.toString(), fieldName.toString());
        }
        return ExtendedUtil.getNeo4jValue(object);
    }

    public static Object getNeo4jValue(Object object) {
        try {
            Values.of((Object)object);
            return object;
        }
        catch (Exception e) {
            return object.toString();
        }
    }

    private static Object convertValue(String value, String typeName) {
        switch (typeName = typeName.toLowerCase()) {
            case "point": {
                return ExtendedUtil.getPointValue(value);
            }
            case "localdatetime": {
                return LocalDateTimeValue.parse((CharSequence)value).asObjectCopy();
            }
            case "localtime": {
                return LocalTimeValue.parse((CharSequence)value).asObjectCopy();
            }
            case "datetime": {
                return DateTimeValue.parse((CharSequence)value, () -> ZoneId.of("Z")).asObjectCopy();
            }
            case "time": {
                return TimeValue.parse((CharSequence)value, () -> ZoneId.of("Z")).asObjectCopy();
            }
            case "date": {
                return DateValue.parse((CharSequence)value).asObjectCopy();
            }
            case "duration": {
                return DurationValue.parse((CharSequence)value);
            }
            case "boolean": {
                return Boolean.parseBoolean(value);
            }
            case "char": {
                return Character.valueOf(value.charAt(0));
            }
            case "byte": {
                return value.getBytes();
            }
            case "double": {
                return Double.parseDouble(value);
            }
            case "float": {
                return Float.valueOf(Float.parseFloat(value));
            }
            case "short": {
                return Short.parseShort(value);
            }
            case "int": 
            case "integer": {
                return Integer.parseInt(value);
            }
            case "long": {
                return Long.parseLong(value);
            }
            case "node": 
            case "relationship": {
                return JsonUtil.parse((String)value, null, Map.class);
            }
            case "no_value": {
                return null;
            }
            case "listboolean": {
                value = StringUtils.removeStart((String)value, (String)"[");
                value = StringUtils.removeEnd((String)value, (String)"]");
                String dataType = typeName.replace("array", "").replace("list", "");
                Object[] arr = ExtendedUtil.getPrototypeFor(dataType);
                return Arrays.stream(value.split(",")).map(item -> ExtendedUtil.convertValue(StringUtils.trim((String)item), dataType)).toList().toArray(arr);
            }
        }
        if (typeName.endsWith("array") || typeName.startsWith("list")) {
            value = StringUtils.removeStart((String)value, (String)"[");
            value = StringUtils.removeEnd((String)value, (String)"]");
            String array = typeName.replace("array", "").replace("list", "");
            Object[] prototype = ExtendedUtil.getPrototypeFor(array);
            return Arrays.stream(value.split(",")).map(item -> ExtendedUtil.convertValue(StringUtils.trim((String)item), array)).toList().toArray(prototype);
        }
        return value;
    }

    private static PointValue getPointValue(String value) {
        try {
            return PointValue.parse((CharSequence)value);
        }
        catch (Neo4jException e) {
            ObjectMapper objectMapper = new ObjectMapper().disable(new JsonGenerator.Feature[]{JsonWriteFeature.QUOTE_FIELD_NAMES.mappedFeature()});
            try {
                Map readValue2 = (Map)objectMapper.readValue(value, Map.class);
                String stringWithoutKeyQuotes = objectMapper.writeValueAsString((Object)readValue2);
                return PointValue.parse((CharSequence)stringWithoutKeyQuotes);
            }
            catch (JsonProcessingException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static Object[] getPrototypeFor(String type) {
        return switch (type = type.toLowerCase()) {
            case "long" -> new Long[]{};
            case "integer" -> new Integer[]{};
            case "double" -> new Double[]{};
            case "float" -> new Float[]{};
            case "boolean" -> new Boolean[]{};
            case "byte" -> new Byte[]{};
            case "short" -> new Short[]{};
            case "char" -> new Character[]{};
            case "string" -> new String[]{};
            case "datetime" -> new ZonedDateTime[]{};
            case "localtime" -> new LocalTime[]{};
            case "localdatetime" -> new LocalDateTime[]{};
            case "point" -> new PointValue[]{};
            case "time" -> new OffsetTime[]{};
            case "date" -> new LocalDate[]{};
            case "duration" -> new DurationValue[]{};
            default -> throw new IllegalStateException("Type " + type + " not supported.");
        };
    }

    public static QueryExecutionType.QueryType isQueryValid(Result result, QueryExecutionType.QueryType[] supportedQueryTypes) {
        QueryExecutionType.QueryType type = result.getQueryExecutionType().queryType();
        if (supportedQueryTypes != null && supportedQueryTypes.length != 0 && Stream.of(supportedQueryTypes).noneMatch(sqt -> sqt.equals((Object)type))) {
            return type;
        }
        return null;
    }

    public static boolean procsAreValid(GraphDatabaseService db, Set<Mode> supportedModes, Result result) {
        if (supportedModes != null && !supportedModes.isEmpty()) {
            ExecutionPlanDescription executionPlanDescription = result.getExecutionPlanDescription();
            HashSet queryProcNames = new HashSet();
            Util.getAllQueryProcs((ExecutionPlanDescription)executionPlanDescription, queryProcNames);
            if (!queryProcNames.isEmpty()) {
                Set modes = supportedModes.stream().map(Enum::name).collect(Collectors.toSet());
                Set procNames = (Set)db.executeTransactionally("SHOW PROCEDURES YIELD name, mode where mode in $modes return name", Map.of("modes", modes), r -> Iterators.asSet((Iterator)r.columnAs("name")));
                return procNames.containsAll(queryProcNames);
            }
        }
        return true;
    }

    public static void retryRunnable(long maxRetries, Runnable supplier) {
        ExtendedUtil.retryRunnable(maxRetries, 0L, supplier);
    }

    private static void retryRunnable(long maxRetries, long retry, Runnable consumer) {
        try {
            consumer.run();
        }
        catch (Exception e) {
            if (retry >= maxRetries) {
                throw e;
            }
            Util.sleep((int)100);
            ExtendedUtil.retryRunnable(maxRetries, ++retry, consumer);
        }
    }

    public static void setProperties(Entity entity, Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            entity.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public static Map<Object, List> listOfMapToMapOfLists(Map mapKeys, List<Map<String, Object>> vectors) {
        HashMap<Object, List> additionalBodies = new HashMap<Object, List>();
        for (Map<String, Object> vector : vectors) {
            mapKeys.forEach((from, to) -> ExtendedUtil.mapEntryToList(additionalBodies, vector, from, to));
        }
        return additionalBodies;
    }

    private static void mapEntryToList(Map<Object, List> map, Map<String, Object> vector, Object keyFrom, Object keyTo) {
        Object item = vector.get(keyFrom);
        if (item == null) {
            return;
        }
        map.compute(keyTo, (k, v) -> {
            if (v == null) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(item);
                return list;
            }
            v.add(item);
            return v;
        });
    }

    public static float[] listOfNumbersToFloatArray(List<? extends Number> embedding) {
        float[] floats = new float[embedding.size()];
        int i = 0;
        for (Number number : embedding) {
            floats[i] = number.floatValue();
            ++i;
        }
        return floats;
    }

    public static String joinStringLabels(Collection<String> labels) {
        return CollectionUtils.isNotEmpty(labels) ? ":" + labels.stream().map(Util::quote).collect(Collectors.joining(":")) : "";
    }

    public static List<String> splitSemicolonAndRemoveBlanks(String value) {
        return Arrays.stream(value.split(";\n")).filter(i -> !i.isBlank()).toList();
    }

    public static <T> T withBackOffRetries(Supplier<T> func, boolean retry, int backoffRetry, boolean exponential, Consumer<Exception> exceptionHandler) {
        T result;
        int countDown = backoffRetry = backoffRetry < 1 ? 5 : backoffRetry;
        exceptionHandler = Objects.requireNonNullElse(exceptionHandler, exe -> {});
        while (true) {
            try {
                result = func.get();
            }
            catch (Exception e) {
                if (!retry || countDown < 1) {
                    throw e;
                }
                exceptionHandler.accept(e);
                long delay = ExtendedUtil.getDelay(backoffRetry, --countDown, exponential);
                ExtendedUtil.backoffSleep(delay);
                continue;
            }
            break;
        }
        return result;
    }

    private static void backoffSleep(long millis) {
        ExtendedUtil.sleep(millis, "Operation interrupted during backoff");
    }

    public static void sleep(long millis, String interruptedMessage) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(interruptedMessage, ie);
        }
    }

    private static long getDelay(int backoffRetry, int countDown, boolean exponential) {
        int backOffTime = backoffRetry - countDown;
        long sleepMultiplier = exponential ? (long)Math.pow(2.0, backOffTime) : (long)backOffTime;
        return Math.min(Duration.ofSeconds(1L).multipliedBy(sleepMultiplier).toMillis(), Duration.ofSeconds(30L).toMillis());
    }

    public static <T, V> Stream<List<V>> batchIterator(final Iterator<T> iterator, final int batchSize, final Function<T, V> consumer) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<List<V>>(Long.MAX_VALUE, 16){

            @Override
            public boolean tryAdvance(Consumer<? super List<V>> action) {
                ArrayList batch = new ArrayList(batchSize);
                while (iterator.hasNext() && batch.size() < batchSize) {
                    Object next = iterator.next();
                    Object apply = consumer.apply(next);
                    batch.add(apply);
                }
                if (batch.isEmpty()) {
                    return false;
                }
                action.accept(batch);
                return true;
            }
        }, false);
    }
}

