/*
 * Decompiled with CFR 0.152.
 */
package apoc.vectordb;

import apoc.ExtendedSystemPropertyKeys;
import apoc.SystemPropertyKeys;
import apoc.util.CollectionUtils;
import apoc.util.ExtendedMapUtils;
import apoc.util.SystemDbUtil;
import apoc.util.Util;
import apoc.vectordb.VectorDbHandler;
import apoc.vectordb.VectorMappingConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class VectorDbUtil {
    public static final String ERROR_READONLY_MAPPING = "The mapping is not possible with this procedure, as it is read-only.";

    public static void getEndpoint(Map<String, Object> config, String endpoint) {
        config.putIfAbsent("endpoint", endpoint);
    }

    public static Map<String, Object> getCommonVectorDbInfo(String hostOrKey, String collection, Map<String, Object> configuration, String templateUrl, VectorDbHandler handler) {
        Map<String, Object> config = new HashMap<String, Object>(configuration);
        Map<String, Object> systemDbProps = VectorDbUtil.getSystemDbProps(hostOrKey, handler);
        String baseUrl = VectorDbUtil.getBaseUrl(hostOrKey, handler, config, systemDbProps);
        VectorDbUtil.getMapping(config, systemDbProps);
        config = VectorDbUtil.getCredentialsFromSystemDb(handler, config, systemDbProps);
        String endpoint = templateUrl.formatted(baseUrl, collection);
        VectorDbUtil.getEndpoint(config, endpoint);
        return config;
    }

    private static Map<String, Object> getSystemDbProps(String hostOrKey, VectorDbHandler handler) {
        try {
            Map props = SystemDbUtil.withSystemDb(transaction -> {
                Label label = Label.label((String)handler.getLabel());
                Node node = transaction.findNode(label, SystemPropertyKeys.name.name(), (Object)hostOrKey);
                return node == null ? Map.of() : node.getAllProperties();
            });
            return props;
        }
        catch (Exception e) {
            return Map.of();
        }
    }

    private static void getMapping(Map<String, Object> config, Map<String, Object> props) {
        String mappingStoreVal;
        Map mappingConfVal = (Map)config.get("mapping");
        if (ExtendedMapUtils.isEmpty(mappingConfVal) && (mappingStoreVal = (String)props.get("mapping")) != null) {
            config.put("mapping", Util.fromJson((String)mappingStoreVal, Map.class));
        }
    }

    private static Map<String, Object> getCredentialsFromSystemDb(VectorDbHandler handler, Map<String, Object> config, Map<String, Object> props) {
        String credentials = (String)props.get(ExtendedSystemPropertyKeys.credentials.name());
        if (credentials != null) {
            Object credentialsObj = Util.fromJson((String)credentials, Object.class);
            config = handler.getCredentials(credentialsObj, config);
        }
        return config;
    }

    private static String getBaseUrl(String hostOrKey, VectorDbHandler handler, Map<String, Object> config, Map<String, Object> props) {
        String url = VectorDbUtil.getUrl(hostOrKey, handler, props);
        config.put("baseUrl", url);
        return url;
    }

    private static String getUrl(String hostOrKey, VectorDbHandler handler, Map<String, Object> props) {
        if (props.isEmpty()) {
            return handler.getUrl(hostOrKey);
        }
        return (String)props.get(ExtendedSystemPropertyKeys.host.name());
    }

    public static void setReadOnlyMappingMode(Map<String, Object> configuration) {
        Map mappingConf = configuration.getOrDefault("mapping", new HashMap());
        mappingConf.put("mode", VectorMappingConfig.MappingMode.READ_ONLY.toString());
    }

    public static void methodAndPayloadNull(Map<String, Object> config) {
        config.put("method", null);
        config.put("body", null);
    }

    public static List addMetadataKeyToFields(Map<String, Object> config) {
        String metadataKey;
        List listFields = config.getOrDefault("fields", new ArrayList());
        Map mapping = (Map)config.get("mapping");
        String string = metadataKey = mapping == null ? null : (String)mapping.get("metadataKey");
        if (CollectionUtils.isEmpty((Collection)listFields)) {
            if (StringUtils.isEmpty((CharSequence)metadataKey)) {
                throw new RuntimeException("You need to define either the 'field' list parameter, or the 'metadataKey' string parameter within the `embeddingConfig` parameter");
            }
            listFields.add(metadataKey);
        }
        return listFields;
    }

    public static String appendVersionUrlIfNeeded(VectorDbHandler.Type type, String host) {
        String regex;
        if (VectorDbHandler.Type.WEAVIATE == type && !((String)host).matches(regex = ".*(/v\\d+)$")) {
            host = (String)host + "/v1";
        }
        return host;
    }

    public record EmbeddingResult(Object id, Double score, List<Double> vector, Map<String, Object> metadata, String text, Node node, Relationship rel) {
    }
}

