/*
 * Decompiled with CFR 0.152.
 */
package apoc.vectordb;

import apoc.ml.RestAPIConfig;
import apoc.util.Util;
import apoc.vectordb.VectorMappingConfig;
import java.util.Map;

public class VectorEmbeddingConfig {
    public static final String FIELDS_KEY = "fields";
    public static final String VECTOR_KEY = "vectorKey";
    public static final String METADATA_KEY = "metadataKey";
    public static final String SCORE_KEY = "scoreKey";
    public static final String TEXT_KEY = "textKey";
    public static final String ID_KEY = "idKey";
    public static final String MAPPING_KEY = "mapping";
    public static final String DEFAULT_ID = "id";
    public static final String DEFAULT_TEXT = "text";
    public static final String DEFAULT_VECTOR = "vector";
    public static final String DEFAULT_METADATA = "metadata";
    public static final String DEFAULT_SCORE = "score";
    public static final String ALL_RESULTS_KEY = "allResults";
    public static final String META_AS_SUBKEY_KEY = "metaAsSubKey";
    private final String idKey;
    private final String textKey;
    private final String vectorKey;
    private final String metadataKey;
    private final String scoreKey;
    private final boolean allResults;
    private final boolean metaAsSubKey;
    private final VectorMappingConfig mapping;
    private final RestAPIConfig apiConfig;

    public VectorEmbeddingConfig(Map<String, Object> config) {
        this.vectorKey = (String)config.getOrDefault(VECTOR_KEY, DEFAULT_VECTOR);
        this.metadataKey = (String)config.getOrDefault(METADATA_KEY, DEFAULT_METADATA);
        this.scoreKey = (String)config.getOrDefault(SCORE_KEY, DEFAULT_SCORE);
        this.idKey = (String)config.getOrDefault(ID_KEY, DEFAULT_ID);
        this.textKey = (String)config.getOrDefault(TEXT_KEY, DEFAULT_TEXT);
        this.allResults = Util.toBoolean((Object)config.get(ALL_RESULTS_KEY));
        this.mapping = new VectorMappingConfig(config.getOrDefault(MAPPING_KEY, Map.of()));
        this.metaAsSubKey = Util.toBoolean((Object)config.getOrDefault(META_AS_SUBKEY_KEY, true));
        this.apiConfig = new RestAPIConfig(config);
    }

    public String getIdKey() {
        return this.idKey;
    }

    public String getVectorKey() {
        return this.vectorKey;
    }

    public String getMetadataKey() {
        return this.metadataKey;
    }

    public String getScoreKey() {
        return this.scoreKey;
    }

    public String getTextKey() {
        return this.textKey;
    }

    public boolean isAllResults() {
        return this.allResults;
    }

    public boolean isMetaAsSubKey() {
        return this.metaAsSubKey;
    }

    public VectorMappingConfig getMapping() {
        return this.mapping;
    }

    public RestAPIConfig getApiConfig() {
        return this.apiConfig;
    }
}

