/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.ApocConfig;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class TTLConfig
extends LifecycleAdapter {
    private final ApocConfig apocConfig;
    public static final int DEFAULT_SCHEDULE = 60;
    private static TTLConfig theInstance;

    public TTLConfig(ApocConfig apocConfig, GlobalProcedures globalProceduresRegistry) {
        this.apocConfig = apocConfig;
        theInstance = this;
        globalProceduresRegistry.registerComponent(((Object)((Object)this)).getClass(), ctx -> this, true);
    }

    public static TTLConfig ttlConfig() {
        return theInstance;
    }

    public Values configFor(GraphDatabaseAPI db) {
        String apocTTLEnabledDb = String.format("apoc.ttl.enabled.%s", db.databaseName());
        String apocTTLScheduleDb = String.format("apoc.ttl.schedule.%s", db.databaseName());
        String apocTTLLimitDb = String.format("apoc.ttl.limit.%s", db.databaseName());
        boolean enabled = this.apocConfig.getConfig().getBoolean("apoc.ttl.enabled", false);
        boolean dbEnabled = this.apocConfig.getConfig().getBoolean(apocTTLEnabledDb, enabled);
        if (dbEnabled) {
            long ttlSchedule = this.apocConfig.getInt("apoc.ttl.schedule", 60);
            long ttlScheduleDb = this.apocConfig.getInt(apocTTLScheduleDb, (int)ttlSchedule);
            long limit = this.apocConfig.getInt("apoc.ttl.limit", 1000);
            long limitDb = this.apocConfig.getInt(apocTTLLimitDb, (int)limit);
            return new Values(true, ttlScheduleDb, limitDb);
        }
        return new Values(false, -1L, -1L);
    }

    public static class Values {
        public final boolean enabled;
        public final long schedule;
        public final long limit;

        public Values(boolean enabled, long schedule, long limit) {
            this.enabled = enabled;
            this.schedule = schedule;
            this.limit = limit;
        }

        public String toString() {
            return "Values{enabled=" + this.enabled + ", schedule=" + this.schedule + ", limit=" + this.limit + "}";
        }
    }
}

