/*
 * Decompiled with CFR 0.152.
 */
package apoc.bolt;

import apoc.bolt.BoltConfig;
import apoc.bolt.ClosedAwareDelegatingIterator;
import apoc.result.RowResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.util.MapUtil;
import apoc.util.UriResolver;
import apoc.util.Util;
import apoc.util.collection.Iterators;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Record;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.InternalEntity;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;

public class BoltConnection {
    private final BoltConfig config;
    private final UriResolver resolver;

    public BoltConnection(BoltConfig config, UriResolver resolver) {
        this.config = config;
        this.resolver = resolver;
    }

    public static BoltConnection from(Map<String, Object> config, String url) throws URISyntaxException {
        UriResolver resolver = new UriResolver(url, "bolt");
        resolver.initialize();
        return new BoltConnection(new BoltConfig(config), resolver);
    }

    public Stream<RowResult> loadFromSession(String statement, Map<String, Object> params) {
        return this.withDriverAndSession(session -> {
            if (this.config.isAddStatistics()) {
                org.neo4j.driver.Result statementResult = session.run(statement, params);
                SummaryCounters counters = statementResult.consume().counters();
                return Stream.of(new RowResult(this.toMap(counters)));
            }
            return this.getRowResultStream((Session)session, params, statement);
        });
    }

    public Stream<RowResult> loadFromLocal(String localStatement, String remoteStatement, GraphDatabaseService db) {
        return this.withDriverAndSession(session -> {
            try (org.neo4j.graphdb.Transaction tx = db.beginTx();){
                Result localResult = tx.execute(localStatement, this.config.getLocalParams());
                String withColumns = "WITH " + localResult.columns().stream().map(c -> "$" + c + " AS " + c).collect(Collectors.joining(", ")) + "\n";
                HashMap nodesCache = new HashMap();
                ArrayList<RowResult> response = new ArrayList<RowResult>();
                while (localResult.hasNext()) {
                    org.neo4j.driver.Result statementResult;
                    Map row = localResult.next();
                    if (this.config.isStreamStatements()) {
                        String statement = (String)row.get("statement");
                        if (StringUtils.isBlank((CharSequence)statement)) continue;
                        Map params = Collections.singletonMap("params", row.getOrDefault("params", Collections.emptyMap()));
                        statementResult = session.run(statement, params);
                    } else {
                        String query = withColumns + remoteStatement;
                        statementResult = session.run(query, row);
                    }
                    if (this.config.isStreamStatements()) {
                        response.add(new RowResult(this.toMap(statementResult.consume().counters())));
                        continue;
                    }
                    response.addAll(statementResult.stream().flatMap(record -> this.buildRowResult((Session)session, (Record)record, (Map<Long, org.neo4j.graphdb.Node>)nodesCache)).collect(Collectors.toList()));
                }
                Stream stream = response.stream();
                return stream;
            }
        });
    }

    private <T> Stream<T> withDriverAndSession(Function<Session, Stream<T>> funSession) {
        return this.withDriver(driver -> this.withSession((Driver)driver, funSession));
    }

    private <T> Stream<T> withDriver(Function<Driver, Stream<T>> function) {
        Driver driver = GraphDatabase.driver((URI)this.resolver.getConfiguredUri(), (AuthToken)this.resolver.getToken(), (Config)this.config.getDriverConfig());
        return (Stream)function.apply(driver).onClose(() -> ((Driver)driver).close());
    }

    private <T> Stream<T> withSession(Driver driver, Function<Session, Stream<T>> function) {
        Session session = driver.session(this.config.getSessionConfig());
        return (Stream)function.apply(session).onClose(() -> ((Session)session).close());
    }

    private <T> Stream<T> withTransaction(Session session, Function<Transaction, Stream<T>> function) {
        Transaction transaction = session.beginTransaction();
        return (Stream)((Stream)function.apply(transaction).onClose(() -> ((Transaction)transaction).commit())).onClose(() -> ((Transaction)transaction).close());
    }

    private Stream<RowResult> buildRowResult(Session session, Record record, Map<Long, org.neo4j.graphdb.Node> nodesCache) {
        return this.withTransaction(session, tx -> Stream.of(this.buildRowResult((Transaction)tx, record, nodesCache)));
    }

    private RowResult buildRowResult(Transaction tx, Record record, Map<Long, org.neo4j.graphdb.Node> nodesCache) {
        return new RowResult(record.asMap(value -> this.convert(tx, value, nodesCache)));
    }

    private Object convert(Transaction tx, Object entity, Map<Long, org.neo4j.graphdb.Node> nodesCache) {
        if (entity instanceof Value) {
            return this.convert(tx, ((Value)entity).asObject(), nodesCache);
        }
        if (entity instanceof Node) {
            return this.toNode(entity, nodesCache);
        }
        if (entity instanceof Relationship) {
            return this.toRelationship(tx, entity, nodesCache);
        }
        if (entity instanceof Path) {
            return this.toPath(tx, entity, nodesCache);
        }
        if (entity instanceof Collection) {
            return this.toCollection(tx, (Collection)entity, nodesCache);
        }
        if (entity instanceof Map) {
            return this.toMap(tx, (Map)entity, nodesCache);
        }
        return entity;
    }

    private Object toMap(Transaction tx, Map<String, Object> entity, Map<Long, org.neo4j.graphdb.Node> nodeCache) {
        return entity.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), this.convert(tx, entry.getValue(), nodeCache))).collect(Collectors.toMap(e -> e.getKey(), e -> e.getValue()));
    }

    private Object toCollection(Transaction tx, Collection entity, Map<Long, org.neo4j.graphdb.Node> nodeCache) {
        return entity.stream().map(elem -> this.convert(tx, elem, nodeCache)).collect(Collectors.toList());
    }

    private Stream<RowResult> getRowResultStream(Session session, Map<String, Object> params, String statement) {
        HashMap nodesCache = new HashMap();
        return this.withTransaction(session, tx -> {
            ClosedAwareDelegatingIterator iterator = new ClosedAwareDelegatingIterator(tx.run(statement, params));
            return Iterators.stream(iterator).map(record -> this.buildRowResult((Transaction)tx, (Record)record, (Map<Long, org.neo4j.graphdb.Node>)nodesCache));
        });
    }

    private Object toNode(Object value, Map<Long, org.neo4j.graphdb.Node> nodesCache) {
        Node node;
        if (value instanceof Value) {
            node = ((InternalEntity)value).asValue().asNode();
        } else if (value instanceof Node) {
            node = (Node)value;
        } else {
            throw this.getUnsupportedConversionException(value);
        }
        if (this.config.isVirtual()) {
            ArrayList labels = new ArrayList();
            node.labels().forEach(l -> labels.add(Label.label((String)l)));
            VirtualNode virtualNode = new VirtualNode(node.id(), node.elementId(), labels.toArray(new Label[0]), node.asMap());
            nodesCache.put(node.id(), (org.neo4j.graphdb.Node)virtualNode);
            return virtualNode;
        }
        return Util.map((Object[])new Object[]{"entityType", "NODE", "labels", node.labels(), "id", node.id(), "properties", node.asMap()});
    }

    private Object toRelationship(Transaction tx, Object value, Map<Long, org.neo4j.graphdb.Node> nodesCache) {
        Relationship rel;
        if (value instanceof Value) {
            rel = ((InternalEntity)value).asValue().asRelationship();
        } else if (value instanceof Relationship) {
            rel = (Relationship)value;
        } else {
            throw this.getUnsupportedConversionException(value);
        }
        if (this.config.isVirtual()) {
            org.neo4j.graphdb.Node end;
            org.neo4j.graphdb.Node start2;
            long startId = rel.startNodeId();
            long endId = rel.endNodeId();
            if (this.config.isWithRelationshipNodeProperties()) {
                Function<Long, VirtualNode> retrieveNode = id -> {
                    Node node = tx.run("MATCH (n) WHERE id(n) = $id RETURN n", Map.of("id", id)).single().get("n").asNode();
                    return new VirtualNode(node.id(), this.getLabelsAsArray(node), node.asMap());
                };
                start2 = (org.neo4j.graphdb.Node)nodesCache.computeIfAbsent(startId, retrieveNode);
                end = (org.neo4j.graphdb.Node)nodesCache.computeIfAbsent(endId, retrieveNode);
            } else {
                start2 = nodesCache.getOrDefault(startId, (org.neo4j.graphdb.Node)new VirtualNode(startId));
                end = nodesCache.getOrDefault(endId, (org.neo4j.graphdb.Node)new VirtualNode(endId));
            }
            return new VirtualRelationship(rel.id(), rel.elementId(), start2, end, RelationshipType.withName((String)rel.type()), rel.asMap());
        }
        return Util.map((Object[])new Object[]{"entityType", "RELATIONSHIP", "type", rel.type(), "id", rel.id(), "start", rel.startNodeId(), "end", rel.endNodeId(), "properties", rel.asMap()});
    }

    private Object toPath(Transaction tx, Object value, Map<Long, org.neo4j.graphdb.Node> nodesCache) {
        LinkedList entityList = new LinkedList();
        Value internalValue = ((InternalPath)value).asValue();
        internalValue.asPath().forEach(p -> {
            entityList.add(this.toNode(p.start(), nodesCache));
            entityList.add(this.toRelationship(tx, p.relationship(), nodesCache));
            entityList.add(this.toNode(p.end(), nodesCache));
        });
        return entityList;
    }

    private Label[] getLabelsAsArray(Node node) {
        return (Label[])StreamSupport.stream(node.labels().spliterator(), false).map(Label::label).toArray(Label[]::new);
    }

    private ClassCastException getUnsupportedConversionException(Object value) {
        return new ClassCastException("Conversion from class " + value.getClass().getName() + " not supported");
    }

    private Map<String, Object> toMap(SummaryCounters resultSummary) {
        return MapUtil.map((Object[])new Object[]{"nodesCreated", resultSummary.nodesCreated(), "nodesDeleted", resultSummary.nodesDeleted(), "labelsAdded", resultSummary.labelsAdded(), "labelsRemoved", resultSummary.labelsRemoved(), "relationshipsCreated", resultSummary.relationshipsCreated(), "relationshipsDeleted", resultSummary.relationshipsDeleted(), "propertiesSet", resultSummary.propertiesSet(), "constraintsAdded", resultSummary.constraintsAdded(), "constraintsRemoved", resultSummary.constraintsRemoved(), "indexesAdded", resultSummary.indexesAdded(), "indexesRemoved", resultSummary.indexesRemoved()});
    }
}

