/*
 * Decompiled with CFR 0.152.
 */
package apoc.config;

import apoc.ApocConfig;
import apoc.Extended;
import apoc.result.MapResult;
import apoc.util.collection.Iterators;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.neo4j.common.DependencyResolver;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Procedure;

@Extended
public class Config {
    private static final Set<String> WHITELIST_CONFIGS = Set.of("apoc.import.file.enabled", "apoc.import.file.use_neo4j_config", "apoc.import.file.allow_read_from_filesystem", "apoc.export.file.enabled", "apoc.trigger.enabled", "apoc.trigger.refresh", "apoc.uuid.enabled", "apoc.uuid.format", "apoc.ttl.schedule", "apoc.ttl.enabled", "apoc.ttl.limit", "apoc.jobs.scheduled.num_threads", "apoc.jobs.pool.num_threads", "apoc.jobs.queue.size", "apoc.http.timeout.connect", "apoc.http.timeout.read", "apoc.custom.procedures.refresh", "apoc.spatial.geocode.osm.throttle", "apoc.spatial.geocode.google.throttle");
    @Context
    public DependencyResolver dependencyResolver;

    @Admin
    @Description(value="apoc.config.list | Lists the Neo4j configuration as key,value table")
    @Procedure
    public Stream<ConfigResult> list() {
        Configuration config = ((ApocConfig)this.dependencyResolver.resolveDependency(ApocConfig.class)).getConfig();
        return Config.getApocConfigs(config).map(s -> new ConfigResult((String)s, config.getString(s)));
    }

    @Admin
    @Description(value="apoc.config.map | Lists the Neo4j configuration as map")
    @Procedure
    public Stream<MapResult> map() {
        Configuration config = ((ApocConfig)this.dependencyResolver.resolveDependency(ApocConfig.class)).getConfig();
        Map<String, Object> configMap = Config.getApocConfigs(config).collect(Collectors.toMap(s -> s, s -> config.getString(s)));
        return Stream.of(new MapResult(configMap));
    }

    private static Stream<String> getApocConfigs(Configuration config) {
        return Iterators.stream((Iterator)config.getKeys()).filter(conf -> WHITELIST_CONFIGS.stream().anyMatch(conf::startsWith));
    }

    public static class ConfigResult {
        public final String key;
        public final Object value;

        public ConfigResult(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

