/*
 * Decompiled with CFR 0.152.
 */
package apoc.custom;

import apoc.ExtendedSystemLabels;
import apoc.custom.CypherProceduresUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;

public class CustomProcedureInfo {
    public String type;
    public String name;
    public String description;
    public String mode;
    public String statement;
    public List<List<String>> inputs;
    public Object outputs;
    public Boolean forceSingle;

    public CustomProcedureInfo(String type, String name, String description, String mode, String statement, List<List<String>> inputs, Object outputs, Boolean forceSingle) {
        this.type = type;
        this.name = name;
        this.description = description;
        this.statement = statement;
        this.outputs = outputs;
        this.inputs = inputs;
        this.forceSingle = forceSingle;
        this.mode = mode;
    }

    public static CustomProcedureInfo fromNode(Node node) {
        if (node.hasLabel((Label)ExtendedSystemLabels.Procedure)) {
            return CypherProceduresUtil.getProcedureInfo(node);
        }
        if (node.hasLabel((Label)ExtendedSystemLabels.Function)) {
            return CypherProceduresUtil.getFunctionInfo(node);
        }
        throw new IllegalStateException("don't know what to do with systemdb node " + String.valueOf(node));
    }

    public static CustomProcedureInfo getCustomProcedureInfo(ProcedureSignature signature, String statement) {
        return new CustomProcedureInfo("procedure", signature.name().toString().substring("custom".length() + 1), signature.description().orElse(null), signature.mode().toString().toLowerCase(), statement, CustomProcedureInfo.convertInputSignature(signature.inputSignature()), CustomProcedureInfo.convertOutputSignature(signature.outputSignature()), null);
    }

    public static CustomProcedureInfo getCustomFunctionInfo(UserFunctionSignature signature, boolean forceSingle, String statement) {
        return new CustomProcedureInfo("function", signature.name().toString().substring("custom".length() + 1), signature.description().orElse(null), null, statement, CustomProcedureInfo.convertInputSignature(signature.inputSignature()), CustomProcedureInfo.prettyPrintType(signature.outputType()), forceSingle);
    }

    public static List<List<String>> convertOutputSignature(List<FieldSignature> signatures) {
        return signatures.stream().map(f -> Arrays.asList(f.name(), CustomProcedureInfo.prettyPrintType(f.neo4jType()))).toList();
    }

    public static List<List<String>> convertInputSignature(List<FieldSignature> signatures) {
        return signatures.stream().map(f -> {
            ArrayList<String> list = new ArrayList<String>(3);
            list.add(f.name());
            list.add(CustomProcedureInfo.prettyPrintType(f.neo4jType()));
            Optional defaultParameterValue = f.defaultValue();
            defaultParameterValue.map(DefaultParameterValue::value).ifPresent(v -> list.add(v.toString()));
            return list;
        }).toList();
    }

    public static String prettyPrintType(Neo4jTypes.AnyType type) {
        String s = type.toString().toLowerCase();
        if (s.endsWith("?")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

