/*
 * Decompiled with CFR 0.152.
 */
package apoc.custom;

import apoc.custom.CypherProceduresUtil;
import apoc.custom.SignatureLexer;
import apoc.custom.SignatureParser;
import apoc.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.procedure.Mode;

public class Signatures {
    public static final String NUMBER_TYPE = "INTEGER | FLOAT";
    public static final String SIGNATURE_SYNTAX_ERROR = "Syntax error(s) in signature definition %s. \nNote that procedure/function name, possible map keys, input and output names must have at least 2 character:\n";
    private final String prefix;

    public Signatures(String prefix) {
        this.prefix = prefix;
    }

    public Signatures() {
        this(null);
    }

    public SignatureParser.ProcedureContext parseProcedure(String procedureSignatureText) {
        ArrayList<String> errors = new ArrayList<String>();
        SignatureParser signatureParser = this.parse(procedureSignatureText, errors);
        SignatureParser.ProcedureContext signatureParsed = signatureParser.procedure();
        this.checkSignatureSyntax(procedureSignatureText, errors);
        return signatureParsed;
    }

    public SignatureParser.FunctionContext parseFunction(String functionSignatureText) {
        ArrayList<String> errors = new ArrayList<String>();
        SignatureParser signatureParser = this.parse(functionSignatureText, errors);
        SignatureParser.FunctionContext signatureParsed = signatureParser.function();
        this.checkSignatureSyntax(functionSignatureText, errors);
        return signatureParsed;
    }

    private void checkSignatureSyntax(String functionSignatureText, List<String> errors) {
        if (!errors.isEmpty()) {
            throw new RuntimeException(String.format(SIGNATURE_SYNTAX_ERROR, functionSignatureText) + String.join((CharSequence)"\n", errors));
        }
    }

    private SignatureParser parse(String signatureText, final List<String> errors) {
        CodePointCharStream inputStream = CharStreams.fromString((String)signatureText);
        SignatureLexer signatureLexer = new SignatureLexer((CharStream)inputStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)signatureLexer);
        SignatureParser signatureParser = new SignatureParser((TokenStream)commonTokenStream);
        signatureParser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(this){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                errors.add("line " + line + ":" + charPositionInLine + " " + msg);
            }
        });
        return signatureParser;
    }

    public ProcedureSignature toProcedureSignature(SignatureParser.ProcedureContext signature) {
        return this.toProcedureSignature(signature, null, Mode.DEFAULT);
    }

    public static FieldSignature getInputField(String name, Neo4jTypes.AnyType type, DefaultParameterValue defaultValue) {
        if (defaultValue == null) {
            return FieldSignature.inputField((String)name, (Neo4jTypes.AnyType)type);
        }
        return FieldSignature.inputField((String)name, (Neo4jTypes.AnyType)type, (DefaultParameterValue)defaultValue);
    }

    public ProcedureSignature toProcedureSignature(SignatureParser.ProcedureContext signature, String description, Mode mode) {
        QualifiedName name = new QualifiedName(this.namespace(signature.namespace()), this.name(signature.name()));
        List<FieldSignature> outputSignature = signature.results().empty() != null ? ProcedureSignature.VOID : signature.results().result().stream().map(p -> FieldSignature.outputField((String)this.name(p.name()), (Neo4jTypes.AnyType)this.type(p.type()))).collect(Collectors.toList());
        List<FieldSignature> inputSignatures = signature.parameter().stream().map(p -> Signatures.getInputField(this.name(p.name()), this.type(p.type()), this.defaultValue(p.defaultValue(), this.type(p.type())))).collect(Collectors.toList());
        boolean admin = false;
        String deprecated = "";
        String warning = null;
        boolean eager = false;
        boolean caseInsensitive = true;
        return Signatures.createProcedureSignature(name, inputSignatures, outputSignature, mode, admin, deprecated, description, warning, eager, caseInsensitive, false, false, false, false);
    }

    public String[] namespace(SignatureParser.NamespaceContext namespaceContext) {
        List parsed;
        List list = parsed = namespaceContext == null ? Collections.emptyList() : namespaceContext.name().stream().map(this::name).collect(Collectors.toList());
        if (this.prefix == null) {
            return (String[])parsed.toArray(String[]::new);
        }
        ArrayList<String> namespace = new ArrayList<String>();
        namespace.add(this.prefix);
        namespace.addAll(parsed);
        return (String[])namespace.toArray(String[]::new);
    }

    public UserFunctionSignature toFunctionSignature(SignatureParser.FunctionContext signature, String description) {
        QualifiedName name = new QualifiedName(this.namespace(signature.namespace()), this.name(signature.name()));
        Neo4jTypes.AnyType type = this.type(signature.type());
        List inputSignatures = signature.parameter().stream().map(p -> Signatures.getInputField(this.name(p.name()), this.type(p.type()), this.defaultValue(p.defaultValue(), this.type(p.type())))).collect(Collectors.toList());
        String deprecated = "";
        boolean caseInsensitive = true;
        boolean isBuiltIn = false;
        boolean internal = false;
        boolean threadsafe = false;
        return new UserFunctionSignature(name, inputSignatures, type, false, deprecated, description, "apoc.custom", caseInsensitive, isBuiltIn, internal, threadsafe);
    }

    private DefaultParameterValue defaultValue(SignatureParser.DefaultValueContext defaultValue, Neo4jTypes.AnyType type) {
        if (defaultValue == null) {
            return null;
        }
        SignatureParser.ValueContext v = defaultValue.value();
        if (v.nullValue() != null) {
            return DefaultParameterValue.nullValue((Neo4jTypes.AnyType)type);
        }
        if (v.boolValue() != null) {
            return DefaultParameterValue.ntBoolean((boolean)Boolean.parseBoolean(v.boolValue().getText()));
        }
        SignatureParser.StringValueContext stringCxt = v.stringValue();
        if (stringCxt != null) {
            String text = stringCxt.getText();
            if (stringCxt.SINGLE_QUOTED_STRING_VALUE() != null || stringCxt.QUOTED_STRING_VALUE() != null) {
                text = text.substring(1, text.length() - 1);
            }
            return DefaultParameterValue.ntString((String)text);
        }
        if (v.INT_VALUE() != null) {
            String text = v.INT_VALUE().getText();
            return this.getDefaultParameterValue(type, text, () -> DefaultParameterValue.ntInteger((long)Long.parseLong(text)));
        }
        if (v.FLOAT_VALUE() != null) {
            String text = v.FLOAT_VALUE().getText();
            return this.getDefaultParameterValue(type, text, () -> DefaultParameterValue.ntFloat((double)Double.parseDouble(text)));
        }
        if (v.mapValue() != null) {
            Map map = (Map)JsonUtil.parse((String)v.mapValue().getText(), null, Map.class);
            return DefaultParameterValue.ntMap((Map)map);
        }
        if (v.listValue() != null) {
            List list = (List)JsonUtil.parse((String)v.listValue().getText(), null, List.class);
            Neo4jTypes.AnyType inner = ((Neo4jTypes.ListType)type).innerType();
            if (inner instanceof Neo4jTypes.TextType) {
                list = list.stream().map(String::valueOf).collect(Collectors.toList());
            }
            return DefaultParameterValue.ntList((List)list, (Neo4jTypes.AnyType)inner);
        }
        return DefaultParameterValue.nullValue((Neo4jTypes.AnyType)type);
    }

    private DefaultParameterValue getDefaultParameterValue(Neo4jTypes.AnyType type, String text, Supplier<DefaultParameterValue> fun) {
        return type instanceof Neo4jTypes.TextType ? DefaultParameterValue.ntString((String)text) : fun.get();
    }

    public String name(SignatureParser.NameContext ns) {
        if (ns == null) {
            throw new IllegalStateException("Unsupported procedure name, the procedure must have at least two chars");
        }
        if (ns.IDENTIFIER() != null) {
            return ns.IDENTIFIER().getText();
        }
        if (ns.QUOTED_IDENTIFIER() != null) {
            return ns.QUOTED_IDENTIFIER().getText();
        }
        throw new IllegalStateException("Invalid Name " + String.valueOf((Object)ns));
    }

    private Neo4jTypes.AnyType type(SignatureParser.TypeContext typeContext) {
        if (typeContext.list_type() != null) {
            return Neo4jTypes.NTList((Neo4jTypes.AnyType)this.type(typeContext.list_type().opt_type()));
        }
        if (typeContext.opt_type() != null) {
            return this.type(typeContext.opt_type());
        }
        return Neo4jTypes.NTAny;
    }

    public boolean isMapResult(SignatureParser.FunctionContext functionContext) {
        SignatureParser.TypeContext outputType = functionContext.type();
        return outputType.getText().contains("MAPRESULT");
    }

    private Neo4jTypes.AnyType type(SignatureParser.Opt_typeContext opt_type) {
        return CypherProceduresUtil.getBaseType(opt_type.base_type().getText());
    }

    public UserFunctionSignature asFunctionSignature(String signature, String description) {
        SignatureParser.FunctionContext functionContext = this.parseFunction(signature);
        return this.toFunctionSignature(functionContext, description);
    }

    public ProcedureSignature asProcedureSignature(String signature, String description, Mode mode) {
        SignatureParser.ProcedureContext ctx = this.parseProcedure(signature);
        return this.toProcedureSignature(ctx, description, mode);
    }

    public static ProcedureSignature createProcedureSignature(QualifiedName name, List<FieldSignature> inputSignature, List<FieldSignature> outputSignature, Mode mode, boolean admin, String deprecated, String description, String warning, boolean eager, boolean caseInsensitive, boolean systemProcedure, boolean internal, boolean allowExpiredCredentials, boolean threadSafe) {
        return new ProcedureSignature(name, inputSignature, outputSignature, mode, admin, false, deprecated, description, warning, eager, caseInsensitive, systemProcedure, internal, allowExpiredCredentials, threadSafe, QueryLanguage.ALL);
    }
}

