/*
 * Decompiled with CFR 0.152.
 */
package apoc.diff;

import apoc.Extended;
import apoc.diff.DiffConfig;
import apoc.diff.DiffExtended;
import apoc.diff.MapSubGraph;
import apoc.diff.SourceDestConfig;
import apoc.export.util.FormatUtils;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.util.ExtendedUtil;
import apoc.util.Util;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cypher.export.CypherResultSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class DiffExtendedGraph {
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseAPI databaseAPI;
    public static final String NODE = "Node";
    public static final String RELATIONSHIP = "Relationship";
    public static final String DESTINATION_ENTITY_NOT_FOUND = "Destination Entity not found";
    public static final String DIFFERENT_LABELS = "Different Labels";
    public static final String DIFFERENT_PROPS = "Different Properties";
    public static final String COUNT_BY_LABEL = "Count by Label";
    public static final String COUNT_BY_TYPE = "Count by Type";
    public static final String TOTAL_COUNT = "Total count";
    private static final String BOLT_SCHEMA_QUERY = "SHOW INDEXES YIELD labelsOrTypes, properties, state, type WHERE state = 'ONLINE' AND (type = 'UNIQUE' OR type = 'RANGE' OR type = 'TEXT')RETURN collect({labels: labelsOrTypes, properties: properties, type: type}) AS schema";

    @Procedure(value="apoc.diff.graphs")
    @Description(value="CALL apoc.diff.graphs(<source>, <dest>, <config>) YIELD difference, entityType, id, sourceLabel, destLabel, source, dest - compares two graphs and returns the results")
    public Stream<SourceDestResult> compare(@Name(value="source") Object source, @Name(value="dest") Object dest, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        config = config == null ? Collections.emptyMap() : config;
        DiffConfig diffConfig = new DiffConfig(config);
        SubGraph sourceGraph = this.toSubGraph(source, diffConfig, SourceDestConfig.fromMap((Map)config.get("source")));
        SubGraph destGraph = this.toSubGraph(dest, diffConfig, SourceDestConfig.fromMap((Map)config.get("dest")));
        Function<Map, Long> sum = map -> map.values().stream().reduce(0L, (x, y) -> x + y);
        SourceDestResult labelNodeCount = this.sourceDestCountByLabel(sourceGraph, destGraph);
        SourceDestResult nodeCount = labelNodeCount.areSourceAndDestEqual() ? null : new SourceDestResult(TOTAL_COUNT, NODE, sum.apply((Map)labelNodeCount.source), sum.apply((Map)labelNodeCount.dest));
        SourceDestResult typeRelCount = this.sourceDestCountByType(sourceGraph, destGraph);
        SourceDestResult relCount = typeRelCount.areSourceAndDestEqual() ? null : new SourceDestResult(TOTAL_COUNT, RELATIONSHIP, sum.apply((Map)typeRelCount.source), sum.apply((Map)typeRelCount.dest));
        Stream<SourceDestResult> generalStream = Stream.of(nodeCount, nodeCount != null ? labelNodeCount : null, relCount, relCount != null ? typeRelCount : null).filter(Objects::nonNull);
        Stream<SourceDestResult> nodeStream = this.compareNodes(sourceGraph, destGraph, diffConfig);
        Stream<SourceDestResult> relStream = this.compareRels(sourceGraph, destGraph);
        Stream<SourceDestResult> sourceDestResultStream = Stream.of(generalStream, nodeStream, relStream).reduce(Stream::concat).orElse(Stream.empty());
        return sourceDestResultStream;
    }

    private SubGraph toSubGraph(Object input, DiffConfig config, SourceDestConfig sourceDestConfig) {
        if (input == null) {
            throw new NullPointerException("Input data is null");
        }
        if (input instanceof Map) {
            Map graph = (Map)input;
            if (graph.containsKey("schema")) {
                return new MapSubGraph(graph);
            }
            Collection nodes = (Collection)graph.get("nodes");
            Collection rels = (Collection)graph.get("relationships");
            return new NodesAndRelsSubGraph(this.tx, nodes, rels);
        }
        if (input instanceof String) {
            String inputString = (String)input;
            if (sourceDestConfig != null) {
                String targetValue = sourceDestConfig.getTarget().getValue();
                if (StringUtils.isNotBlank((CharSequence)targetValue)) {
                    switch (sourceDestConfig.getTarget().getType()) {
                        case URL: {
                            Map<String, List<Object>> graph = this.createMapFromRemoteDb(inputString, config.getBoltConfig(), targetValue, sourceDestConfig.getParams());
                            return this.toSubGraph(graph, config, null);
                        }
                        case DATABASE: {
                            return ExtendedUtil.withDb(this.databaseAPI, targetValue, transaction -> {
                                Result result = transaction.execute(inputString, sourceDestConfig.getParams());
                                Map<String, List<Object>> baseMapFromOtherDb = this.createMapAndSchema(result, true, () -> transaction.execute(BOLT_SCHEMA_QUERY).columnAs("schema").stream().findFirst());
                                return this.toSubGraph(baseMapFromOtherDb, config, null);
                            });
                        }
                    }
                } else {
                    return this.toSubGraph(this.tx.execute(inputString, sourceDestConfig.getParams()), config, null);
                }
            }
            return this.toSubGraph(this.tx.execute(inputString), config, null);
        }
        if (input instanceof Result) {
            Result result = (Result)input;
            return CypherResultSubGraph.from((Transaction)this.tx, (Result)result, (boolean)Util.toBoolean((Object)config.isRelsInBetween()));
        }
        if (input instanceof Path) {
            Path path = (Path)input;
            return new NodesAndRelsSubGraph(this.tx, Iterables.asCollection((Iterable)path.nodes()), Iterables.asCollection((Iterable)path.relationships()));
        }
        throw new IllegalArgumentException("Unsupported input type: " + input.getClass().getName());
    }

    private Map<String, List<Object>> createMapFromRemoteDb(String inputString, Map<String, Object> boltConfig, String url, Map<String, Object> params) {
        params = params == null ? Collections.emptyMap() : params;
        String boltLoadQuery = "CALL apoc.bolt.load($url, $boltQuery, $params, $boltConfig) YIELD row";
        boltConfig.putIfAbsent("virtual", true);
        boltConfig.putIfAbsent("withRelationshipNodeProperties", true);
        Result result = this.tx.execute(boltLoadQuery, Util.map((Object[])new Object[]{"boltConfig", boltConfig, "boltQuery", inputString, "url", url, "params", params}));
        return this.createMapAndSchema(result, false, () -> this.retrieveSchemaFromOtherDB(boltLoadQuery, boltConfig, url));
    }

    private Map<String, List<Object>> createMapAndSchema(Result result, boolean dbDestType, Supplier<Optional<List<Object>>> retrieveSchemaSuppl) {
        Map<String, List<Object>> graph = this.createBaseMapFromOtherDb(result, dbDestType);
        Optional<List<Object>> schemaOpt = retrieveSchemaSuppl.get();
        schemaOpt.ifPresent(schema -> graph.put("schema", (List<Object>)schema));
        return graph;
    }

    private Optional<List<Object>> retrieveSchemaFromOtherDB(String boltLoadQuery, Map<String, Object> boltConfig, String url) {
        return this.tx.execute(boltLoadQuery, Util.map((Object[])new Object[]{"boltConfig", boltConfig, "boltQuery", BOLT_SCHEMA_QUERY, "url", url, "params", Collections.emptyMap()})).stream().map(row -> (Map)row.get("row")).map(row -> (List)row.get("schema")).findFirst();
    }

    private Map<String, List<Object>> createBaseMapFromOtherDb(Result execute2, boolean dbDestType) {
        return execute2.stream().map(row -> dbDestType ? row : row.get("row")).map(this::extractGraphEntity).flatMap(elem -> elem instanceof Collection ? ((Collection)elem).stream() : Stream.of(elem)).flatMap(elem -> {
            if (elem instanceof Path) {
                Path path = (Path)elem;
                return Stream.concat(StreamSupport.stream(path.nodes().spliterator(), false), StreamSupport.stream(path.relationships().spliterator(), false));
            }
            return Stream.of(elem);
        }).map(value -> {
            String key;
            if (value instanceof Node) {
                key = "nodes";
                if (dbDestType) {
                    Node node = (Node)value;
                    Label[] labels = (Label[])StreamSupport.stream(node.getLabels().spliterator(), false).toArray(Label[]::new);
                    value = new VirtualNode(node.getId(), labels, node.getAllProperties());
                }
            } else {
                key = "relationships";
                if (dbDestType) {
                    Relationship rel = (Relationship)value;
                    Node startNode = rel.getStartNode();
                    Node endNode = rel.getEndNode();
                    Label[] labelsEnd = (Label[])StreamSupport.stream(endNode.getLabels().spliterator(), false).toArray(Label[]::new);
                    Label[] labelsStart = (Label[])StreamSupport.stream(startNode.getLabels().spliterator(), false).toArray(Label[]::new);
                    VirtualNode start2 = new VirtualNode(startNode.getId(), labelsStart, startNode.getAllProperties());
                    VirtualNode end = new VirtualNode(endNode.getId(), labelsEnd, endNode.getAllProperties());
                    value = new VirtualRelationship(rel.getId(), (Node)start2, (Node)end, rel.getType(), rel.getAllProperties());
                }
            }
            return new AbstractMap.SimpleEntry<String, Object>(key, value);
        }).collect(Collectors.groupingBy(e -> (String)e.getKey(), Collectors.mapping(e -> e.getValue(), Collectors.toList())));
    }

    private Object extractGraphEntity(Object input) {
        if (input instanceof Collection) {
            return ((Collection)input).stream().flatMap(elem -> elem instanceof Collection ? ((Collection)elem).stream() : Stream.of(elem)).map(this::extractGraphEntity).collect(Collectors.toList());
        }
        if (input instanceof Map) {
            Map map = (Map)input;
            return this.extractGraphEntity(map.values());
        }
        if (input instanceof Node || input instanceof Relationship || input instanceof Path) {
            return input;
        }
        throw new RuntimeException("Type not managed: " + input.getClass().getSimpleName());
    }

    private Map<String, Long> countByLabel(SubGraph graph) {
        return StreamSupport.stream(graph.getNodes().spliterator(), false).flatMap(n -> StreamSupport.stream(n.getLabels().spliterator(), false).map(Label::name)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    private Map<String, Long> countByType(SubGraph graph) {
        return StreamSupport.stream(graph.getRelationships().spliterator(), false).map(r -> r.getType().name()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    private SourceDestResult sourceDestCountByLabel(SubGraph source, SubGraph dest) {
        return new SourceDestResult(COUNT_BY_LABEL, NODE, this.countByLabel(source), this.countByLabel(dest));
    }

    private SourceDestResult sourceDestCountByType(SubGraph source, SubGraph dest) {
        return new SourceDestResult(COUNT_BY_TYPE, RELATIONSHIP, this.countByType(source), this.countByType(dest));
    }

    private <T extends Entity> T findEntityById(Iterable<T> it, long id) {
        return (T)((Entity)StreamSupport.stream(it.spliterator(), true).filter(entity -> entity.getId() == id).findFirst().orElse(null));
    }

    private Node findNode(Iterable<Node> it, Node node, SubGraph graph, DiffConfig config) {
        ConstraintDefinition constraintDefinition = this.getConstraint(node, graph);
        if (constraintDefinition == null) {
            return config.isFindById() ? this.findEntityById(it, node.getId()) : null;
        }
        Map<String, Object> keys = this.getNodeKeys(node, constraintDefinition);
        return StreamSupport.stream(it.spliterator(), true).filter(entity -> entity.getProperties((String[])Iterables.asArray(String.class, keys.keySet())).equals(keys)).findFirst().orElse(null);
    }

    private ConstraintDefinition getConstraint(Node node, SubGraph graph) {
        ConstraintDefinition constraintDefinition = null;
        block0: for (Label label : node.getLabels()) {
            for (ConstraintDefinition constr : graph.getConstraints()) {
                if (!constr.getLabel().name().equals(label.name())) continue;
                long count = Iterables.count((Iterable)constr.getPropertyKeys());
                if (constraintDefinition != null && Iterables.count((Iterable)constraintDefinition.getPropertyKeys()) <= count) continue;
                constraintDefinition = constr;
                if (count != 1L) continue;
                continue block0;
            }
        }
        return constraintDefinition;
    }

    private SourceDestDTO sourceDestMap(Object sourceVal, Object destVal) {
        return new SourceDestDTO(this, sourceVal, destVal);
    }

    private SourceDestDTO transformDiff(Map<String, Map<String, Object>> propDiffs) {
        HashMap sourceFields = new HashMap();
        HashMap destFields = new HashMap();
        propDiffs.forEach((prop, diff) -> {
            sourceFields.put(prop, diff.get("left"));
            destFields.put(prop, diff.get("right"));
        });
        return this.sourceDestMap(sourceFields, destFields);
    }

    private Stream<SourceDestResult> compareRels(SubGraph sourceGraph, SubGraph destGraph) {
        return StreamSupport.stream(sourceGraph.getRelationships().spliterator(), true).map(sourceRel -> {
            Map<String, Object> startKeys = this.getNodeKeys(sourceRel.getStartNode(), sourceGraph);
            Map<String, Object> endKeys = this.getNodeKeys(sourceRel.getEndNode(), sourceGraph);
            Map sourceRelAllProperties = sourceRel.getAllProperties();
            Relationship destRel = StreamSupport.stream(destGraph.getRelationships().spliterator(), true).filter(elem -> {
                boolean areKeysEqual;
                Map<String, Object> startDestKeys = this.getNodeKeys(elem.getStartNode(), destGraph);
                Map<String, Object> endDestKeys = this.getNodeKeys(elem.getEndNode(), destGraph);
                boolean bl = areKeysEqual = startKeys.equals(startDestKeys) && endKeys.equals(endDestKeys);
                if (!sourceRelAllProperties.isEmpty()) {
                    return areKeysEqual && sourceRelAllProperties.equals(elem.getAllProperties());
                }
                return areKeysEqual;
            }).findFirst().orElse(null);
            return destRel == null ? new SourceDestResult(DESTINATION_ENTITY_NOT_FOUND, RELATIONSHIP, sourceRel.getId(), sourceRel.getType().name(), null, Util.map((Object[])new Object[]{"start", startKeys, "end", endKeys, "properties", sourceRelAllProperties}), null) : null;
        }).filter(Objects::nonNull);
    }

    private Map<String, Object> getNodeKeys(Node node, ConstraintDefinition constraint) {
        if (constraint == null) {
            return Collections.emptyMap();
        }
        String[] propKeys = Iterables.asList((Iterable)constraint.getPropertyKeys()).toArray(new String[0]);
        return node.getProperties(propKeys);
    }

    private Map<String, Object> getNodeKeys(Node node, SubGraph subGraph) {
        ConstraintDefinition constraint = this.getConstraint(node, subGraph);
        return this.getNodeKeys(node, constraint);
    }

    private Stream<SourceDestResult> compareNodes(SubGraph source, SubGraph dest, DiffConfig config) {
        return StreamSupport.stream(source.getNodes().spliterator(), true).map(node -> new AbstractMap.SimpleEntry<Node, Node>((Node)node, this.findNode((Iterable<Node>)dest.getNodes(), (Node)node, dest, config))).flatMap(entry -> {
            ArrayList<SourceDestResult> diffs = new ArrayList<SourceDestResult>();
            Node sourceNode = (Node)entry.getKey();
            Node destNode = (Node)entry.getValue();
            String sourceLabel = this.getFirstLabel(sourceNode);
            long id = sourceNode.getId();
            if (destNode == null) {
                Map<String, Object> nodeKeys = this.getNodeKeys(sourceNode, this.getConstraint(sourceNode, source));
                diffs.add(new SourceDestResult(DESTINATION_ENTITY_NOT_FOUND, NODE, id, sourceLabel, null, nodeKeys, null));
            } else {
                List destLabels;
                String destLabel = this.getFirstLabel(destNode);
                List sourceLabels = FormatUtils.getLabelsSorted((Node)sourceNode);
                if (!sourceLabels.equals(destLabels = FormatUtils.getLabelsSorted((Node)destNode))) {
                    diffs.add(new SourceDestResult(DIFFERENT_LABELS, NODE, id, sourceLabel, destLabel, sourceLabels, destLabels));
                } else {
                    Map<String, Map<String, Object>> propDiff = DiffExtended.getPropertiesDiffering(sourceNode.getAllProperties(), destNode.getAllProperties());
                    if (!propDiff.isEmpty()) {
                        SourceDestDTO sourceDestDTO = this.transformDiff(propDiff);
                        diffs.add(new SourceDestResult(DIFFERENT_PROPS, NODE, id, sourceLabel, destLabel, sourceDestDTO.source, sourceDestDTO.dest));
                    } else {
                        return diffs.stream();
                    }
                }
            }
            return diffs.stream();
        });
    }

    private String getFirstLabel(Node sourceNode) {
        return StreamSupport.stream(sourceNode.getLabels().spliterator(), false).map(Label::name).findFirst().orElse(null);
    }

    public static class SourceDestResult {
        public final String difference;
        public final String entityType;
        public final Long id;
        public final String sourceLabel;
        public final String destLabel;
        public final Object source;
        public final Object dest;

        public SourceDestResult(String difference, String entityType, Long id, String sourceLabel, String destLabel, Object source, Object dest) {
            this.difference = difference;
            this.entityType = entityType;
            this.id = id;
            this.sourceLabel = sourceLabel;
            this.destLabel = destLabel;
            this.source = source;
            this.dest = dest;
        }

        public SourceDestResult(String difference, String entityType, Object source, Object dest) {
            this.difference = difference;
            this.entityType = entityType;
            this.id = null;
            this.sourceLabel = null;
            this.destLabel = null;
            this.source = source;
            this.dest = dest;
        }

        private boolean areSourceAndDestEqual() {
            if (this.source == null && this.dest == null) {
                return true;
            }
            if (this.source == null || this.dest == null) {
                return false;
            }
            return this.source.equals(this.dest);
        }
    }

    private class SourceDestDTO {
        private final Object source;
        private final Object dest;

        SourceDestDTO(DiffExtendedGraph diffExtendedGraph, Object source, Object dest) {
            this.source = source;
            this.dest = dest;
        }
    }
}

