/*
 * Decompiled with CFR 0.152.
 */
package apoc.diff;

import apoc.util.collection.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.PropertyType;

public class MapSubGraph
implements SubGraph {
    private final Collection<Node> nodes;
    private final Collection<Relationship> rels;
    private final Set<String> labels;
    private final Collection<IndexDefinition> indexes;
    private final Collection<ConstraintDefinition> constraints;

    public MapSubGraph(Map<String, Object> map) {
        this.nodes = map.getOrDefault("nodes", Collections.emptyList());
        this.labels = this.nodes.stream().flatMap(node -> StreamSupport.stream(node.getLabels().spliterator(), true).map(Label::name)).collect(Collectors.toSet());
        Collection rels = map.getOrDefault("relationships", Collections.emptyList());
        this.rels = new HashSet<Relationship>(rels);
        Collection schema = map.getOrDefault("schema", Collections.emptyList());
        this.indexes = schema.stream().map(MapIndexDefinition::new).collect(Collectors.toList());
        this.constraints = schema.stream().map(MapConstraintDefinition::new).collect(Collectors.toList());
    }

    public ResourceIterable<Node> getNodes() {
        return Iterables.asResourceIterable(this.nodes);
    }

    public ResourceIterable<Relationship> getRelationships() {
        return Iterables.asResourceIterable(this.rels);
    }

    public Iterable<IndexDefinition> getIndexes() {
        return this.indexes;
    }

    public Iterable<ConstraintDefinition> getConstraints() {
        return this.constraints;
    }

    public Iterable<ConstraintDefinition> getConstraints(Label label) {
        return null;
    }

    public Iterable<ConstraintDefinition> getConstraints(RelationshipType type) {
        return null;
    }

    public Iterable<IndexDefinition> getIndexes(Label label) {
        return null;
    }

    public Iterable<IndexDefinition> getIndexes(RelationshipType label) {
        return null;
    }

    public Iterable<RelationshipType> getAllRelationshipTypesInUse() {
        return null;
    }

    public Iterable<Label> getAllLabelsInUse() {
        return null;
    }

    public Iterator<Node> findNodes(Label label) {
        return null;
    }

    public long countsForRelationship(Label start2, RelationshipType type, Label end) {
        return 0L;
    }

    public long countsForNode(Label label) {
        return 0L;
    }

    public static class MapConstraintDefinition
    implements ConstraintDefinition {
        private final Label label;
        private final Collection<Label> labels;
        private final Collection<String> properties;

        public MapConstraintDefinition(Map<String, Object> map) {
            Collection labels = (Collection)map.get("labels");
            Collection properties = (Collection)map.get("properties");
            this.labels = labels.stream().map(Label::label).collect(Collectors.toList());
            this.label = this.labels.iterator().next();
            this.properties = properties;
        }

        public Label getLabel() {
            return this.label;
        }

        public RelationshipType getRelationshipType() {
            throw new UnsupportedOperationException("Method not implemented");
        }

        public Iterable<String> getPropertyKeys() {
            return this.properties;
        }

        public void drop() {
        }

        public ConstraintType getConstraintType() {
            return this.properties.size() == 1 ? ConstraintType.UNIQUENESS : ConstraintType.NODE_KEY;
        }

        public boolean isConstraintType(ConstraintType type) {
            return this.getConstraintType().equals((Object)type);
        }

        public String getName() {
            return null;
        }

        public PropertyType[] getPropertyType() {
            return new PropertyType[0];
        }
    }

    public static class MapIndexDefinition
    implements IndexDefinition {
        private final Collection<Label> labels;
        private final Collection<String> properties;

        public MapIndexDefinition(Map<String, Object> map) {
            Collection labels = (Collection)map.get("labels");
            Collection properties = (Collection)map.get("properties");
            this.labels = labels.stream().map(Label::label).collect(Collectors.toList());
            this.properties = properties;
        }

        public Iterable<Label> getLabels() {
            return this.labels;
        }

        public Iterable<RelationshipType> getRelationshipTypes() {
            throw new UnsupportedOperationException("Method not implemented");
        }

        public Iterable<String> getPropertyKeys() {
            return this.properties;
        }

        public IndexType getIndexType() {
            return null;
        }

        public void drop() {
        }

        public boolean isConstraintIndex() {
            return false;
        }

        public boolean isNodeIndex() {
            return true;
        }

        public boolean isRelationshipIndex() {
            return false;
        }

        public boolean isMultiTokenIndex() {
            return false;
        }

        public boolean isCompositeIndex() {
            return this.properties.size() > 1;
        }

        public String getName() {
            return null;
        }

        public Map<IndexSetting, Object> getIndexConfiguration() {
            return null;
        }
    }
}

