/*
 * Decompiled with CFR 0.152.
 */
package apoc.diff;

import java.util.Collections;
import java.util.Map;

public class SourceDestConfig {
    private final Map<String, Object> params;
    private final TargetConfig target;

    public SourceDestConfig(SourceDestConfigType type, String value, Map<String, Object> params) {
        this.target = new TargetConfig(type, value);
        this.params = params;
    }

    public TargetConfig getTarget() {
        return this.target;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public static SourceDestConfig fromMap(Map<String, Object> map) {
        Map<Object, Object> map2 = map = map == null ? Collections.emptyMap() : map;
        if (map.isEmpty()) {
            return null;
        }
        Map target = map.getOrDefault("target", Collections.emptyMap());
        SourceDestConfigType type = SourceDestConfigType.valueOf(target.getOrDefault("type", SourceDestConfigType.URL.toString()));
        return new SourceDestConfig(type, (String)target.get("value"), map.getOrDefault("params", Collections.emptyMap()));
    }

    static class TargetConfig {
        private final SourceDestConfigType type;
        private final String value;

        public TargetConfig(SourceDestConfigType type, String value) {
            this.type = type;
            this.value = value;
        }

        public SourceDestConfigType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum SourceDestConfigType {
        URL,
        DATABASE;

    }
}

