/*
 * Decompiled with CFR 0.152.
 */
package apoc.entities;

import apoc.Extended;
import apoc.result.UpdatedNodeResult;
import apoc.result.UpdatedRelationshipResult;
import apoc.util.EntityUtil;
import apoc.util.ExtendedMapUtils;
import apoc.util.ExtendedUtil;
import apoc.util.Util;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

@Extended
public class EntitiesExtended {
    public static final String INVALID_LABELS_MESSAGE = "The list of label names may not contain any `NULL` or empty `STRING` values. If you wish to match a `NODE` without a label, pass an empty list instead.";
    public static final String INVALID_IDENTIFY_PROPERTY_MESSAGE = "you need to supply at least one identifying property for a match";
    public static final String INVALID_REL_TYPE_MESSAGE = "It is not possible to match a `RELATIONSHIP` without a `RELATIONSHIP` type.";
    @Context
    public Transaction tx;

    @UserFunction(value="apoc.node.rebind")
    @Description(value="apoc.node.rebind(node - to rebind a node (i.e. executing a Transaction.getNodeById(node.getId())  ")
    public Node nodeRebind(@Name(value="node") Node node) {
        return Util.rebind((Transaction)this.tx, (Node)node);
    }

    @UserFunction(value="apoc.rel.rebind")
    @Description(value="apoc.rel.rebind(rel) - to rebind a rel (i.e. executing a Transaction.getRelationshipById(rel.getId())  ")
    public Relationship relationshipRebind(@Name(value="rel") Relationship rel) {
        return Util.rebind((Transaction)this.tx, (Relationship)rel);
    }

    @UserFunction(value="apoc.any.rebind")
    @Description(value="apoc.any.rebind(Object) - to rebind any rel, node, path, map, list or combination of them (i.e. executing a Transaction.getNodeById(node.getId()) / Transaction.getRelationshipById(rel.getId()))")
    public Object anyRebind(@Name(value="any") Object any) {
        return EntityUtil.anyRebind((Transaction)this.tx, (Object)any);
    }

    @Procedure(value="apoc.node.match", mode=Mode.WRITE)
    @Description(value="Matches the given `NODE` values with the given dynamic labels.")
    public Stream<UpdatedNodeResult> nodes(@Name(value="labels", description="The list of labels used for the generated MATCH statement.") List<String> labelNames, @Name(value="identProps", description="Properties on the node that are always matched.") Map<String, Object> identProps, @Name(value="onMatchProps", defaultValue="{}", description="Properties that are set when a node is matched.") Map<String, Object> onMatchProps) {
        Result nodeResult = this.getNodeResult(labelNames, identProps, onMatchProps);
        return nodeResult.columnAs("n").stream().map(node -> new UpdatedNodeResult((Node)node));
    }

    @Procedure(value="apoc.rel.match", mode=Mode.WRITE)
    @Description(value="Matches the given `RELATIONSHIP` values with the given dynamic types/properties.")
    public Stream<UpdatedRelationshipResult> relationship(@Name(value="startNode", description="The start node of the relationship.") Node startNode, @Name(value="relType", description="The type of the relationship.") String relType, @Name(value="identProps", description="Properties on the relationship that are always matched.") Map<String, Object> identProps, @Name(value="endNode", description="The end node of the relationship.") Node endNode, @Name(value="onMatchProps", defaultValue="{}", description="Properties that are set when a relationship is matched.") Map<String, Object> onMatchProps) {
        Result execute2 = this.getRelResult(startNode, relType, identProps, endNode, onMatchProps);
        return execute2.columnAs("r").stream().map(rel -> new UpdatedRelationshipResult((Relationship)rel));
    }

    private Result getRelResult(Node startNode, String relType, Map<String, Object> identProps, Node endNode, Map<String, Object> onMatchProps) {
        String identPropsString = this.buildIdentPropsString(identProps);
        onMatchProps = Objects.requireNonNullElse(onMatchProps, Util.map((Object[])new Object[0]));
        if (StringUtils.isBlank((CharSequence)relType)) {
            throw new IllegalArgumentException(INVALID_REL_TYPE_MESSAGE);
        }
        Map params = Util.map((Object[])new Object[]{"identProps", identProps, "onMatchProps", onMatchProps, "startNode", startNode, "endNode", endNode});
        String cypher = "WITH $startNode as startNode, $endNode as endNode MATCH (startNode)-[r:" + Util.quote((String)relType) + "{" + identPropsString + "}]->(endNode) SET r+= $onMatchProps RETURN r";
        return this.tx.execute(cypher, params);
    }

    private Result getNodeResult(List<String> labelNames, Map<String, Object> identProps, Map<String, Object> onMatchProps) {
        onMatchProps = Objects.requireNonNullElse(onMatchProps, Util.map((Object[])new Object[0]));
        labelNames = Objects.requireNonNullElse(labelNames, Collections.EMPTY_LIST);
        if (ExtendedMapUtils.isEmpty(identProps)) {
            throw new IllegalArgumentException(INVALID_IDENTIFY_PROPERTY_MESSAGE);
        }
        boolean containsInvalidLabels = labelNames.stream().anyMatch(label -> StringUtils.isBlank((CharSequence)label));
        if (containsInvalidLabels) {
            throw new IllegalArgumentException(INVALID_LABELS_MESSAGE);
        }
        Map params = Util.map((Object[])new Object[]{"identProps", identProps, "onMatchProps", onMatchProps});
        String identPropsString = this.buildIdentPropsString(identProps);
        String cypher = "MATCH (n" + ExtendedUtil.joinStringLabels(labelNames) + " {" + identPropsString + "}) SET n += $onMatchProps RETURN n";
        return this.tx.execute(cypher, params);
    }

    private String buildIdentPropsString(Map<String, Object> identProps) {
        if (identProps == null) {
            return "";
        }
        return identProps.keySet().stream().map(Util::quote).map(s -> s + ":$identProps." + s).collect(Collectors.joining(","));
    }
}

