/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.arrow;

import apoc.Extended;
import apoc.Pools;
import apoc.export.arrow.ArrowConfig;
import apoc.export.arrow.ExportArrowService;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.result.ByteArrayResult;
import apoc.result.ExportProgressInfo;
import apoc.result.VirtualGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

@Extended
public class ExportArrowExtended {
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public Pools pools;
    @Context
    public Log logger;
    @Context
    public TerminationGuard terminationGuard;

    @NotThreadSafe
    @Procedure(name="apoc.export.arrow.stream.all")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Exports the full database as an arrow byte array.")
    public Stream<ByteArrayResult> all(@Name(value="config", defaultValue="{}", description="{ batchSize = 2000 :: INTEGER }") Map<String, Object> config) {
        return new ExportArrowService(this.db, this.pools, this.terminationGuard, this.logger).stream(new DatabaseSubGraph(this.tx), new ArrowConfig(config));
    }

    @NotThreadSafe
    @Procedure(name="apoc.export.arrow.stream.graph")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Exports the given graph as an arrow byte array.")
    public Stream<ByteArrayResult> graph(@Name(value="graph", description="The graph to export.") Object graph, @Name(value="config", defaultValue="{}", description="{ batchSize = 2000 :: INTEGER }") Map<String, Object> config) {
        NodesAndRelsSubGraph subGraph;
        if (graph instanceof Map) {
            Map mGraph = (Map)graph;
            if (!mGraph.containsKey("nodes")) {
                throw new IllegalArgumentException("Graph Map must contains `nodes` field and `relationships` optionally");
            }
            subGraph = new NodesAndRelsSubGraph(this.tx, (Collection)mGraph.get("nodes"), (Collection)mGraph.get("relationships"));
        } else if (graph instanceof VirtualGraph) {
            VirtualGraph vGraph = (VirtualGraph)graph;
            subGraph = new NodesAndRelsSubGraph(this.tx, vGraph.nodes(), vGraph.relationships());
        } else {
            throw new IllegalArgumentException("Supported inputs are VirtualGraph, Map");
        }
        return new ExportArrowService(this.db, this.pools, this.terminationGuard, this.logger).stream(subGraph, new ArrowConfig(config));
    }

    @NotThreadSafe
    @Procedure(name="apoc.export.arrow.stream.query")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Exports the given Cypher query as an arrow byte array.")
    public Stream<ByteArrayResult> query(@Name(value="query", description="The query used to collect the data for export.") String query, @Name(value="config", defaultValue="{}", description="{ batchSize = 2000 :: INTEGER }") Map<String, Object> config) {
        Map params = config == null ? Collections.emptyMap() : config.getOrDefault("params", Collections.emptyMap());
        Result result = this.tx.execute(query, params);
        return new ExportArrowService(this.db, this.pools, this.terminationGuard, this.logger).stream(result, new ArrowConfig(config));
    }

    @NotThreadSafe
    @Procedure(name="apoc.export.arrow.all")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Exports the full database as an arrow file.")
    public Stream<ExportProgressInfo> all(@Name(value="file", description="The name of the file to export the data to.") String fileName, @Name(value="config", defaultValue="{}", description="{ batchSize = 2000 :: INTEGER }") Map<String, Object> config) {
        return new ExportArrowService(this.db, this.pools, this.terminationGuard, this.logger).file(fileName, new DatabaseSubGraph(this.tx), new ArrowConfig(config));
    }

    @NotThreadSafe
    @Procedure(name="apoc.export.arrow.graph")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Exports the given graph as an arrow file.")
    public Stream<ExportProgressInfo> graph(@Name(value="file", description="The name of the file to export the data to.") String fileName, @Name(value="graph", description="The graph to export.") Object graph, @Name(value="config", defaultValue="{}", description="{ batchSize = 2000 :: INTEGER }") Map<String, Object> config) {
        NodesAndRelsSubGraph subGraph;
        if (graph instanceof Map) {
            Map mGraph = (Map)graph;
            if (!mGraph.containsKey("nodes")) {
                throw new IllegalArgumentException("Graph Map must contains `nodes` field and `relationships` optionally");
            }
            subGraph = new NodesAndRelsSubGraph(this.tx, (Collection)mGraph.get("nodes"), (Collection)mGraph.get("relationships"));
        } else if (graph instanceof VirtualGraph) {
            VirtualGraph vGraph = (VirtualGraph)graph;
            subGraph = new NodesAndRelsSubGraph(this.tx, vGraph.nodes(), vGraph.relationships());
        } else {
            throw new IllegalArgumentException("Supported inputs are VirtualGraph, Map");
        }
        return new ExportArrowService(this.db, this.pools, this.terminationGuard, this.logger).file(fileName, subGraph, new ArrowConfig(config));
    }

    @NotThreadSafe
    @Procedure(name="apoc.export.arrow.query")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Exports the results from the given Cypher query as an arrow file.")
    public Stream<ExportProgressInfo> query(@Name(value="file", description="The name of the file to which the data will be exported.") String fileName, @Name(value="query", description="The query to use to collect the data for export.") String query, @Name(value="config", defaultValue="{}", description="{ batchSize = 2000 :: INTEGER }") Map<String, Object> config) {
        Map params = config == null ? Collections.emptyMap() : config.getOrDefault("params", Collections.emptyMap());
        Result result = this.tx.execute(query, params);
        return new ExportArrowService(this.db, this.pools, this.terminationGuard, this.logger).file(fileName, result, new ArrowConfig(config));
    }
}

