/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.arrow;

import apoc.ApocConfig;
import apoc.Pools;
import apoc.export.arrow.ArrowConfig;
import apoc.export.arrow.ExportGraphFileStrategy;
import apoc.export.arrow.ExportGraphStreamStrategy;
import apoc.export.arrow.ExportResultFileStrategy;
import apoc.export.arrow.ExportResultStreamStrategy;
import apoc.result.ByteArrayResult;
import apoc.result.ExportProgressInfo;
import java.util.stream.Stream;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.logging.Log;
import org.neo4j.procedure.TerminationGuard;

public class ExportArrowService {
    public static final String EXPORT_TO_FILE_ARROW_ERROR = "Export to files not enabled, please set apoc.export.file.enabled=true in your apoc.conf.\nOtherwise, if you are running in a cloud environment without filesystem access, use the apoc.export.arrow.stream.* procedures to stream the export back to your client.";
    private final GraphDatabaseService db;
    private final Pools pools;
    private final TerminationGuard terminationGuard;
    private final Log logger;

    public ExportArrowService(GraphDatabaseService db, Pools pools, TerminationGuard terminationGuard, Log logger) {
        this.db = db;
        this.pools = pools;
        this.terminationGuard = terminationGuard;
        this.logger = logger;
    }

    public Stream<ByteArrayResult> stream(Object data2, ArrowConfig config) {
        if (data2 instanceof Result) {
            return new ExportResultStreamStrategy(this.db, this.pools, this.terminationGuard, this.logger).export((Result)data2, config);
        }
        return new ExportGraphStreamStrategy(this.db, this.pools, this.terminationGuard, this.logger).export((SubGraph)data2, config);
    }

    public Stream<ExportProgressInfo> file(String fileName, Object data2, ArrowConfig config) {
        if (!ApocConfig.apocConfig().getBoolean("apoc.export.file.enabled")) {
            throw new RuntimeException(EXPORT_TO_FILE_ARROW_ERROR);
        }
        if (data2 instanceof Result) {
            return new ExportResultFileStrategy(fileName, this.db, this.pools, this.terminationGuard, this.logger).export((Result)data2, config);
        }
        return new ExportGraphFileStrategy(fileName, this.db, this.pools, this.terminationGuard, this.logger).export((SubGraph)data2, config);
    }
}

