/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.parquet;

import apoc.Pools;
import apoc.export.parquet.ExportParquetFileStrategy;
import apoc.export.parquet.ParquetConfig;
import apoc.export.parquet.ParquetExportType;
import apoc.export.util.ProgressReporter;
import apoc.result.ExportProgressInfo;
import apoc.util.collection.Iterables;
import java.util.Iterator;
import java.util.stream.Stream;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.logging.Log;
import org.neo4j.procedure.TerminationGuard;

public class ExportParquetGraphFileStrategy
extends ExportParquetFileStrategy<Entity, SubGraph> {
    public ExportParquetGraphFileStrategy(String fileName, GraphDatabaseService db, Pools pools, TerminationGuard terminationGuard, Log logger, ParquetExportType exportType) {
        super(fileName, db, pools, terminationGuard, logger, exportType);
    }

    @Override
    public Stream<ExportProgressInfo> export(SubGraph data2, ParquetConfig config) {
        return super.export(data2, config);
    }

    @Override
    public String getSource(SubGraph subGraph) {
        return String.format("graph: nodes(%d), rels(%d)", Iterables.count((Iterable)subGraph.getNodes()), Iterables.count((Iterable)subGraph.getRelationships()));
    }

    @Override
    public Iterator<Entity> toIterator(ProgressReporter reporter, SubGraph data2) {
        return Stream.concat(Iterables.stream((Iterable)data2.getNodes()), Iterables.stream((Iterable)data2.getRelationships())).map(entity -> {
            reporter.update(entity instanceof Node ? 1L : 0L, entity instanceof Relationship ? 1L : 0L, 0L);
            return entity;
        }).iterator();
    }
}

