/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.parquet;

import apoc.Pools;
import apoc.export.parquet.ExportParquetFileStrategy;
import apoc.export.parquet.ParquetConfig;
import apoc.export.parquet.ParquetExportType;
import apoc.export.util.ProgressReporter;
import apoc.result.ExportProgressInfo;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.logging.Log;
import org.neo4j.procedure.TerminationGuard;

public class ExportParquetResultFileStrategy
extends ExportParquetFileStrategy<Map<String, Object>, Result> {
    public ExportParquetResultFileStrategy(String fileName, GraphDatabaseService db, Pools pools, TerminationGuard terminationGuard, Log logger, ParquetExportType exportType) {
        super(fileName, db, pools, terminationGuard, logger, exportType);
    }

    @Override
    public String getSource(Result result) {
        return String.format("statement: cols(%d)", result.columns().size());
    }

    @Override
    public Iterator<Map<String, Object>> toIterator(ProgressReporter reporter, Result data2) {
        return data2.stream().peek(row -> row.forEach((key, val) -> {
            boolean notNodeNorRelationship = !(val instanceof Node) && !(val instanceof Relationship);
            reporter.update(val instanceof Node ? 1L : 0L, val instanceof Relationship ? 1L : 0L, notNodeNorRelationship ? 1L : 0L);
            if (notNodeNorRelationship) {
                reporter.nextRow();
            }
        })).iterator();
    }

    @Override
    public Stream<ExportProgressInfo> export(Result data2, ParquetConfig config) {
        return super.export(data2, config);
    }
}

