/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.parquet;

import apoc.export.parquet.ParquetConfig;
import apoc.export.parquet.ParquetExportType;
import java.io.IOException;
import java.util.List;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.schema.MessageType;

public interface ExportParquetStrategy<IN, OUT> {
    public OUT export(IN var1, ParquetConfig var2);

    default public <T> void writeRows(List<T> rows, ParquetWriter<Group> writer, ParquetExportType type, MessageType schema) {
        rows.stream().map(i -> type.toRecord(schema, i)).forEach(i -> {
            try {
                writer.write(i);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        rows.clear();
    }

    default public ParquetWriter<Group> getBuild(MessageType schema, ExampleParquetWriter.Builder builder) {
        try {
            return ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)builder.withType(schema).withValidation(false)).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

