/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.parquet;

import apoc.export.parquet.ApocParquetReader;
import apoc.export.parquet.ParquetConfig;
import apoc.util.CompressionAlgo;
import apoc.util.ExtendedUtil;
import apoc.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.graphdb.security.URLAccessValidationError;

public class ParquetReadUtil {
    public static Object toValidValue(Object object, String field, ParquetConfig config) {
        Map<String, Object> mapping = config.getMapping();
        return ExtendedUtil.toValidValue(object, field, mapping);
    }

    public static TimeUnit toTimeUnitJava(LogicalTypeAnnotation.TimeUnit unit) {
        return switch (unit) {
            default -> throw new MatchException(null, null);
            case LogicalTypeAnnotation.TimeUnit.NANOS -> TimeUnit.NANOSECONDS;
            case LogicalTypeAnnotation.TimeUnit.MICROS -> TimeUnit.MICROSECONDS;
            case LogicalTypeAnnotation.TimeUnit.MILLIS -> TimeUnit.MILLISECONDS;
        };
    }

    public static InputFile getInputFile(Object source, URLAccessChecker urlAccessChecker) throws IOException, URISyntaxException, URLAccessValidationError {
        return new ParquetStream(FileUtils.inputStreamFor((Object)source, null, null, (String)CompressionAlgo.NONE.name(), (URLAccessChecker)urlAccessChecker).readAllBytes());
    }

    public static ApocParquetReader getReader(Object source, ParquetConfig conf, URLAccessChecker urlAccessChecker) {
        try {
            return new ApocParquetReader(ParquetReadUtil.getInputFile(source, urlAccessChecker), conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ParquetStream
    implements InputFile {
        private final byte[] data;

        public ParquetStream(byte[] stream) {
            this.data = stream;
        }

        public long getLength() {
            return this.data.length;
        }

        public SeekableInputStream newStream() {
            return new DelegatingSeekableInputStream(this, new SeekableByteArrayInputStream(this.data)){

                public void seek(long newPos) {
                    ((SeekableByteArrayInputStream)this.getStream()).setPos((int)newPos);
                }

                public long getPos() {
                    return ((SeekableByteArrayInputStream)this.getStream()).getPos();
                }
            };
        }

        private static class SeekableByteArrayInputStream
        extends ByteArrayInputStream {
            public SeekableByteArrayInputStream(byte[] buf) {
                super(buf);
            }

            public void setPos(int pos) {
                this.pos = pos;
            }

            public int getPos() {
                return this.pos;
            }
        }
    }
}

