/*
 * Decompiled with CFR 0.152.
 */
package apoc.generate;

import apoc.Extended;
import apoc.generate.Neo4jGraphGenerator;
import apoc.generate.config.BarabasiAlbertConfig;
import apoc.generate.config.BasicGeneratorConfig;
import apoc.generate.config.DistributionBasedConfig;
import apoc.generate.config.ErdosRenyiConfig;
import apoc.generate.config.NumberOfNodesBasedConfig;
import apoc.generate.config.WattsStrogatzConfig;
import apoc.generate.node.DefaultNodeCreator;
import apoc.generate.node.NodeCreator;
import apoc.generate.node.SocialNetworkNodeCreator;
import apoc.generate.relationship.BarabasiAlbertRelationshipGenerator;
import apoc.generate.relationship.CompleteGraphRelationshipGenerator;
import apoc.generate.relationship.DefaultRelationshipCreator;
import apoc.generate.relationship.ErdosRenyiRelationshipGenerator;
import apoc.generate.relationship.RelationshipGenerator;
import apoc.generate.relationship.SimpleGraphRelationshipGenerator;
import apoc.generate.relationship.SocialNetworkRelationshipCreator;
import apoc.generate.relationship.WattsStrogatzRelationshipGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class Generate {
    @Context
    public GraphDatabaseService db;

    @Procedure(name="apoc.generate.ba", mode=Mode.WRITE)
    @Description(value="apoc.generate.ba(noNodes, edgesPerNode, label, type) - generates a random graph according to the Barabasi-Albert model")
    public void barabasiAlbert(@Name(value="noNodes") Long noNodes, @Name(value="edgesPerNode") Long edgesPerNode, @Name(value="label") String label, @Name(value="type") String relationshipType) throws IOException {
        if (noNodes == null) {
            noNodes = 1000L;
        }
        if (edgesPerNode == null) {
            edgesPerNode = 2L;
        }
        BarabasiAlbertConfig barabasiAlbertConfig = new BarabasiAlbertConfig(noNodes.intValue(), edgesPerNode.intValue());
        BarabasiAlbertRelationshipGenerator relationshipGenerator = new BarabasiAlbertRelationshipGenerator(barabasiAlbertConfig);
        this.generateGraph(relationshipGenerator, label, relationshipType);
    }

    @Procedure(name="apoc.generate.ws", mode=Mode.WRITE)
    @Description(value="apoc.generate.ws(noNodes, degree, beta, label, type) - generates a random graph according to the Watts-Strogatz model")
    public void wattsStrogatz(@Name(value="noNodes") Long noNodes, @Name(value="degree") Long degree, @Name(value="beta") Double beta, @Name(value="label") String label, @Name(value="type") String relationshipType) throws IOException {
        if (noNodes == null) {
            noNodes = 1000L;
        }
        if (degree == null) {
            degree = 4L;
        }
        if (beta == null) {
            beta = 0.5;
        }
        WattsStrogatzConfig wattsStrogatzConfig = new WattsStrogatzConfig(noNodes.intValue(), degree.intValue(), beta);
        WattsStrogatzRelationshipGenerator relationshipGenerator = new WattsStrogatzRelationshipGenerator(wattsStrogatzConfig);
        this.generateGraph(relationshipGenerator, label, relationshipType);
    }

    @Procedure(name="apoc.generate.er", mode=Mode.WRITE)
    @Description(value="apoc.generate.er(noNodes, noEdges, label, type) - generates a random graph according to the Erdos-Renyi model")
    public void erdosRenyi(@Name(value="noNodes") Long noNodes, @Name(value="noEdges") Long noEdges, @Name(value="label") String label, @Name(value="type") String relationshipType) throws IOException {
        if (noNodes == null) {
            noNodes = 1000L;
        }
        if (noEdges == null) {
            noEdges = 10000L;
        }
        ErdosRenyiConfig erdosRenyiConfig = new ErdosRenyiConfig(noNodes.intValue(), noEdges.intValue());
        ErdosRenyiRelationshipGenerator relationshipGenerator = new ErdosRenyiRelationshipGenerator(erdosRenyiConfig);
        this.generateGraph(relationshipGenerator, label, relationshipType);
    }

    @Procedure(name="apoc.generate.complete", mode=Mode.WRITE)
    @Description(value="apoc.generate.complete(noNodes, label, type) - generates a random complete graph")
    public void complete(@Name(value="noNodes") Long noNodes, @Name(value="label") String label, @Name(value="type") String relationshipType) throws IOException {
        if (noNodes == null) {
            noNodes = 1000L;
        }
        NumberOfNodesBasedConfig numberOfNodesBasedConfig = new NumberOfNodesBasedConfig(noNodes.intValue());
        CompleteGraphRelationshipGenerator relationshipGenerator = new CompleteGraphRelationshipGenerator(numberOfNodesBasedConfig);
        this.generateGraph(relationshipGenerator, label, relationshipType);
    }

    @Procedure(name="apoc.generate.simple", mode=Mode.WRITE)
    @Description(value="apoc.generate.simple(degrees, label, type) - generates a simple random graph according to the given degree distribution")
    public void simple(@Name(value="degrees") List<Long> degrees, @Name(value="label") String label, @Name(value="type") String relationshipType) throws IOException {
        if (degrees == null) {
            degrees = Arrays.asList(2L, 2L, 2L, 2L);
        }
        List<Integer> intDegrees = degrees.stream().map(Long::intValue).collect(Collectors.toList());
        SimpleGraphRelationshipGenerator relationshipGenerator = new SimpleGraphRelationshipGenerator(new DistributionBasedConfig(intDegrees));
        this.generateGraph(relationshipGenerator, label, relationshipType);
    }

    private void generateGraph(RelationshipGenerator relationshipGenerator, String label, String type) throws IOException {
        NodeCreator nodeCreator = label == null || "Person".equals(label) ? new SocialNetworkNodeCreator() : new DefaultNodeCreator(label);
        DefaultRelationshipCreator relationshipCreator = type == null || "FRIEND_OF".equals(type) ? new SocialNetworkRelationshipCreator() : new DefaultRelationshipCreator(type);
        BasicGeneratorConfig configuration = new BasicGeneratorConfig(relationshipGenerator, nodeCreator, relationshipCreator);
        new Neo4jGraphGenerator(this.db).generateGraph(configuration);
    }
}

