/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka;

import apoc.ApocConfig;
import apoc.kafka.config.StreamsConfig;
import apoc.kafka.consumer.StreamsSinkConfigurationListener;
import apoc.kafka.producer.StreamsRouterConfigurationListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lapoc/kafka/KafkaHandler;", "Lorg/neo4j/kernel/lifecycle/LifecycleAdapter;", "db", "Lorg/neo4j/kernel/internal/GraphDatabaseAPI;", "log", "Lorg/neo4j/logging/Log;", "(Lorg/neo4j/kernel/internal/GraphDatabaseAPI;Lorg/neo4j/logging/Log;)V", "()V", "start", "", "stop", "apoc"})
public final class KafkaHandler
extends LifecycleAdapter {
    private GraphDatabaseAPI db;
    private Log log;

    public KafkaHandler() {
    }

    public KafkaHandler(@NotNull GraphDatabaseAPI db, @NotNull Log log) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this();
        this.db = db;
        this.log = log;
    }

    public void start() {
        if (ApocConfig.apocConfig().getBoolean("apoc.kafka.enabled")) {
            Object[] objectArray;
            try {
                Log log;
                GraphDatabaseAPI graphDatabaseAPI = this.db;
                if (graphDatabaseAPI == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"db");
                    graphDatabaseAPI = null;
                }
                if ((log = this.log) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"log");
                    log = null;
                }
                new StreamsRouterConfigurationListener(graphDatabaseAPI, log).start(StreamsConfig.Companion.getConfiguration$default(StreamsConfig.Companion, null, 1, null));
            }
            catch (Exception e) {
                Log log = this.log;
                if (log == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"log");
                    log = null;
                }
                objectArray = new Object[]{e.getMessage()};
                log.error("Exception in StreamsRouterConfigurationListener {}", objectArray);
            }
            try {
                Log log;
                GraphDatabaseAPI graphDatabaseAPI = this.db;
                if (graphDatabaseAPI == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"db");
                    graphDatabaseAPI = null;
                }
                if ((log = this.log) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"log");
                    log = null;
                }
                new StreamsSinkConfigurationListener(graphDatabaseAPI, log).start(StreamsConfig.Companion.getConfiguration$default(StreamsConfig.Companion, null, 1, null));
            }
            catch (Exception e) {
                Log log = this.log;
                if (log == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"log");
                    log = null;
                }
                objectArray = new Object[]{e.getMessage()};
                log.error("Exception in StreamsSinkConfigurationListener {}", objectArray);
            }
        }
    }

    public void stop() {
        if (ApocConfig.apocConfig().getBoolean("apoc.kafka.enabled")) {
            Log log;
            Log log2;
            GraphDatabaseAPI graphDatabaseAPI = this.db;
            if (graphDatabaseAPI == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"db");
                graphDatabaseAPI = null;
            }
            if ((log2 = this.log) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"log");
                log2 = null;
            }
            new StreamsRouterConfigurationListener(graphDatabaseAPI, log2).shutdown();
            GraphDatabaseAPI graphDatabaseAPI2 = this.db;
            if (graphDatabaseAPI2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"db");
                graphDatabaseAPI2 = null;
            }
            if ((log = this.log) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"log");
                log = null;
            }
            new StreamsSinkConfigurationListener(graphDatabaseAPI2, log).shutdown();
        }
    }
}

