/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka;

import apoc.kafka.StreamPublishResult;
import apoc.kafka.StreamsEventSinkStoreEntry;
import apoc.kafka.events.StreamsEvent;
import apoc.kafka.producer.NodeRoutingConfiguration;
import apoc.kafka.producer.RelationshipRoutingConfiguration;
import apoc.kafka.producer.RoutingConfiguration;
import apoc.kafka.producer.events.StreamsEventBuilder;
import apoc.kafka.producer.kafka.KafkaEventRouter;
import apoc.kafka.utils.KafkaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J8\u0010\u0012\u001a\u00020\r2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0016\b\u0001\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0014H\u0007J>\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0016\b\u0001\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0014H\u0007R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lapoc/kafka/PublishProcedures;", "", "()V", "db", "Lorg/neo4j/kernel/internal/GraphDatabaseAPI;", "log", "Lorg/neo4j/logging/Log;", "buildStreamEvent", "Lapoc/kafka/events/StreamsEvent;", "topic", "", "payload", "checkPayloadNotNull", "", "getStreamsEventSinkStoreEntry", "Lapoc/kafka/StreamsEventSinkStoreEntry;", "isTopicNullOrEmpty", "", "publish", "config", "", "sync", "Ljava/util/stream/Stream;", "Lapoc/kafka/StreamPublishResult;", "Companion", "apoc"})
@SourceDebugExtension(value={"SMAP\nPublishProcedures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublishProcedures.kt\napoc/kafka/PublishProcedures\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1549#2:110\n1620#2,3:111\n288#2,2:114\n288#2,2:116\n*S KotlinDebug\n*F\n+ 1 PublishProcedures.kt\napoc/kafka/PublishProcedures\n*L\n42#1:110\n42#1:111,3\n82#1:114,2\n87#1:116,2\n*E\n"})
public final class PublishProcedures {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Context
    @JvmField
    @Nullable
    public GraphDatabaseAPI db;
    @Context
    @JvmField
    @Nullable
    public Log log;
    @NotNull
    private static final ConcurrentHashMap<String, StreamsEventSinkStoreEntry> streamsEventRouterStore = new ConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    @Procedure(name="apoc.kafka.publish.sync", mode=Mode.READ)
    @Description(value="apoc.kafka.publish.sync(topic, payload, config) - Allows custom synchronous streaming from Neo4j to the configured stream environment")
    @NotNull
    public final Stream<StreamPublishResult> sync(@Name(value="topic") @Nullable String topic, @Name(value="payload") @Nullable Object payload, @Name(value="config", defaultValue="{}") @Nullable Map<String, ? extends Object> config) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        KafkaUtil.INSTANCE.checkEnabled();
        if (this.isTopicNullOrEmpty(topic)) {
            Stream<StreamPublishResult> stream = Stream.empty();
            Intrinsics.checkNotNullExpressionValue(stream, (String)"empty(...)");
            return stream;
        }
        this.checkPayloadNotNull(payload);
        String string = topic;
        Intrinsics.checkNotNull((Object)string);
        Object object = payload;
        Intrinsics.checkNotNull((Object)object);
        StreamsEvent streamsEvent = this.buildStreamEvent(string, object);
        KafkaEventRouter kafkaEventRouter = this.getStreamsEventSinkStoreEntry().getEventRouter();
        List list = CollectionsKt.listOf((Object)streamsEvent);
        Map map = config;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Iterable iterable = kafkaEventRouter.sendEventsSync(topic, list, map);
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map map2 = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new StreamPublishResult((Map<String, ? extends Object>)it));
        }
        Stream<StreamPublishResult> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    @Procedure(name="apoc.kafka.publish", mode=Mode.READ)
    @Description(value="apoc.kafka.publish(topic, payload, config) - Allows custom streaming from Neo4j to the configured stream environment")
    public final void publish(@Name(value="topic") @Nullable String topic, @Name(value="payload") @Nullable Object payload, @Name(value="config", defaultValue="{}") @Nullable Map<String, ? extends Object> config) {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, topic, payload, config, null){
            int label;
            final /* synthetic */ PublishProcedures this$0;
            final /* synthetic */ String $topic;
            final /* synthetic */ Object $payload;
            final /* synthetic */ Map<String, Object> $config;
            {
                this.this$0 = $receiver;
                this.$topic = $topic;
                this.$payload = $payload;
                this.$config = $config;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        KafkaUtil.INSTANCE.checkEnabled();
                        if (PublishProcedures.access$isTopicNullOrEmpty(this.this$0, this.$topic)) {
                            return Unit.INSTANCE;
                        }
                        PublishProcedures.access$checkPayloadNotNull(this.this$0, this.$payload);
                        String string = this.$topic;
                        Intrinsics.checkNotNull((Object)string);
                        Object object2 = this.$payload;
                        Intrinsics.checkNotNull((Object)object2);
                        StreamsEvent streamsEvent = PublishProcedures.access$buildStreamEvent(this.this$0, string, object2);
                        KafkaEventRouter kafkaEventRouter = PublishProcedures.access$getStreamsEventSinkStoreEntry(this.this$0).getEventRouter();
                        List list = CollectionsKt.listOf((Object)streamsEvent);
                        Map map = this.$config;
                        if (map == null) {
                            map = MapsKt.emptyMap();
                        }
                        kafkaEventRouter.sendEvents(this.$topic, list, map);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final boolean isTopicNullOrEmpty(String topic) {
        boolean bl;
        CharSequence charSequence = topic;
        if (charSequence == null || charSequence.length() == 0) {
            Log log = this.log;
            if (log != null) {
                log.info("Topic empty, no message sent");
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void checkPayloadNotNull(Object payload) {
        if (payload == null) {
            Log log = this.log;
            if (log != null) {
                log.error("Payload empty, no message sent");
            }
            throw new RuntimeException("Payload may not be null");
        }
    }

    private final StreamsEvent buildStreamEvent(String topic, Object payload) {
        Object v1;
        StreamsEventBuilder streamsEventBuilder;
        block3: {
            Object v0;
            RoutingConfiguration it;
            Iterable $this$firstOrNull$iv;
            boolean $i$f$firstOrNull;
            block2: {
                Iterable iterable = this.getStreamsEventSinkStoreEntry().getEventRouter().getEventRouterConfiguration().getNodeRouting();
                streamsEventBuilder = new StreamsEventBuilder().withPayload(payload);
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (NodeRoutingConfiguration)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((NodeRoutingConfiguration)it).getTopic(), (Object)topic)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            $this$firstOrNull$iv = this.getStreamsEventSinkStoreEntry().getEventRouter().getEventRouterConfiguration().getRelRouting();
            streamsEventBuilder = streamsEventBuilder.withNodeRoutingConfiguration(v0);
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (RelationshipRoutingConfiguration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((RelationshipRoutingConfiguration)it).getTopic(), (Object)topic)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return streamsEventBuilder.withRelationshipRoutingConfiguration(v1).withTopic(topic).build();
    }

    private final StreamsEventSinkStoreEntry getStreamsEventSinkStoreEntry() {
        GraphDatabaseAPI graphDatabaseAPI = this.db;
        Intrinsics.checkNotNull((Object)graphDatabaseAPI);
        StreamsEventSinkStoreEntry streamsEventSinkStoreEntry = streamsEventRouterStore.get(graphDatabaseAPI.databaseName());
        Intrinsics.checkNotNull((Object)streamsEventSinkStoreEntry);
        return streamsEventSinkStoreEntry;
    }

    public static final /* synthetic */ boolean access$isTopicNullOrEmpty(PublishProcedures $this, String topic) {
        return $this.isTopicNullOrEmpty(topic);
    }

    public static final /* synthetic */ void access$checkPayloadNotNull(PublishProcedures $this, Object payload) {
        $this.checkPayloadNotNull(payload);
    }

    public static final /* synthetic */ StreamsEvent access$buildStreamEvent(PublishProcedures $this, String topic, Object payload) {
        return $this.buildStreamEvent(topic, payload);
    }

    public static final /* synthetic */ StreamsEventSinkStoreEntry access$getStreamsEventSinkStoreEntry(PublishProcedures $this) {
        return $this.getStreamsEventSinkStoreEntry();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lapoc/kafka/PublishProcedures$Companion;", "", "()V", "streamsEventRouterStore", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lapoc/kafka/StreamsEventSinkStoreEntry;", "register", "", "db", "Lorg/neo4j/kernel/internal/GraphDatabaseAPI;", "evtRouter", "Lapoc/kafka/producer/kafka/KafkaEventRouter;", "unregister", "apoc"})
    public static final class Companion {
        private Companion() {
        }

        public final void register(@NotNull GraphDatabaseAPI db, @NotNull KafkaEventRouter evtRouter) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter((Object)evtRouter, (String)"evtRouter");
            Map map = streamsEventRouterStore;
            String string = KafkaUtil.INSTANCE.getName((GraphDatabaseService)db);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = string;
            StreamsEventSinkStoreEntry streamsEventSinkStoreEntry = new StreamsEventSinkStoreEntry(evtRouter);
            map.put(string2, streamsEventSinkStoreEntry);
        }

        public final void unregister(@NotNull GraphDatabaseAPI db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            streamsEventRouterStore.remove(KafkaUtil.INSTANCE.getName((GraphDatabaseService)db));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

