/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka.config;

import apoc.ApocConfig;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationMap;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lapoc/kafka/config/StreamsConfig;", "", "()V", "Companion", "apoc"})
public final class StreamsConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SOURCE_ENABLED = "apoc.kafka.source.enabled";
    public static final boolean SOURCE_ENABLED_VALUE = true;
    @NotNull
    public static final String PROCEDURES_ENABLED = "apoc.kafka.procedures.enabled";
    public static final boolean PROCEDURES_ENABLED_VALUE = true;
    @NotNull
    public static final String SINK_ENABLED = "apoc.kafka.sink.enabled";
    public static final boolean SINK_ENABLED_VALUE = false;
    @NotNull
    public static final String CHECK_APOC_TIMEOUT = "apoc.kafka.check.apoc.timeout";
    @NotNull
    public static final String CHECK_APOC_INTERVAL = "apoc.kafka.check.apoc.interval";
    @NotNull
    public static final String CLUSTER_ONLY = "apoc.kafka.cluster.only";
    @NotNull
    public static final String CHECK_WRITEABLE_INSTANCE_INTERVAL = "apoc.kafka.check.writeable.instance.interval";
    @NotNull
    public static final String POLL_INTERVAL = "apoc.kafka.sink.poll.interval";
    @NotNull
    public static final String INSTANCE_WAIT_TIMEOUT = "apoc.kafka.wait.timeout";
    public static final long INSTANCE_WAIT_TIMEOUT_VALUE = 120000L;

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0014J(\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00142\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0014J\u001c\u0010\u0019\u001a\u00020\n2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014J$\u0010\u001a\u001a\u00020\u000e2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u0004J\u001c\u0010\u001c\u001a\u00020\u000e2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014J$\u0010\u001d\u001a\u00020\u000e2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u0004J\u001c\u0010\u001e\u001a\u00020\u000e2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014J$\u0010\u001f\u001a\u00020\u000e2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u0004J\u001c\u0010 \u001a\u00020\u000e2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lapoc/kafka/config/StreamsConfig$Companion;", "", "()V", "CHECK_APOC_INTERVAL", "", "CHECK_APOC_TIMEOUT", "CHECK_WRITEABLE_INSTANCE_INTERVAL", "CLUSTER_ONLY", "INSTANCE_WAIT_TIMEOUT", "INSTANCE_WAIT_TIMEOUT_VALUE", "", "POLL_INTERVAL", "PROCEDURES_ENABLED", "PROCEDURES_ENABLED_VALUE", "", "SINK_ENABLED", "SINK_ENABLED_VALUE", "SOURCE_ENABLED", "SOURCE_ENABLED_VALUE", "convert", "", "props", "config", "getConfiguration", "additionalConfigs", "getInstanceWaitTimeout", "hasProceduresEnabled", "dbName", "hasProceduresGloballyEnabled", "isSinkEnabled", "isSinkGloballyEnabled", "isSourceEnabled", "isSourceGloballyEnabled", "apoc"})
    @SourceDebugExtension(value={"SMAP\nStreamsConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamsConfig.kt\napoc/kafka/config/StreamsConfig$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n526#2:63\n511#2,6:64\n468#2:70\n414#2:71\n1238#3,4:72\n*S KotlinDebug\n*F\n+ 1 StreamsConfig.kt\napoc/kafka/config/StreamsConfig$Companion\n*L\n15#1:63\n15#1:64,6\n58#1:70\n58#1:71\n58#1:72,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, String> getConfiguration(@NotNull Map<String, String> additionalConfigs) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter(additionalConfigs, (String)"additionalConfigs");
            Configuration config = ApocConfig.apocConfig().getConfig();
            Map map = (Map)new ConfigurationMap(config);
            boolean $i$f$filter = false;
            void var7_5 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!(it.getValue() instanceof String)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map map2 = MapsKt.toMutableMap((Map)destination$iv$iv);
            Intrinsics.checkNotNull((Object)map2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
            Map map3 = map2;
            return this.convert(map3, additionalConfigs);
        }

        public static /* synthetic */ Map getConfiguration$default(Companion companion, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            return companion.getConfiguration(map);
        }

        public final boolean isSourceGloballyEnabled(@NotNull Map<String, ? extends Object> config) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            return Boolean.parseBoolean(String.valueOf(config.getOrDefault(StreamsConfig.SOURCE_ENABLED, (Object)true)));
        }

        public final boolean isSourceEnabled(@NotNull Map<String, ? extends Object> config, @NotNull String dbName) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
            return Boolean.parseBoolean(String.valueOf(config.getOrDefault("apoc.kafka.source.enabled.from." + dbName, (Object)this.isSourceGloballyEnabled(config))));
        }

        public final boolean hasProceduresGloballyEnabled(@NotNull Map<String, ? extends Object> config) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            return Boolean.parseBoolean(String.valueOf(config.getOrDefault(StreamsConfig.PROCEDURES_ENABLED, (Object)true)));
        }

        public final boolean hasProceduresEnabled(@NotNull Map<String, ? extends Object> config, @NotNull String dbName) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
            return Boolean.parseBoolean(String.valueOf(config.getOrDefault("apoc.kafka.procedures.enabled." + dbName, (Object)this.hasProceduresGloballyEnabled(config))));
        }

        public final boolean isSinkGloballyEnabled(@NotNull Map<String, ? extends Object> config) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            return Boolean.parseBoolean(String.valueOf(config.getOrDefault(StreamsConfig.SINK_ENABLED, (Object)false)));
        }

        public final boolean isSinkEnabled(@NotNull Map<String, ? extends Object> config, @NotNull String dbName) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
            return Boolean.parseBoolean(String.valueOf(config.getOrDefault("apoc.kafka.sink.enabled.to." + dbName, (Object)this.isSinkGloballyEnabled(config))));
        }

        public final long getInstanceWaitTimeout(@NotNull Map<String, ? extends Object> config) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            return Long.parseLong(String.valueOf(config.getOrDefault(StreamsConfig.INSTANCE_WAIT_TIMEOUT, (Object)120000L)));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, String> convert(@NotNull Map<String, String> props, @NotNull Map<String, String> config) {
            void $this$mapKeysTo$iv$iv;
            Intrinsics.checkNotNullParameter(props, (String)"props");
            Intrinsics.checkNotNullParameter(config, (String)"config");
            Map mutProps = MapsKt.toMutableMap(props);
            Object object = new Pair[]{TuplesKt.to((Object)"broker", (Object)"apoc.kafka.bootstrap.servers"), TuplesKt.to((Object)"from", (Object)"apoc.kafka.auto.offset.reset"), TuplesKt.to((Object)"autoCommit", (Object)"apoc.kafka.enable.auto.commit"), TuplesKt.to((Object)"keyDeserializer", (Object)"apoc.kafka.key.deserializer"), TuplesKt.to((Object)"valueDeserializer", (Object)"apoc.kafka.value.deserializer"), TuplesKt.to((Object)"schemaRegistryUrl", (Object)"apoc.kafka.schema.registry.url"), TuplesKt.to((Object)"groupId", (Object)"apoc.kafka.group.id")};
            Map mappingKeys = MapsKt.mapOf((Pair[])object);
            object = mutProps;
            Map<String, String> $this$mapKeys$iv = config;
            boolean $i$f$mapKeys = false;
            Map<String, String> map = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string = (String)mappingKeys.getOrDefault(it.getKey(), it.getKey());
                Map map3 = map2;
                boolean bl2 = false;
                Object v = it$iv$iv.getValue();
                map3.put(string, v);
            }
            Map map4 = destination$iv$iv;
            object.putAll(map4);
            return mutProps;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

