/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka.consumer.procedures;

import apoc.kafka.config.StreamsConfig;
import apoc.kafka.consumer.StreamsEventConsumer;
import apoc.kafka.consumer.StreamsEventConsumerFactory;
import apoc.kafka.consumer.kafka.KafkaEventSink;
import apoc.kafka.consumer.procedures.KeyValueResult;
import apoc.kafka.consumer.procedures.StreamResult;
import apoc.kafka.service.StreamsSinkEntity;
import apoc.kafka.utils.KafkaUtil;
import apoc.util.QueueBasedSpliterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\rH\u0002J2\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0016\b\u0001\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0013H\u0007J$\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J@\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00010\u00132\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0013H\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lapoc/kafka/consumer/procedures/StreamsSinkProcedures;", "", "()V", "db", "Lorg/neo4j/kernel/internal/GraphDatabaseAPI;", "log", "Lorg/neo4j/logging/Log;", "terminationGuard", "Lorg/neo4j/procedure/TerminationGuard;", "checkLeader", "Ljava/util/stream/Stream;", "Lapoc/kafka/consumer/procedures/KeyValueResult;", "lambda", "Lkotlin/Function0;", "consume", "Lapoc/kafka/consumer/procedures/StreamResult;", "topic", "", "config", "", "createConsumer", "Lapoc/kafka/consumer/StreamsEventConsumer;", "consumerConfig", "readData", "procedureConfig", "Companion", "apoc"})
@SourceDebugExtension(value={"SMAP\nStreamsSinkProcedures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamsSinkProcedures.kt\napoc/kafka/consumer/procedures/StreamsSinkProcedures\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n453#2:119\n403#2:120\n1238#3,4:121\n*S KotlinDebug\n*F\n+ 1 StreamsSinkProcedures.kt\napoc/kafka/consumer/procedures/StreamsSinkProcedures\n*L\n66#1:119\n66#1:120\n66#1:121,4\n*E\n"})
public final class StreamsSinkProcedures {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Context
    @JvmField
    @Nullable
    public Log log;
    @Context
    @JvmField
    @Nullable
    public GraphDatabaseAPI db;
    @Context
    @JvmField
    @Nullable
    public TerminationGuard terminationGuard;
    @NotNull
    private static final ConcurrentHashMap<String, KafkaEventSink> streamsEventSinkStore = new ConcurrentHashMap();

    @Procedure(name="apoc.kafka.consume", mode=Mode.READ)
    @Description(value="apoc.kafka.consume(topic, {timeout: <long value>, from: <string>, groupId: <string>, commit: <boolean>, partitions:[{partition: <number>, offset: <number>}]}) YIELD event - Allows to consume custom topics")
    @NotNull
    public final Stream<StreamResult> consume(@Name(value="topic") @Nullable String topic, @Name(value="config", defaultValue="{}") @Nullable Map<String, ? extends Object> config) {
        Object object = BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Stream<StreamResult>>, Object>(topic, this, config, null){
            int label;
            final /* synthetic */ String $topic;
            final /* synthetic */ StreamsSinkProcedures this$0;
            final /* synthetic */ Map<String, Object> $config;
            {
                this.$topic = $topic;
                this.this$0 = $receiver;
                this.$config = $config;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Stream stream;
                        ResultKt.throwOnFailure((Object)object);
                        KafkaUtil.INSTANCE.checkEnabled();
                        CharSequence charSequence = this.$topic;
                        if (charSequence == null || charSequence.length() == 0) {
                            Log log = this.this$0.log;
                            if (log != null) {
                                log.info("Topic empty, no message sent");
                            }
                            stream = Stream.empty();
                        } else {
                            Map map;
                            Map<String, Object> map2 = this.$config;
                            if (map2 != null) {
                                void $this$mapValuesTo$iv$iv;
                                Map<String, Object> $this$mapValues$iv = map2;
                                boolean $i$f$mapValues = false;
                                Map<String, Object> map3 = $this$mapValues$iv;
                                Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                                boolean $i$f$mapValuesTo = false;
                                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                                boolean $i$f$associateByTo = false;
                                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                                    void it;
                                    void it$iv$iv;
                                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                                    Map map4 = destination$iv$iv;
                                    boolean bl = false;
                                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                                    K k = it$iv$iv.getKey();
                                    Map map5 = map4;
                                    boolean bl2 = false;
                                    String string = it.getValue().toString();
                                    map5.put(k, string);
                                }
                                map = destination$iv$iv;
                            } else {
                                map = MapsKt.emptyMap();
                            }
                            Map properties = map;
                            Map<String, String> configuration = StreamsConfig.Companion.getConfiguration(properties);
                            Map map6 = this.$config;
                            if (map6 == null) {
                                map6 = MapsKt.emptyMap();
                            }
                            stream = StreamsSinkProcedures.access$readData(this.this$0, this.$topic, map6, configuration);
                        }
                        return stream;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Stream<StreamResult>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        Intrinsics.checkNotNull((Object)object);
        return (Stream)object;
    }

    private final Stream<KeyValueResult> checkLeader(Function0<? extends Stream<KeyValueResult>> lambda) {
        Stream<KeyValueResult> stream;
        GraphDatabaseAPI graphDatabaseAPI = this.db;
        Intrinsics.checkNotNull((Object)graphDatabaseAPI, (String)"null cannot be cast to non-null type org.neo4j.kernel.internal.GraphDatabaseAPI");
        if (KafkaUtil.INSTANCE.isWriteableInstance(graphDatabaseAPI)) {
            stream = (Stream<KeyValueResult>)lambda.invoke();
        } else {
            Stream<KeyValueResult> stream2 = Stream.of(new KeyValueResult("error", "You can use this procedure only in the LEADER or in a single instance configuration."));
            Intrinsics.checkNotNull(stream2);
            stream = stream2;
        }
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    private final Stream<StreamResult> readData(String topic, Map<String, ? extends Object> procedureConfig, Map<String, String> consumerConfig) {
        void $this$mapValuesTo$iv$iv;
        Map<String, ? extends Object> $this$mapValues$iv = procedureConfig;
        boolean $i$f$mapValues = false;
        Map<String, ? extends Object> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Object v = !Intrinsics.areEqual(it.getKey(), (Object)"partitions") ? it.getValue() : MapsKt.mapOf((Pair)TuplesKt.to((Object)topic, it.getValue()));
            map3.put(k, v);
        }
        Map cfg = destination$iv$iv;
        long timeout = Long.parseLong(((Object)cfg.getOrDefault("timeout", 1000)).toString());
        ArrayBlockingQueue<StreamResult> data2 = new ArrayBlockingQueue<StreamResult>(1000);
        StreamResult tombstone = new StreamResult(MapsKt.emptyMap());
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, consumerConfig, topic, timeout, (Map<String, ? extends Object>)cfg, data2, tombstone, null){
            int label;
            final /* synthetic */ StreamsSinkProcedures this$0;
            final /* synthetic */ Map<String, String> $consumerConfig;
            final /* synthetic */ String $topic;
            final /* synthetic */ long $timeout;
            final /* synthetic */ Map<String, Object> $cfg;
            final /* synthetic */ ArrayBlockingQueue<StreamResult> $data;
            final /* synthetic */ StreamResult $tombstone;
            {
                this.this$0 = $receiver;
                this.$consumerConfig = $consumerConfig;
                this.$topic = $topic;
                this.$timeout = $timeout;
                this.$cfg = $cfg;
                this.$data = $data;
                this.$tombstone = $tombstone;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        StreamsEventConsumer consumer = StreamsSinkProcedures.access$createConsumer(this.this$0, this.$consumerConfig, this.$topic);
                        consumer.start();
                        try {
                            long start2 = System.currentTimeMillis();
                            while (System.currentTimeMillis() - start2 < this.$timeout) {
                                consumer.read(this.$cfg, (Function2<? super String, ? super List<StreamsSinkEntity>, Unit>)((Function2)new Function2<String, List<? extends StreamsSinkEntity>, Unit>(this.$data){
                                    final /* synthetic */ ArrayBlockingQueue<StreamResult> $data;
                                    {
                                        this.$data = $data;
                                        super(2);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final void invoke(@NotNull String string, @NotNull List<StreamsSinkEntity> topicData) {
                                        void $this$mapTo$iv$iv;
                                        void $this$map$iv;
                                        void $this$mapNotNullTo$iv$iv;
                                        Iterable $this$mapNotNull$iv;
                                        Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                                        Intrinsics.checkNotNullParameter(topicData, (String)"topicData");
                                        Iterable iterable = topicData;
                                        ArrayBlockingQueue<StreamResult> arrayBlockingQueue = this.$data;
                                        boolean $i$f$mapNotNull = false;
                                        void var5_6 = $this$mapNotNull$iv;
                                        Collection destination$iv$iv = new ArrayList<E>();
                                        boolean $i$f$mapNotNullTo = false;
                                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                        boolean $i$f$forEach = false;
                                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                                        while (iterator.hasNext()) {
                                            Object it$iv$iv;
                                            T element$iv$iv$iv;
                                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                                            boolean bl = false;
                                            StreamsSinkEntity it = (StreamsSinkEntity)element$iv$iv;
                                            boolean bl2 = false;
                                            if (it.getValue() == null) continue;
                                            boolean bl3 = false;
                                            destination$iv$iv.add(it$iv$iv);
                                        }
                                        $this$mapNotNull$iv = (List)destination$iv$iv;
                                        boolean $i$f$map = false;
                                        $this$mapNotNullTo$iv$iv = $this$map$iv;
                                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        boolean $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            void it;
                                            iterator = item$iv$iv;
                                            Collection collection = destination$iv$iv;
                                            boolean bl = false;
                                            collection.add(new StreamResult(MapsKt.mapOf((Pair)TuplesKt.to((Object)"data", (Object)it))));
                                        }
                                        arrayBlockingQueue.addAll((List)destination$iv$iv);
                                    }
                                }));
                            }
                            this.$data.add(this.$tombstone);
                        }
                        catch (Exception e) {
                            Log log = this.this$0.log;
                            Boolean bl = log != null ? Boxing.boxBoolean((boolean)log.isDebugEnabled()) : null;
                            Intrinsics.checkNotNull((Object)bl);
                            if (bl.booleanValue()) {
                                Log log2 = this.this$0.log;
                                if (log2 != null) {
                                    log2.error("Error while consuming data", (Throwable)e);
                                }
                            }
                        }
                        finally {
                            consumer.stop();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Log log = this.log;
        Boolean bl = log != null ? Boolean.valueOf(log.isDebugEnabled()) : null;
        Intrinsics.checkNotNull((Object)bl);
        if (bl.booleanValue()) {
            Log log2 = this.log;
            if (log2 != null) {
                log2.debug("Data retrieved from topic " + topic + " after " + timeout + " milliseconds: " + data2);
            }
        }
        Stream<StreamResult> stream = StreamSupport.stream((Spliterator)new QueueBasedSpliterator((BlockingQueue)data2, (Object)tombstone, this.terminationGuard, (int)timeout), false);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    private final StreamsEventConsumer createConsumer(Map<String, String> consumerConfig, String topic) {
        return (StreamsEventConsumer)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super StreamsEventConsumer>, Object>(consumerConfig, this, topic, null){
            int label;
            final /* synthetic */ Map<String, String> $consumerConfig;
            final /* synthetic */ StreamsSinkProcedures this$0;
            final /* synthetic */ String $topic;
            {
                this.$consumerConfig = $consumerConfig;
                this.this$0 = $receiver;
                this.$topic = $topic;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapValuesTo$iv$iv;
                        Map $this$filterTo$iv$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Map $this$filter$iv = StreamsConfig.Companion.getConfiguration$default(StreamsConfig.Companion, null, 1, null);
                        boolean $i$f$filter = false;
                        Map map = $this$filter$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>();
                        boolean $i$f$filterTo = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> element$iv$iv;
                            Map.Entry<K, V> it = element$iv$iv = iterator.next();
                            boolean bl = false;
                            if (!(it.getValue() instanceof String)) continue;
                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                        }
                        Map $this$mapValues$iv = destination$iv$iv;
                        boolean $i$f$mapValues = false;
                        $this$filterTo$iv$iv = $this$mapValues$iv;
                        destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                        boolean $i$f$mapValuesTo = false;
                        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                        boolean $i$f$associateByTo = false;
                        for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                            void it;
                            void it$iv$iv;
                            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                            Map map2 = destination$iv$iv;
                            boolean bl = false;
                            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                            K k = it$iv$iv.getKey();
                            Map map3 = map2;
                            boolean bl2 = false;
                            String string = (String)it.getValue();
                            map3.put(k, string);
                        }
                        Map copy = MapsKt.toMutableMap((Map)destination$iv$iv);
                        copy.putAll(this.$consumerConfig);
                        GraphDatabaseAPI graphDatabaseAPI = this.this$0.db;
                        Intrinsics.checkNotNull((Object)graphDatabaseAPI);
                        KafkaEventSink kafkaEventSink = apoc.kafka.consumer.procedures.StreamsSinkProcedures$Companion.access$getStreamsEventSink(StreamsSinkProcedures.Companion, (GraphDatabaseService)graphDatabaseAPI);
                        Intrinsics.checkNotNull((Object)kafkaEventSink);
                        StreamsEventConsumerFactory streamsEventConsumerFactory = kafkaEventSink.getEventConsumerFactory();
                        Log log = this.this$0.log;
                        Intrinsics.checkNotNull((Object)log);
                        return streamsEventConsumerFactory.createStreamsEventConsumer(copy, log, SetsKt.setOf((Object)this.$topic));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super StreamsEventConsumer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static final /* synthetic */ Stream access$readData(StreamsSinkProcedures $this, String topic, Map procedureConfig, Map consumerConfig) {
        return $this.readData(topic, procedureConfig, consumerConfig);
    }

    public static final /* synthetic */ StreamsEventConsumer access$createConsumer(StreamsSinkProcedures $this, Map consumerConfig, String topic) {
        return $this.createConsumer(consumerConfig, topic);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lapoc/kafka/consumer/procedures/StreamsSinkProcedures$Companion;", "", "()V", "streamsEventSinkStore", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lapoc/kafka/consumer/kafka/KafkaEventSink;", "getStreamsEventSink", "db", "Lorg/neo4j/graphdb/GraphDatabaseService;", "registerStreamsEventSink", "", "Lorg/neo4j/kernel/internal/GraphDatabaseAPI;", "streamsEventSink", "unregisterStreamsEventSink", "apoc"})
    public static final class Companion {
        private Companion() {
        }

        private final KafkaEventSink getStreamsEventSink(GraphDatabaseService db) {
            return (KafkaEventSink)streamsEventSinkStore.get(KafkaUtil.INSTANCE.getName(db));
        }

        public final void registerStreamsEventSink(@NotNull GraphDatabaseAPI db, @NotNull KafkaEventSink streamsEventSink) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter((Object)streamsEventSink, (String)"streamsEventSink");
            Map map = streamsEventSinkStore;
            String string = KafkaUtil.INSTANCE.getName((GraphDatabaseService)db);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            map.put(string, streamsEventSink);
        }

        @Nullable
        public final KafkaEventSink unregisterStreamsEventSink(@NotNull GraphDatabaseAPI db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            return (KafkaEventSink)streamsEventSinkStore.remove(KafkaUtil.INSTANCE.getName((GraphDatabaseService)db));
        }

        public static final /* synthetic */ KafkaEventSink access$getStreamsEventSink(Companion $this, GraphDatabaseService db) {
            return $this.getStreamsEventSink(db);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

