/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka.producer.kafka;

import apoc.kafka.extensions.CommonExtensionsKt;
import apoc.kafka.producer.kafka.KafkaConfigurationKt;
import apoc.kafka.producer.kafka.LogStrategy;
import apoc.kafka.utils.JSONUtils;
import apoc.kafka.utils.KafkaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.logging.Log;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 >2\u00020\u0001:\u0001>B\u009d\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\f\u001a\u00020\u0006\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010'\u001a\u00020(H\u0002J\u0006\u0010)\u001a\u00020(J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0006H\u00c6\u0003J\t\u0010-\u001a\u00020\u0010H\u00c6\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013H\u00c6\u0003J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\u0006H\u00c6\u0003J\t\u00102\u001a\u00020\u0006H\u00c6\u0003J\t\u00103\u001a\u00020\u0006H\u00c6\u0003J\t\u00104\u001a\u00020\u0006H\u00c6\u0003J\t\u00105\u001a\u00020\u0006H\u00c6\u0003J\t\u00106\u001a\u00020\u0006H\u00c6\u0003J\t\u00107\u001a\u00020\u0006H\u00c6\u0003J\u00a1\u0001\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00032\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013H\u00c6\u0001J\u0013\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010<\u001a\u00020\u0006H\u00d6\u0001J\t\u0010=\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018R\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0018R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0016\u00a8\u0006?"}, d2={"Lapoc/kafka/producer/kafka/KafkaConfiguration;", "", "bootstrapServers", "", "acks", "retries", "", "batchSize", "bufferMemory", "reindexBatchSize", "sessionTimeoutMs", "connectionTimeoutMs", "replication", "transactionalId", "lingerMs", "topicDiscoveryPollingInterval", "", "logCompactionStrategy", "extraProperties", "", "(Ljava/lang/String;Ljava/lang/String;IIIIIIILjava/lang/String;IJLjava/lang/String;Ljava/util/Map;)V", "getAcks", "()Ljava/lang/String;", "getBatchSize", "()I", "getBootstrapServers", "getBufferMemory", "getConnectionTimeoutMs", "getExtraProperties", "()Ljava/util/Map;", "getLingerMs", "getLogCompactionStrategy", "getReindexBatchSize", "getReplication", "getRetries", "getSessionTimeoutMs", "getTopicDiscoveryPollingInterval", "()J", "getTransactionalId", "addSerializers", "Ljava/util/Properties;", "asProperties", "component1", "component10", "component11", "component12", "component13", "component14", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "apoc"})
@SourceDebugExtension(value={"SMAP\nKafkaConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaConfiguration.kt\napoc/kafka/producer/kafka/KafkaConfiguration\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n526#2:106\n511#2,6:107\n468#2:113\n414#2:114\n1238#3,4:115\n*S KotlinDebug\n*F\n+ 1 KafkaConfiguration.kt\napoc/kafka/producer/kafka/KafkaConfiguration\n*L\n84#1:106\n84#1:107,6\n91#1:113\n91#1:114\n91#1:115,4\n*E\n"})
public final class KafkaConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String bootstrapServers;
    @NotNull
    private final String acks;
    private final int retries;
    private final int batchSize;
    private final int bufferMemory;
    private final int reindexBatchSize;
    private final int sessionTimeoutMs;
    private final int connectionTimeoutMs;
    private final int replication;
    @NotNull
    private final String transactionalId;
    private final int lingerMs;
    private final long topicDiscoveryPollingInterval;
    @NotNull
    private final String logCompactionStrategy;
    @NotNull
    private final Map<String, String> extraProperties;

    public KafkaConfiguration(@NotNull String bootstrapServers, @NotNull String acks, int retries, int batchSize, int bufferMemory, int reindexBatchSize, int sessionTimeoutMs, int connectionTimeoutMs, int replication, @NotNull String transactionalId, int lingerMs, long topicDiscoveryPollingInterval, @NotNull String logCompactionStrategy, @NotNull Map<String, String> extraProperties) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        Intrinsics.checkNotNullParameter((Object)acks, (String)"acks");
        Intrinsics.checkNotNullParameter((Object)transactionalId, (String)"transactionalId");
        Intrinsics.checkNotNullParameter((Object)logCompactionStrategy, (String)"logCompactionStrategy");
        Intrinsics.checkNotNullParameter(extraProperties, (String)"extraProperties");
        this.bootstrapServers = bootstrapServers;
        this.acks = acks;
        this.retries = retries;
        this.batchSize = batchSize;
        this.bufferMemory = bufferMemory;
        this.reindexBatchSize = reindexBatchSize;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.replication = replication;
        this.transactionalId = transactionalId;
        this.lingerMs = lingerMs;
        this.topicDiscoveryPollingInterval = topicDiscoveryPollingInterval;
        this.logCompactionStrategy = logCompactionStrategy;
        this.extraProperties = extraProperties;
    }

    public /* synthetic */ KafkaConfiguration(String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string3, int n8, long l, String string4, Map map, int n9, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n9 & 1) != 0) {
            string = "localhost:9092";
        }
        if ((n9 & 2) != 0) {
            string2 = "1";
        }
        if ((n9 & 4) != 0) {
            n = 2;
        }
        if ((n9 & 8) != 0) {
            n2 = 16384;
        }
        if ((n9 & 0x10) != 0) {
            n3 = 0x2000000;
        }
        if ((n9 & 0x20) != 0) {
            n4 = 1000;
        }
        if ((n9 & 0x40) != 0) {
            n5 = 15000;
        }
        if ((n9 & 0x80) != 0) {
            n6 = 10000;
        }
        if ((n9 & 0x100) != 0) {
            n7 = 1;
        }
        if ((n9 & 0x200) != 0) {
            string3 = "";
        }
        if ((n9 & 0x400) != 0) {
            n8 = 1;
        }
        if ((n9 & 0x800) != 0) {
            l = TimeUnit.MINUTES.toMillis(5L);
        }
        if ((n9 & 0x1000) != 0) {
            string4 = LogStrategy.delete.toString();
        }
        if ((n9 & 0x2000) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, string2, n, n2, n3, n4, n5, n6, n7, string3, n8, l, string4, map);
    }

    @NotNull
    public final String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @NotNull
    public final String getAcks() {
        return this.acks;
    }

    public final int getRetries() {
        return this.retries;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    public final int getBufferMemory() {
        return this.bufferMemory;
    }

    public final int getReindexBatchSize() {
        return this.reindexBatchSize;
    }

    public final int getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public final int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public final int getReplication() {
        return this.replication;
    }

    @NotNull
    public final String getTransactionalId() {
        return this.transactionalId;
    }

    public final int getLingerMs() {
        return this.lingerMs;
    }

    public final long getTopicDiscoveryPollingInterval() {
        return this.topicDiscoveryPollingInterval;
    }

    @NotNull
    public final String getLogCompactionStrategy() {
        return this.logCompactionStrategy;
    }

    @NotNull
    public final Map<String, String> getExtraProperties() {
        return this.extraProperties;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Properties asProperties() {
        void $this$mapKeysTo$iv$iv;
        Map $this$filterTo$iv$iv;
        Properties props = new Properties();
        Map<String, Object> $this$filter$iv = JSONUtils.INSTANCE.asMap(this);
        boolean $i$f$filter = false;
        Map<String, Object> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual(it.getKey(), (Object)"transactionalId") ? !Intrinsics.areEqual(it.getValue(), (Object)"") : true;
            if (!bl2) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$mapKeys$iv = destination$iv$iv;
        boolean $i$f$mapKeys = false;
        $this$filterTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string = CommonExtensionsKt.toPointCase((String)it.getKey());
            Map map3 = map2;
            boolean bl3 = false;
            entry = it$iv$iv.getValue();
            map3.put(string, entry);
        }
        Map map4 = destination$iv$iv;
        props.putAll((Map<?, ?>)map4);
        props.putAll(this.extraProperties);
        props.putAll((Map<?, ?>)this.addSerializers());
        return props;
    }

    private final Properties addSerializers() {
        Properties props = new Properties();
        ((Map)props).put("key.serializer", ByteArraySerializer.class);
        ((Map)props).put("value.serializer", ByteArraySerializer.class);
        return props;
    }

    @NotNull
    public final String component1() {
        return this.bootstrapServers;
    }

    @NotNull
    public final String component2() {
        return this.acks;
    }

    public final int component3() {
        return this.retries;
    }

    public final int component4() {
        return this.batchSize;
    }

    public final int component5() {
        return this.bufferMemory;
    }

    public final int component6() {
        return this.reindexBatchSize;
    }

    public final int component7() {
        return this.sessionTimeoutMs;
    }

    public final int component8() {
        return this.connectionTimeoutMs;
    }

    public final int component9() {
        return this.replication;
    }

    @NotNull
    public final String component10() {
        return this.transactionalId;
    }

    public final int component11() {
        return this.lingerMs;
    }

    public final long component12() {
        return this.topicDiscoveryPollingInterval;
    }

    @NotNull
    public final String component13() {
        return this.logCompactionStrategy;
    }

    @NotNull
    public final Map<String, String> component14() {
        return this.extraProperties;
    }

    @NotNull
    public final KafkaConfiguration copy(@NotNull String bootstrapServers, @NotNull String acks, int retries, int batchSize, int bufferMemory, int reindexBatchSize, int sessionTimeoutMs, int connectionTimeoutMs, int replication, @NotNull String transactionalId, int lingerMs, long topicDiscoveryPollingInterval, @NotNull String logCompactionStrategy, @NotNull Map<String, String> extraProperties) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        Intrinsics.checkNotNullParameter((Object)acks, (String)"acks");
        Intrinsics.checkNotNullParameter((Object)transactionalId, (String)"transactionalId");
        Intrinsics.checkNotNullParameter((Object)logCompactionStrategy, (String)"logCompactionStrategy");
        Intrinsics.checkNotNullParameter(extraProperties, (String)"extraProperties");
        return new KafkaConfiguration(bootstrapServers, acks, retries, batchSize, bufferMemory, reindexBatchSize, sessionTimeoutMs, connectionTimeoutMs, replication, transactionalId, lingerMs, topicDiscoveryPollingInterval, logCompactionStrategy, extraProperties);
    }

    public static /* synthetic */ KafkaConfiguration copy$default(KafkaConfiguration kafkaConfiguration, String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string3, int n8, long l, String string4, Map map, int n9, Object object) {
        if ((n9 & 1) != 0) {
            string = kafkaConfiguration.bootstrapServers;
        }
        if ((n9 & 2) != 0) {
            string2 = kafkaConfiguration.acks;
        }
        if ((n9 & 4) != 0) {
            n = kafkaConfiguration.retries;
        }
        if ((n9 & 8) != 0) {
            n2 = kafkaConfiguration.batchSize;
        }
        if ((n9 & 0x10) != 0) {
            n3 = kafkaConfiguration.bufferMemory;
        }
        if ((n9 & 0x20) != 0) {
            n4 = kafkaConfiguration.reindexBatchSize;
        }
        if ((n9 & 0x40) != 0) {
            n5 = kafkaConfiguration.sessionTimeoutMs;
        }
        if ((n9 & 0x80) != 0) {
            n6 = kafkaConfiguration.connectionTimeoutMs;
        }
        if ((n9 & 0x100) != 0) {
            n7 = kafkaConfiguration.replication;
        }
        if ((n9 & 0x200) != 0) {
            string3 = kafkaConfiguration.transactionalId;
        }
        if ((n9 & 0x400) != 0) {
            n8 = kafkaConfiguration.lingerMs;
        }
        if ((n9 & 0x800) != 0) {
            l = kafkaConfiguration.topicDiscoveryPollingInterval;
        }
        if ((n9 & 0x1000) != 0) {
            string4 = kafkaConfiguration.logCompactionStrategy;
        }
        if ((n9 & 0x2000) != 0) {
            map = kafkaConfiguration.extraProperties;
        }
        return kafkaConfiguration.copy(string, string2, n, n2, n3, n4, n5, n6, n7, string3, n8, l, string4, map);
    }

    @NotNull
    public String toString() {
        return "KafkaConfiguration(bootstrapServers=" + this.bootstrapServers + ", acks=" + this.acks + ", retries=" + this.retries + ", batchSize=" + this.batchSize + ", bufferMemory=" + this.bufferMemory + ", reindexBatchSize=" + this.reindexBatchSize + ", sessionTimeoutMs=" + this.sessionTimeoutMs + ", connectionTimeoutMs=" + this.connectionTimeoutMs + ", replication=" + this.replication + ", transactionalId=" + this.transactionalId + ", lingerMs=" + this.lingerMs + ", topicDiscoveryPollingInterval=" + this.topicDiscoveryPollingInterval + ", logCompactionStrategy=" + this.logCompactionStrategy + ", extraProperties=" + this.extraProperties + ")";
    }

    public int hashCode() {
        int result = this.bootstrapServers.hashCode();
        result = result * 31 + this.acks.hashCode();
        result = result * 31 + Integer.hashCode(this.retries);
        result = result * 31 + Integer.hashCode(this.batchSize);
        result = result * 31 + Integer.hashCode(this.bufferMemory);
        result = result * 31 + Integer.hashCode(this.reindexBatchSize);
        result = result * 31 + Integer.hashCode(this.sessionTimeoutMs);
        result = result * 31 + Integer.hashCode(this.connectionTimeoutMs);
        result = result * 31 + Integer.hashCode(this.replication);
        result = result * 31 + this.transactionalId.hashCode();
        result = result * 31 + Integer.hashCode(this.lingerMs);
        result = result * 31 + Long.hashCode(this.topicDiscoveryPollingInterval);
        result = result * 31 + this.logCompactionStrategy.hashCode();
        result = result * 31 + ((Object)this.extraProperties).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KafkaConfiguration)) {
            return false;
        }
        KafkaConfiguration kafkaConfiguration = (KafkaConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.bootstrapServers, (Object)kafkaConfiguration.bootstrapServers)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.acks, (Object)kafkaConfiguration.acks)) {
            return false;
        }
        if (this.retries != kafkaConfiguration.retries) {
            return false;
        }
        if (this.batchSize != kafkaConfiguration.batchSize) {
            return false;
        }
        if (this.bufferMemory != kafkaConfiguration.bufferMemory) {
            return false;
        }
        if (this.reindexBatchSize != kafkaConfiguration.reindexBatchSize) {
            return false;
        }
        if (this.sessionTimeoutMs != kafkaConfiguration.sessionTimeoutMs) {
            return false;
        }
        if (this.connectionTimeoutMs != kafkaConfiguration.connectionTimeoutMs) {
            return false;
        }
        if (this.replication != kafkaConfiguration.replication) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.transactionalId, (Object)kafkaConfiguration.transactionalId)) {
            return false;
        }
        if (this.lingerMs != kafkaConfiguration.lingerMs) {
            return false;
        }
        if (this.topicDiscoveryPollingInterval != kafkaConfiguration.topicDiscoveryPollingInterval) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.logCompactionStrategy, (Object)kafkaConfiguration.logCompactionStrategy)) {
            return false;
        }
        return Intrinsics.areEqual(this.extraProperties, kafkaConfiguration.extraProperties);
    }

    public KafkaConfiguration() {
        this(null, null, 0, 0, 0, 0, 0, 0, 0, null, 0, 0L, null, null, 16383, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006J\"\u0010\b\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\nJ0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u000f"}, d2={"Lapoc/kafka/producer/kafka/KafkaConfiguration$Companion;", "", "()V", "create", "Lapoc/kafka/producer/kafka/KafkaConfiguration;", "cfg", "", "", "from", "log", "Lorg/neo4j/logging/Log;", "validate", "", "config", "rawConfig", "apoc"})
    @SourceDebugExtension(value={"SMAP\nKafkaConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaConfiguration.kt\napoc/kafka/producer/kafka/KafkaConfiguration$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n478#2,7:106\n468#2:113\n414#2:114\n478#2,7:123\n1238#3,4:115\n1549#3:119\n1620#3,3:120\n1#4:130\n*S KotlinDebug\n*F\n+ 1 KafkaConfiguration.kt\napoc/kafka/producer/kafka/KafkaConfiguration$Companion\n*L\n38#1:106,7\n38#1:113\n38#1:114\n43#1:123,7\n38#1:115,4\n42#1:119\n42#1:120,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final KafkaConfiguration create(@NotNull Map<String, String> cfg) {
            void $this$mapTo$iv$iv;
            Object it;
            Object object;
            void $this$mapKeysTo$iv$iv;
            Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
            Map<String, String> $this$filterKeys$iv = cfg;
            boolean $i$f$filterKeys = false;
            Map<String, String> result$iv = new LinkedHashMap();
            for (Map.Entry<String, String> entry$iv : $this$filterKeys$iv.entrySet()) {
                String it2 = entry$iv.getKey();
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it2, (String)KafkaConfigurationKt.access$getConfigPrefix$p(), (boolean)false, (int)2, null)) continue;
                ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map $this$mapKeys$iv = result$iv;
            boolean $i$f$mapKeys = false;
            result$iv = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo22 = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                String string;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)((String)it.getKey()).substring(KafkaConfigurationKt.access$getConfigPrefix$p().length()), (String)"substring(...)");
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map = object;
                boolean bl2 = false;
                it = it$iv$iv.getValue();
                map.put(string, it);
            }
            Map config = destination$iv$iv;
            KafkaConfiguration kafkaConfiguration = new KafkaConfiguration(null, null, 0, 0, 0, 0, 0, 0, 0, null, 0, 0L, null, null, 16383, null);
            Iterable $this$map$iv = JSONUtils.INSTANCE.asMap(kafkaConfiguration).keySet();
            boolean $i$f$map = false;
            Iterable $i$f$mapKeysTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.add(CommonExtensionsKt.toPointCase(it));
            }
            List keys = (List)destination$iv$iv2;
            Map $this$filterKeys$iv2 = config;
            boolean $i$f$filterKeys2 = false;
            LinkedHashMap result$iv2 = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv2.entrySet()) {
                String it3 = (String)entry$iv.getKey();
                boolean bl = false;
                if (!(!keys.contains(it3))) continue;
                result$iv2.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map extraProperties = result$iv2;
            return kafkaConfiguration.copy(config.getOrDefault("bootstrap.servers", kafkaConfiguration.getBootstrapServers()), config.getOrDefault("acks", kafkaConfiguration.getAcks()), CommonExtensionsKt.getInt(config, "retries", kafkaConfiguration.getRetries()), CommonExtensionsKt.getInt(config, "batch.size", kafkaConfiguration.getBatchSize()), CommonExtensionsKt.getInt(config, "buffer.memory", kafkaConfiguration.getBufferMemory()), CommonExtensionsKt.getInt(config, "reindex.batch.size", kafkaConfiguration.getReindexBatchSize()), CommonExtensionsKt.getInt(config, "session.timeout.ms", kafkaConfiguration.getSessionTimeoutMs()), CommonExtensionsKt.getInt(config, "connection.timeout.ms", kafkaConfiguration.getConnectionTimeoutMs()), CommonExtensionsKt.getInt(config, "replication", kafkaConfiguration.getReplication()), config.getOrDefault("transactional.id", kafkaConfiguration.getTransactionalId()), CommonExtensionsKt.getInt(config, "linger.ms", kafkaConfiguration.getLingerMs()), Long.parseLong(((Object)config.getOrDefault("topic.discovery.polling.interval", kafkaConfiguration.getTopicDiscoveryPollingInterval())).toString()), config.getOrDefault("log.compaction.strategy", kafkaConfiguration.getLogCompactionStrategy()), extraProperties);
        }

        @NotNull
        public final KafkaConfiguration from(@NotNull Map<String, String> cfg, @NotNull Log log) {
            Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            KafkaConfiguration kafkaCfg = this.create(cfg);
            this.validate(kafkaCfg, cfg, log);
            return kafkaCfg;
        }

        private final void validate(KafkaConfiguration config, Map<String, String> rawConfig, Log log) {
            KafkaUtil.INSTANCE.validateConnection(config.getBootstrapServers(), "bootstrap.servers", false);
            try {
                LogStrategy.valueOf(config.getLogCompactionStrategy());
            }
            catch (IllegalArgumentException e) {
                String string;
                Log log2 = log;
                if (log2 != null) {
                    log2.warn("Invalid log compaction strategy setting, switching to default value delete");
                }
                String $this$validate_u24lambda_u244 = string = config.getLogCompactionStrategy();
                boolean bl = false;
                LogStrategy.delete.toString();
            }
        }

        static /* synthetic */ void validate$default(Companion companion, KafkaConfiguration kafkaConfiguration, Map map, Log log, int n, Object object) {
            if ((n & 4) != 0) {
                log = null;
            }
            companion.validate(kafkaConfiguration, map, log);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

