/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka.utils;

import apoc.kafka.utils.StreamsPoint;
import apoc.kafka.utils.StreamsPointCartesian;
import apoc.kafka.utils.StreamsPointWgs;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.neo4j.driver.internal.value.PointValue;
import org.neo4j.driver.types.Point;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.values.storable.CoordinateReferenceSystem;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u00a8\u0006\u0004"}, d2={"toStreamsPoint", "Lapoc/kafka/utils/StreamsPoint;", "Lorg/neo4j/driver/internal/value/PointValue;", "Lorg/neo4j/graphdb/spatial/Point;", "apoc"})
public final class JSONUtilsKt {
    @NotNull
    public static final StreamsPoint toStreamsPoint(@NotNull org.neo4j.graphdb.spatial.Point $this$toStreamsPoint) {
        StreamsPoint streamsPoint;
        Intrinsics.checkNotNullParameter((Object)$this$toStreamsPoint, (String)"<this>");
        String crsType = $this$toStreamsPoint.getCRS().getType();
        double[] coordinate = ((Coordinate)$this$toStreamsPoint.getCoordinates().get(0)).getCoordinate();
        CRS cRS = $this$toStreamsPoint.getCRS();
        if (cRS == CoordinateReferenceSystem.CARTESIAN) {
            Intrinsics.checkNotNull((Object)crsType);
            streamsPoint = new StreamsPointCartesian(crsType, coordinate[0], coordinate[1], null, 8, null);
        } else if (cRS == CoordinateReferenceSystem.CARTESIAN_3D) {
            Intrinsics.checkNotNull((Object)crsType);
            streamsPoint = new StreamsPointCartesian(crsType, coordinate[0], coordinate[1], coordinate[2]);
        } else if (cRS == CoordinateReferenceSystem.WGS_84) {
            Intrinsics.checkNotNull((Object)crsType);
            streamsPoint = new StreamsPointWgs(crsType, coordinate[0], coordinate[1], null, 8, null);
        } else if (cRS == CoordinateReferenceSystem.WGS_84_3D) {
            Intrinsics.checkNotNull((Object)crsType);
            streamsPoint = new StreamsPointWgs(crsType, coordinate[0], coordinate[1], coordinate[2]);
        } else {
            throw new IllegalArgumentException("Point type " + crsType + " not supported");
        }
        return streamsPoint;
    }

    @NotNull
    public static final StreamsPoint toStreamsPoint(@NotNull PointValue $this$toStreamsPoint) {
        StreamsPoint streamsPoint;
        Intrinsics.checkNotNullParameter((Object)$this$toStreamsPoint, (String)"<this>");
        Point point = $this$toStreamsPoint.asPoint();
        int crsType = point.srid();
        if (crsType == CoordinateReferenceSystem.CARTESIAN.getCode()) {
            streamsPoint = new StreamsPointCartesian("CARTESIAN", point.x(), point.y(), null, 8, null);
        } else if (crsType == CoordinateReferenceSystem.CARTESIAN_3D.getCode()) {
            streamsPoint = new StreamsPointCartesian("CARTESIAN_3D", point.x(), point.y(), point.z());
        } else if (crsType == CoordinateReferenceSystem.WGS_84.getCode()) {
            streamsPoint = new StreamsPointWgs("WGS_84", point.x(), point.y(), null, 8, null);
        } else if (crsType == CoordinateReferenceSystem.WGS_84_3D.getCode()) {
            streamsPoint = new StreamsPointWgs("WGS_84_3D", point.x(), point.y(), point.z());
        } else {
            throw new IllegalArgumentException("Point type " + crsType + " not supported");
        }
        return streamsPoint;
    }
}

