/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.ApocConfig;
import apoc.Extended;
import apoc.load.LDAPResult;
import apoc.util.Util;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class LoadLdap {
    @Context
    public Log log;

    @Procedure(name="apoc.load.ldap", mode=Mode.READ)
    @Description(value="apoc.load.ldap(\"key\" or {connectionMap},{searchMap}) Load entries from an ldap source (yield entry)")
    public Stream<LDAPResult> ldapQuery(@Name(value="connection") Object conn, @Name(value="search") Map<String, Object> search) {
        LDAPManager mgr = new LDAPManager(LoadLdap.getConnectionMap(conn, this.log));
        return mgr.executeSearch(search);
    }

    public static Map<String, Object> getConnectionMap(Object conn, Log log) {
        if (conn instanceof String) {
            String key = "apoc.loadldap.%s.config".formatted(conn);
            String value = ApocConfig.apocConfig().getString(key);
            if (value == null) {
                String keyOld = "apoc.loadldap%s.config".formatted(conn);
                value = ApocConfig.apocConfig().getString(keyOld);
                if (value != null && log != null) {
                    log.warn("Not to cause breaking-change, the current config `%s` is valid,\nbut in future releases it will be removed in favor of `%s` (with dot before `%s`),\nas documented here: https://neo4j.com/labs/apoc/5/database-integration/load-ldap/#_credentials.\n".formatted(keyOld, key, conn));
                }
            }
            if (value == null) {
                throw new RuntimeException("No " + key + " ldap access configuration specified");
            }
            HashMap<String, Object> config = new HashMap<String, Object>();
            String[] sConf = value.split(" ");
            config.put("ldapHost", sConf[0]);
            config.put("loginDN", sConf[1]);
            config.put("loginPW", sConf[2]);
            return config;
        }
        return (Map)conn;
    }

    public static class LDAPManager {
        private static final String LDAP_HOST_P = "ldapHost";
        private static final String LDAP_LOGIN_DN_P = "loginDN";
        private static final String LDAP_LOGIN_PW_P = "loginPW";
        private static final String LDAP_SSL = "ssl";
        private static final String SEARCH_BASE_P = "searchBase";
        private static final String SEARCH_SCOPE_P = "searchScope";
        private static final String SEARCH_FILTER_P = "searchFilter";
        private static final String SEARCH_ATTRIBUTES_P = "attributes";
        private static final String SCOPE_BASE = "SCOPE_BASE";
        private static final String SCOPE_ONE = "SCOPE_ONE";
        private static final String SCOPE_SUB = "SCOPE_SUB";
        private int ldapPort;
        private String ldapHost;
        private String loginDN;
        private String password;
        private boolean ssl;
        private LDAPConnection lc;
        private List<String> attributeList;

        public LDAPManager(Map<String, Object> connParms) {
            String sLdapHostPort = (String)connParms.get(LDAP_HOST_P);
            if (sLdapHostPort.indexOf(":") > -1) {
                this.ldapHost = sLdapHostPort.substring(0, sLdapHostPort.indexOf(":"));
                this.ldapPort = Integer.parseInt(sLdapHostPort.substring(sLdapHostPort.indexOf(":") + 1));
            } else {
                this.ldapHost = sLdapHostPort;
                this.ldapPort = 389;
            }
            this.loginDN = (String)connParms.get(LDAP_LOGIN_DN_P);
            this.password = (String)connParms.get(LDAP_LOGIN_PW_P);
            this.ssl = Util.toBoolean((Object)connParms.get(LDAP_SSL));
        }

        public Stream<LDAPResult> executeSearch(Map<String, Object> search) {
            try {
                return (Stream)this.doSearch(search).getSearchEntries().stream().map(i -> this.getMapFromEntry((SearchResultEntry)i, this.attributeList)).map(LDAPResult::new).onClose(() -> LDAPManager.closeIt(this.lc));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Map<String, Object> getMapFromEntry(SearchResultEntry entry, List<String> attributes) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(attributes.size() + 1);
            map.put("dn", entry.getDN());
            if (attributes.isEmpty()) {
                entry.getAttributes().forEach(i -> {
                    Object value = this.readValue((Attribute)i);
                    map.put(i.getName(), value);
                });
            } else {
                for (String attribute : attributes) {
                    Object value = this.readValue(entry.getAttribute(attribute));
                    if (value == null) continue;
                    map.put(attribute, value);
                }
            }
            return map;
        }

        private Object readValue(Attribute att) {
            if (att == null) {
                return null;
            }
            if (att.size() == 1) {
                return att.getValue();
            }
            return att.getValues();
        }

        public SearchResult doSearch(Map<String, Object> search) {
            String searchBase = (String)search.get(SEARCH_BASE_P);
            String searchFilter = (String)search.getOrDefault(SEARCH_FILTER_P, "(objectClass=*)");
            String sScope = (String)search.get(SEARCH_SCOPE_P);
            this.attributeList = (List)search.get(SEARCH_ATTRIBUTES_P);
            if (this.attributeList == null) {
                this.attributeList = new ArrayList<String>();
            }
            int searchScope = switch (sScope) {
                case SCOPE_BASE -> 0;
                case SCOPE_ONE -> 1;
                case SCOPE_SUB -> 2;
                default -> throw new RuntimeException("Invalid scope:" + sScope + ". value scopes are SCOPE_BASE, SCOPE_ONE and SCOPE_SUB");
            };
            try {
                this.lc = this.getConnection();
                SearchScope scope = SearchScope.valueOf((int)searchScope);
                SearchResult searchResults = this.attributeList.isEmpty() ? this.lc.search(searchBase, scope, searchFilter, new String[0]) : this.lc.search(searchBase, scope, searchFilter, this.attributeList.toArray(new String[0]));
                return searchResults;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static void closeIt(LDAPConnection lc) {
            try {
                lc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private LDAPConnection getConnection() throws GeneralSecurityException, LDAPException {
            SSLSocketFactory socketFactory = this.getSocketFactory();
            this.lc = new LDAPConnection((SocketFactory)socketFactory);
            this.lc.connect(this.ldapHost, this.ldapPort);
            this.lc.bind(this.loginDN, this.password);
            return this.lc;
        }

        private SSLSocketFactory getSocketFactory() throws GeneralSecurityException {
            if (this.ssl || this.ldapPort == 636) {
                SSLUtil sslUtil = new SSLUtil((TrustManager)new TrustAllTrustManager());
                return sslUtil.createSSLSocketFactory();
            }
            return null;
        }
    }
}

