/*
 * Decompiled with CFR 0.152.
 */
package apoc.load.jdbc;

import apoc.Extended;
import apoc.load.util.JdbcUtil;
import apoc.load.util.LoadJdbcConfig;
import apoc.result.RowResult;
import apoc.util.ExtendedUtil;
import apoc.util.MapUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class Jdbc {
    @Context
    public Log log;
    @Context
    public GraphDatabaseService db;

    @Procedure(name="apoc.load.driver")
    @Description(value="apoc.load.driver('org.apache.derby.jdbc.EmbeddedDriver') register JDBC driver of source database")
    public void driver(@Name(value="driverClass") String driverClass) {
        Jdbc.loadDriver(driverClass);
    }

    public static void loadDriver(@Name(value="driverClass") String driverClass) {
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load driver class " + driverClass + " " + e.getMessage());
        }
    }

    @Procedure(name="apoc.load.jdbc", mode=Mode.READ)
    @Description(value="apoc.load.jdbc('key or url','table or statement', params, config) YIELD row - load from relational database, from a full table or a sql statement")
    public Stream<RowResult> jdbc(@Name(value="jdbc") String urlOrKey, @Name(value="tableOrSql") String tableOrSelect, @Name(value="params", defaultValue="[]") List<Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        params = params != null ? params : Collections.emptyList();
        return Jdbc.executeQuery(urlOrKey, tableOrSelect, config, this.log, params.toArray(new Object[params.size()]));
    }

    public static Stream<RowResult> executeQuery(String urlOrKey, String tableOrSelect, Map<String, Object> config, Log log, Object ... params) {
        return Jdbc.executeQuery(urlOrKey, tableOrSelect, config, null, log, params);
    }

    public static Stream<RowResult> executeQuery(String urlOrKey, String tableOrSelect, Map<String, Object> config, Connection conn, Log log, Object ... params) {
        LoadJdbcConfig loadJdbcConfig = new LoadJdbcConfig(config);
        String url = JdbcUtil.getUrlOrKey(urlOrKey);
        String query = JdbcUtil.getSqlOrKey(tableOrSelect);
        try {
            Connection connection = conn == null ? (Connection)JdbcUtil.getConnection(url, loadJdbcConfig, Connection.class) : conn;
            connection.setAutoCommit(loadJdbcConfig.isAutoCommit());
            try {
                PreparedStatement stmt = connection.prepareStatement(query, 1003, 1007);
                stmt.setFetchSize(loadJdbcConfig.getFetchSize().intValue());
                try {
                    for (int i = 0; i < params.length; ++i) {
                        stmt.setObject(i + 1, params[i]);
                    }
                    ResultSet rs = stmt.executeQuery();
                    ResultSetIterator supplier = new ResultSetIterator(log, rs, true, loadJdbcConfig);
                    Spliterator<Map<String, Object>> spliterator = Spliterators.spliteratorUnknownSize(supplier, 16);
                    return (Stream)StreamSupport.stream(spliterator, false).map(RowResult::new).onClose(() -> Jdbc.closeIt(log, stmt, connection));
                }
                catch (Exception sqle) {
                    Jdbc.closeIt(log, stmt);
                    throw sqle;
                }
            }
            catch (Exception sqle) {
                Jdbc.closeIt(log, connection);
                throw sqle;
            }
        }
        catch (Exception e) {
            throw Jdbc.logsErrorAndThrowsException(e, query, log);
        }
    }

    @Procedure(name="apoc.load.jdbcUpdate", mode=Mode.READ)
    @Description(value="apoc.load.jdbcUpdate('key or url','statement',[params],config) YIELD row - update relational database, from a SQL statement with optional parameters")
    public Stream<RowResult> jdbcUpdate(@Name(value="jdbc") String urlOrKey, @Name(value="query") String query, @Name(value="params", defaultValue="[]") List<Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        this.log.info(String.format("Executing SQL update: %s", query));
        return Jdbc.executeUpdate(urlOrKey, query, config, this.log, params.toArray(new Object[params.size()]));
    }

    public static Stream<RowResult> executeUpdate(String urlOrKey, String query, Map<String, Object> config, Log log, Object ... params) {
        return Jdbc.executeUpdate(urlOrKey, query, config, null, log, params);
    }

    public static Stream<RowResult> executeUpdate(String urlOrKey, String query, Map<String, Object> config, Connection conn, Log log, Object ... params) {
        String url = JdbcUtil.getUrlOrKey(urlOrKey);
        LoadJdbcConfig jdbcConfig = new LoadJdbcConfig(config);
        try {
            Connection connection = conn == null ? (Connection)JdbcUtil.getConnection(url, jdbcConfig, Connection.class) : conn;
            try {
                PreparedStatement stmt = connection.prepareStatement(query, 1003, 1007);
                stmt.setFetchSize(5000);
                try {
                    for (int i = 0; i < params.length; ++i) {
                        stmt.setObject(i + 1, params[i]);
                    }
                    int updateCount = stmt.executeUpdate();
                    if (conn == null) {
                        Jdbc.closeIt(log, stmt, connection);
                    }
                    Map result = MapUtil.map((Object[])new Object[]{"count", updateCount});
                    return Stream.of(result).map(RowResult::new);
                }
                catch (Exception sqle) {
                    Jdbc.closeIt(log, stmt);
                    throw sqle;
                }
            }
            catch (Exception sqle) {
                Jdbc.closeIt(log, connection);
                throw sqle;
            }
        }
        catch (Exception e) {
            throw Jdbc.logsErrorAndThrowsException(e, query, log);
        }
    }

    private static RuntimeException logsErrorAndThrowsException(Exception e, String query, Log log) {
        String errorMessage = "Cannot execute SQL statement `%s`.%nError:%n%s";
        String exceptionMsg = e.getMessage();
        if (e.getMessage().contains("No suitable driver")) {
            errorMessage = "Cannot execute SQL statement `%s`.%nError:%n%s%n%s";
            exceptionMsg = JdbcUtil.obfuscateJdbcUrl(e.getMessage());
        }
        Exception ex = new Exception(exceptionMsg);
        log.error(String.format("Cannot execute SQL statement `%s`.%nError:%n%s", query, exceptionMsg), (Throwable)ex);
        return new RuntimeException(String.format(errorMessage, query, exceptionMsg, "Please download and copy the JDBC driver into $NEO4J_HOME/plugins, more details at https://neo4j-contrib.github.io/neo4j-apoc-procedures/#_load_jdbc_resources"), ex);
    }

    static void closeIt(Log log, AutoCloseable ... closeables) {
        for (AutoCloseable c : closeables) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (Exception e) {
                log.warn(String.format("Error closing %s: %s", c.getClass().getSimpleName(), c), (Throwable)e);
            }
        }
    }

    public static <T> T ignore(FailingSupplier<T> fun) {
        try {
            return fun.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class ResultSetIterator
    implements Iterator<Map<String, Object>> {
        private final Log log;
        private final ResultSet rs;
        private final String[] columns;
        private final boolean closeConnection;
        private Map<String, Object> map;
        private LoadJdbcConfig config;

        public ResultSetIterator(Log log, ResultSet rs, boolean closeConnection, LoadJdbcConfig config) throws SQLException {
            this.config = config;
            this.log = log;
            this.rs = rs;
            this.columns = this.getMetaData(rs);
            this.closeConnection = closeConnection;
            this.map = this.get();
        }

        private String[] getMetaData(ResultSet rs) throws SQLException {
            ResultSetMetaData meta = rs.getMetaData();
            int cols = meta.getColumnCount();
            String[] columns = new String[cols + 1];
            for (int col = 1; col <= cols; ++col) {
                columns[col] = meta.getColumnLabel(col);
            }
            return columns;
        }

        @Override
        public boolean hasNext() {
            return this.map != null;
        }

        @Override
        public Map<String, Object> next() {
            Map<String, Object> current = this.map;
            this.map = this.get();
            return current;
        }

        public Map<String, Object> get() {
            try {
                if (this.handleEndOfResults()) {
                    return null;
                }
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(this.columns.length);
                for (int col = 1; col < this.columns.length; ++col) {
                    row.put(this.columns[col], this.convert(this.rs.getObject(col), this.rs.getMetaData().getColumnType(col)));
                }
                return row;
            }
            catch (Exception e) {
                this.log.error(String.format("Cannot execute read result-set.%nError:%n%s", e.getMessage()), (Throwable)e);
                this.closeRs();
                throw new RuntimeException("Cannot execute read result-set.", e);
            }
        }

        private Object convert(Object value, int sqlType) {
            if (value == null) {
                return null;
            }
            if (value instanceof UUID || value instanceof BigInteger || value instanceof BigDecimal) {
                return value.toString();
            }
            ZoneId zoneId = this.config.getZoneId();
            if (value instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)value;
                if (zoneId != null) {
                    return localDateTime.atZone(zoneId).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                }
                return value;
            }
            if (92 == sqlType) {
                if (value instanceof Time) {
                    Time time = (Time)value;
                    return time.toLocalTime();
                }
                return value;
            }
            if (2013 == sqlType) {
                return OffsetTime.parse(value.toString());
            }
            if (93 == sqlType) {
                if (zoneId != null) {
                    return ((Timestamp)value).toInstant().atZone(zoneId).toOffsetDateTime();
                }
                return ((Timestamp)value).toLocalDateTime();
            }
            if (2014 == sqlType) {
                if (zoneId != null) {
                    return ((Timestamp)value).toInstant().atZone(zoneId).toOffsetDateTime();
                }
                return OffsetDateTime.parse(value.toString());
            }
            if (91 == sqlType) {
                if (value instanceof Date) {
                    Date date = (Date)value;
                    return date.toLocalDate();
                }
                return value;
            }
            if (2003 == sqlType) {
                try {
                    return ((Array)value).getArray();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            if (2004 == sqlType) {
                Blob blobValue = (Blob)value;
                return ResultSetIterator.convertBlobToByteArray(blobValue);
            }
            return ExtendedUtil.getNeo4jValue(value);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public static byte[] convertBlobToByteArray(Blob blob) {
            try (InputStream inputStream = blob.getBinaryStream();){
                byte[] byArray;
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                    byArray = outputStream.toByteArray();
                }
                return byArray;
            }
            catch (Exception e) {
                throw new RuntimeException("Error converting Blob to byte array", e);
            }
        }

        private boolean handleEndOfResults() throws SQLException {
            Boolean closed = this.isRsClosed();
            if (closed != null && closed.booleanValue()) {
                return true;
            }
            if (!this.rs.next()) {
                this.closeRs();
                return true;
            }
            return false;
        }

        private void closeRs() {
            Boolean closed = this.isRsClosed();
            if (closed == null || !closed.booleanValue()) {
                AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
                autoCloseableArray[0] = Jdbc.ignore(this.rs::getStatement);
                autoCloseableArray[1] = this.closeConnection ? (AutoCloseable)Jdbc.ignore(() -> this.rs.getStatement().getConnection()) : null;
                Jdbc.closeIt(this.log, autoCloseableArray);
            }
        }

        private Boolean isRsClosed() {
            try {
                return Jdbc.ignore(this.rs::isClosed);
            }
            catch (AbstractMethodError ame) {
                return null;
            }
        }
    }

    static interface FailingSupplier<T> {
        public T get() throws Exception;
    }
}

