/*
 * Decompiled with CFR 0.152.
 */
package apoc.nlp.aws;

import apoc.Extended;
import apoc.nlp.NLPHelperFunctions;
import apoc.nlp.aws.AWSClient;
import apoc.nlp.aws.AWSProcedures;
import apoc.nlp.aws.AWSVirtualEntitiesGraph;
import apoc.nlp.aws.AWSVirtualKeyPhrasesGraph;
import apoc.nlp.aws.AWSVirtualSentimentVirtualGraph;
import apoc.nlp.aws.DummyAWSClient;
import apoc.nlp.aws.RealAWSClient;
import apoc.result.NodeWithMapResult;
import apoc.result.VirtualGraph;
import apoc.util.JsonUtil;
import com.amazonaws.services.comprehend.model.BatchDetectEntitiesItemResult;
import com.amazonaws.services.comprehend.model.BatchDetectEntitiesResult;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesItemResult;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesResult;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentItemResult;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentResult;
import com.amazonaws.services.comprehend.model.BatchItemError;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0002J.\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lapoc/nlp/aws/AWSProcedures;", "", "()V", "log", "Lorg/neo4j/logging/Log;", "tx", "Lorg/neo4j/graphdb/Transaction;", "awsClient", "Lapoc/nlp/aws/AWSClient;", "config", "", "", "entitiesGraph", "Ljava/util/stream/Stream;", "Lapoc/result/VirtualGraph;", "source", "entitiesStream", "Lapoc/result/NodeWithMapResult;", "keyPhrasesGraph", "keyPhrasesStream", "sentimentGraph", "sentimentStream", "Companion", "apoc"})
@SourceDebugExtension(value={"SMAP\nAWSProcedures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AWSProcedures.kt\napoc/nlp/aws/AWSProcedures\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1559#2:199\n1590#2,4:200\n1559#2:204\n1590#2,4:205\n1549#2:209\n1620#2,3:210\n1549#2:213\n1620#2,3:214\n1559#2:217\n1590#2,4:218\n1559#2:222\n1590#2,4:223\n1549#2:227\n1620#2,3:228\n1549#2:231\n1620#2,3:232\n1559#2:235\n1590#2,4:236\n1559#2:240\n1590#2,4:241\n1549#2:245\n1620#2,3:246\n1549#2:249\n1620#2,3:250\n*S KotlinDebug\n*F\n+ 1 AWSProcedures.kt\napoc/nlp/aws/AWSProcedures\n*L\n48#1:199\n48#1:200,4\n70#1:204\n70#1:205,4\n71#1:209\n71#1:210,3\n72#1:213\n72#1:214,3\n90#1:217\n90#1:218,4\n112#1:222\n112#1:223,4\n113#1:227\n113#1:228,3\n114#1:231\n114#1:232,3\n132#1:235\n132#1:236,4\n151#1:240\n151#1:241,4\n152#1:245\n152#1:246,3\n153#1:249\n153#1:250,3\n*E\n"})
public final class AWSProcedures {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Context
    @JvmField
    @Nullable
    public Log log;
    @Context
    @JvmField
    @Nullable
    public Transaction tx;

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.entities.stream", mode=Mode.READ)
    @Description(value="Returns a stream of entities for provided text")
    @NotNull
    public final Stream<NodeWithMapResult> entitiesStream(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        AWSClient client = this.awsClient(config);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, (Object)client.entities((List<? extends Node>)batch, (int)index)));
        }
        Stream<NodeWithMapResult> stream = ((List)destination$iv$iv).stream().flatMap(arg_0 -> AWSProcedures.entitiesStream$lambda$1(entitiesStream.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"flatMap(...)");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.entities.graph", mode=Mode.WRITE)
    @Description(value="Creates a (virtual) entity graph for provided text")
    @NotNull
    public final Stream<VirtualGraph> entitiesGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List batch;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        AWSClient client = this.awsClient(config);
        RelationshipType relationshipType = NLPHelperFunctions.INSTANCE.entityRelationshipType(config);
        Object object = config.getOrDefault("writeRelationshipProperty", "score");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String relationshipProperty = (String)object;
        Object object2 = config.getOrDefault("write", (Object)false);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean storeGraph = (Boolean)object2;
        Object object3 = config.getOrDefault("scoreCutoff", (Object)0.0);
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Number");
        Number scoreCutoff = (Number)object3;
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        Iterable iterable = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        void var12_12 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, (Object)client.entities(batch, (int)index)));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            BatchDetectEntitiesResult result;
            item$iv$iv2 = (Pair)item$iv$iv3;
            collection = destination$iv$iv;
            boolean bl = false;
            batch = (List)item$iv$iv2.component1();
            BatchDetectEntitiesResult batchDetectEntitiesResult = result = (BatchDetectEntitiesResult)item$iv$iv2.component2();
            Intrinsics.checkNotNull((Object)batchDetectEntitiesResult);
            collection.add(new AWSVirtualEntitiesGraph(batchDetectEntitiesResult, batch, relationshipType, relationshipProperty, scoreCutoff));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void graph;
            item$iv$iv2 = (AWSVirtualEntitiesGraph)item$iv$iv3;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(storeGraph ? graph.createAndStore(this.tx) : graph.create());
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.keyPhrases.stream", mode=Mode.READ)
    @Description(value="Returns a stream of key phrases for provided text")
    @NotNull
    public final Stream<NodeWithMapResult> keyPhrasesStream(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        AWSClient client = this.awsClient(config);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, (Object)client.keyPhrases((List<? extends Node>)batch, (int)index)));
        }
        Stream<NodeWithMapResult> stream = ((List)destination$iv$iv).stream().flatMap(arg_0 -> AWSProcedures.keyPhrasesStream$lambda$6(keyPhrasesStream.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"flatMap(...)");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.keyPhrases.graph", mode=Mode.WRITE)
    @Description(value="Creates a (virtual) key phrases graph for provided text")
    @NotNull
    public final Stream<VirtualGraph> keyPhrasesGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List batch;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        AWSClient client = this.awsClient(config);
        RelationshipType relationshipType = NLPHelperFunctions.INSTANCE.keyPhraseRelationshipType(config);
        Object object = config.getOrDefault("writeRelationshipProperty", "score");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String relationshipProperty = (String)object;
        Object object2 = config.getOrDefault("write", (Object)false);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean storeGraph = (Boolean)object2;
        Object object3 = config.getOrDefault("scoreCutoff", (Object)0.0);
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Number");
        Number scoreCutoff = (Number)object3;
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        Iterable iterable = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        void var12_12 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, (Object)client.keyPhrases(batch, (int)index)));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            BatchDetectKeyPhrasesResult result;
            item$iv$iv2 = (Pair)item$iv$iv3;
            collection = destination$iv$iv;
            boolean bl = false;
            batch = (List)item$iv$iv2.component1();
            BatchDetectKeyPhrasesResult batchDetectKeyPhrasesResult = result = (BatchDetectKeyPhrasesResult)item$iv$iv2.component2();
            Intrinsics.checkNotNull((Object)batchDetectKeyPhrasesResult);
            collection.add(new AWSVirtualKeyPhrasesGraph(batchDetectKeyPhrasesResult, batch, relationshipType, relationshipProperty, scoreCutoff));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void graph;
            item$iv$iv2 = (AWSVirtualKeyPhrasesGraph)item$iv$iv3;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(storeGraph ? graph.createAndStore(this.tx) : graph.create());
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.sentiment.stream", mode=Mode.READ)
    @Description(value="Returns stream of sentiment for items in provided text")
    @NotNull
    public final Stream<NodeWithMapResult> sentimentStream(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        AWSClient client = this.awsClient(config);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, (Object)client.sentiment((List<? extends Node>)batch, (int)index)));
        }
        Stream<NodeWithMapResult> stream = ((List)destination$iv$iv).stream().flatMap(arg_0 -> AWSProcedures.sentimentStream$lambda$11(sentimentStream.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"flatMap(...)");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.sentiment.graph", mode=Mode.WRITE)
    @Description(value="Creates a (virtual) sentiment graph for provided text")
    @NotNull
    public final Stream<VirtualGraph> sentimentGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List batch;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        AWSClient client = this.awsClient(config);
        Object object = config.getOrDefault("write", (Object)false);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean storeGraph = (Boolean)object;
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        Iterable iterable = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        void var9_9 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, (Object)client.sentiment(batch, (int)index)));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            BatchDetectSentimentResult result;
            item$iv$iv2 = (Pair)item$iv$iv3;
            collection = destination$iv$iv;
            boolean bl = false;
            batch = (List)item$iv$iv2.component1();
            BatchDetectSentimentResult batchDetectSentimentResult = result = (BatchDetectSentimentResult)item$iv$iv2.component2();
            Intrinsics.checkNotNull((Object)batchDetectSentimentResult);
            collection.add(new AWSVirtualSentimentVirtualGraph(batchDetectSentimentResult, batch));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void graph;
            item$iv$iv2 = (AWSVirtualSentimentVirtualGraph)item$iv$iv3;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(storeGraph ? graph.createAndStore(this.tx) : graph.create());
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    private final AWSClient awsClient(Map<String, ? extends Object> config) {
        AWSClient aWSClient;
        Object object = config.getOrDefault("unsupportedDummyClient", (Object)false);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean useDummyClient = (Boolean)object;
        if (useDummyClient) {
            Log log = this.log;
            Intrinsics.checkNotNull((Object)log);
            aWSClient = new DummyAWSClient(config, log);
        } else {
            Log log = this.log;
            Intrinsics.checkNotNull((Object)log);
            aWSClient = new RealAWSClient(config, log);
        }
        return aWSClient;
    }

    private static final Stream entitiesStream$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Stream keyPhrasesStream$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Stream sentimentStream$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lapoc/nlp/aws/AWSProcedures$Companion;", "", "()V", "transformResults", "Lapoc/result/NodeWithMapResult;", "index", "", "node", "Lorg/neo4j/graphdb/Node;", "res", "Lcom/amazonaws/services/comprehend/model/BatchDetectEntitiesResult;", "Lcom/amazonaws/services/comprehend/model/BatchDetectKeyPhrasesResult;", "Lcom/amazonaws/services/comprehend/model/BatchDetectSentimentResult;", "apoc"})
    @SourceDebugExtension(value={"SMAP\nAWSProcedures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AWSProcedures.kt\napoc/nlp/aws/AWSProcedures$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1#2:199\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NodeWithMapResult transformResults(int index, @NotNull Node node, @NotNull BatchDetectEntitiesResult res) {
            NodeWithMapResult nodeWithMapResult;
            Object object;
            block4: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                List list = res.getResultList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResultList(...)");
                Iterable iterable = list;
                for (Object object2 : iterable) {
                    BatchDetectEntitiesItemResult result = (BatchDetectEntitiesItemResult)object2;
                    boolean bl = false;
                    Integer n = result.getIndex();
                    int n2 = index;
                    if (!(n != null && n == n2)) continue;
                    object = object2;
                    break block4;
                }
                object = null;
            }
            BatchDetectEntitiesItemResult result = (BatchDetectEntitiesItemResult)object;
            if (result != null) {
                ObjectMapper objectMapper = JsonUtil.OBJECT_MAPPER;
                Intrinsics.checkNotNull((Object)objectMapper);
                Object object3 = objectMapper.convertValue((Object)result, Map.class);
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                NodeWithMapResult nodeWithMapResult2 = NodeWithMapResult.withResult(node, (Map)object3);
                Intrinsics.checkNotNull((Object)nodeWithMapResult2);
                nodeWithMapResult = nodeWithMapResult2;
            } else {
                Object v8;
                block5: {
                    Object object2;
                    List list = res.getErrorList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getErrorList(...)");
                    object2 = list;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        BatchItemError error = (BatchItemError)t;
                        boolean bl = false;
                        Integer n = error.getIndex();
                        int n3 = index;
                        if (!(n != null && n == n3)) continue;
                        v8 = t;
                        break block5;
                    }
                    v8 = null;
                }
                BatchItemError err = v8;
                Pair[] pairArray = new Pair[2];
                BatchItemError batchItemError = err;
                pairArray[0] = TuplesKt.to((Object)"code", (Object)(batchItemError != null ? batchItemError.getErrorCode() : null));
                BatchItemError batchItemError2 = err;
                pairArray[1] = TuplesKt.to((Object)"message", (Object)(batchItemError2 != null ? batchItemError2.getErrorMessage() : null));
                NodeWithMapResult nodeWithMapResult3 = NodeWithMapResult.withError(node, MapsKt.mapOf((Pair[])pairArray));
                Intrinsics.checkNotNull((Object)nodeWithMapResult3);
                nodeWithMapResult = nodeWithMapResult3;
            }
            return nodeWithMapResult;
        }

        @NotNull
        public final NodeWithMapResult transformResults(int index, @NotNull Node node, @NotNull BatchDetectKeyPhrasesResult res) {
            NodeWithMapResult nodeWithMapResult;
            Object object;
            block4: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                List list = res.getResultList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResultList(...)");
                Iterable iterable = list;
                for (Object object2 : iterable) {
                    BatchDetectKeyPhrasesItemResult result = (BatchDetectKeyPhrasesItemResult)object2;
                    boolean bl = false;
                    Integer n = result.getIndex();
                    int n2 = index;
                    if (!(n != null && n == n2)) continue;
                    object = object2;
                    break block4;
                }
                object = null;
            }
            BatchDetectKeyPhrasesItemResult result = (BatchDetectKeyPhrasesItemResult)object;
            if (result != null) {
                ObjectMapper objectMapper = JsonUtil.OBJECT_MAPPER;
                Intrinsics.checkNotNull((Object)objectMapper);
                Object object3 = objectMapper.convertValue((Object)result, Map.class);
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                NodeWithMapResult nodeWithMapResult2 = NodeWithMapResult.withResult(node, (Map)object3);
                Intrinsics.checkNotNull((Object)nodeWithMapResult2);
                nodeWithMapResult = nodeWithMapResult2;
            } else {
                Object v8;
                block5: {
                    Object object2;
                    List list = res.getErrorList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getErrorList(...)");
                    object2 = list;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        BatchItemError error = (BatchItemError)t;
                        boolean bl = false;
                        Integer n = error.getIndex();
                        int n3 = index;
                        if (!(n != null && n == n3)) continue;
                        v8 = t;
                        break block5;
                    }
                    v8 = null;
                }
                BatchItemError err = v8;
                Pair[] pairArray = new Pair[2];
                BatchItemError batchItemError = err;
                pairArray[0] = TuplesKt.to((Object)"code", (Object)(batchItemError != null ? batchItemError.getErrorCode() : null));
                BatchItemError batchItemError2 = err;
                pairArray[1] = TuplesKt.to((Object)"message", (Object)(batchItemError2 != null ? batchItemError2.getErrorMessage() : null));
                NodeWithMapResult nodeWithMapResult3 = NodeWithMapResult.withError(node, MapsKt.mapOf((Pair[])pairArray));
                Intrinsics.checkNotNull((Object)nodeWithMapResult3);
                nodeWithMapResult = nodeWithMapResult3;
            }
            return nodeWithMapResult;
        }

        @NotNull
        public final NodeWithMapResult transformResults(int index, @NotNull Node node, @NotNull BatchDetectSentimentResult res) {
            NodeWithMapResult nodeWithMapResult;
            Object object;
            block4: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                List list = res.getResultList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResultList(...)");
                Iterable iterable = list;
                for (Object object2 : iterable) {
                    BatchDetectSentimentItemResult result = (BatchDetectSentimentItemResult)object2;
                    boolean bl = false;
                    Integer n = result.getIndex();
                    int n2 = index;
                    if (!(n != null && n == n2)) continue;
                    object = object2;
                    break block4;
                }
                object = null;
            }
            BatchDetectSentimentItemResult result = (BatchDetectSentimentItemResult)object;
            if (result != null) {
                ObjectMapper objectMapper = JsonUtil.OBJECT_MAPPER;
                Intrinsics.checkNotNull((Object)objectMapper);
                Object object3 = objectMapper.convertValue((Object)result, Map.class);
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                NodeWithMapResult nodeWithMapResult2 = NodeWithMapResult.withResult(node, (Map)object3);
                Intrinsics.checkNotNull((Object)nodeWithMapResult2);
                nodeWithMapResult = nodeWithMapResult2;
            } else {
                Object v8;
                block5: {
                    Object object2;
                    List list = res.getErrorList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getErrorList(...)");
                    object2 = list;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        BatchItemError error = (BatchItemError)t;
                        boolean bl = false;
                        Integer n = error.getIndex();
                        int n3 = index;
                        if (!(n != null && n == n3)) continue;
                        v8 = t;
                        break block5;
                    }
                    v8 = null;
                }
                BatchItemError err = v8;
                Pair[] pairArray = new Pair[2];
                BatchItemError batchItemError = err;
                pairArray[0] = TuplesKt.to((Object)"code", (Object)(batchItemError != null ? batchItemError.getErrorCode() : null));
                BatchItemError batchItemError2 = err;
                pairArray[1] = TuplesKt.to((Object)"message", (Object)(batchItemError2 != null ? batchItemError2.getErrorMessage() : null));
                NodeWithMapResult nodeWithMapResult3 = NodeWithMapResult.withError(node, MapsKt.mapOf((Pair[])pairArray));
                Intrinsics.checkNotNull((Object)nodeWithMapResult3);
                nodeWithMapResult = nodeWithMapResult3;
            }
            return nodeWithMapResult;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

