/*
 * Decompiled with CFR 0.152.
 */
package apoc.nlp.gcp;

import apoc.Extended;
import apoc.nlp.NLPHelperFunctions;
import apoc.nlp.gcp.DummyGCPClient;
import apoc.nlp.gcp.GCPClient;
import apoc.nlp.gcp.GCPProcedures;
import apoc.nlp.gcp.GCPVirtualClassificationGraph;
import apoc.nlp.gcp.GCPVirtualEntitiesGraph;
import apoc.nlp.gcp.RealGCPClient;
import apoc.result.NodeValueErrorMapResult;
import apoc.result.VirtualGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u00012\u0014\b\u0001\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0007J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\b\b\u0001\u0010\n\u001a\u00020\u00012\u0014\b\u0001\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0007J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u00012\u0014\b\u0001\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0007J.\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\b\b\u0001\u0010\n\u001a\u00020\u00012\u0014\b\u0001\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0007J\u001c\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lapoc/nlp/gcp/GCPProcedures;", "", "()V", "log", "Lorg/neo4j/logging/Log;", "tx", "Lorg/neo4j/graphdb/Transaction;", "classifyGraph", "Ljava/util/stream/Stream;", "Lapoc/result/VirtualGraph;", "source", "config", "", "", "classifyStream", "Lapoc/result/NodeValueErrorMapResult;", "entitiesGraph", "entitiesStream", "gcpClient", "Lapoc/nlp/gcp/GCPClient;", "apoc"})
@SourceDebugExtension(value={"SMAP\nGCPProcedures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCPProcedures.kt\napoc/nlp/gcp/GCPProcedures\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1559#2:119\n1590#2,4:120\n1559#2:124\n1590#2,4:125\n1549#2:129\n1620#2,3:130\n1549#2:133\n1620#2,3:134\n1559#2:137\n1590#2,4:138\n1559#2:142\n1590#2,4:143\n1549#2:147\n1620#2,3:148\n1549#2:151\n1620#2,3:152\n*S KotlinDebug\n*F\n+ 1 GCPProcedures.kt\napoc/nlp/gcp/GCPProcedures\n*L\n42#1:119\n42#1:120,4\n64#1:124\n64#1:125,4\n65#1:129\n65#1:130,3\n66#1:133\n66#1:134,3\n84#1:137\n84#1:138,4\n106#1:142\n106#1:143,4\n107#1:147\n107#1:148,3\n108#1:151\n108#1:152,3\n*E\n"})
public final class GCPProcedures {
    @Context
    @JvmField
    @Nullable
    public Log log;
    @Context
    @JvmField
    @Nullable
    public Transaction tx;

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.gcp.entities.stream", mode=Mode.READ)
    @Description(value="Returns a stream of entities for provided text")
    @NotNull
    public final Stream<NodeValueErrorMapResult> entitiesStream(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.INSTANCE.verifyKey(config, "key");
        GCPClient client = this.gcpClient(config);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, client.entities((List<? extends Node>)batch, (int)index)));
        }
        Stream<NodeValueErrorMapResult> stream = ((List)destination$iv$iv).stream().flatMap(arg_0 -> GCPProcedures.entitiesStream$lambda$1(entitiesStream.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"flatMap(...)");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.gcp.entities.graph", mode=Mode.WRITE)
    @Description(value="Creates a (virtual) entity graph for provided text")
    @NotNull
    public final Stream<VirtualGraph> entitiesGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List batch;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.INSTANCE.verifyKey(config, "key");
        GCPClient client = this.gcpClient(config);
        RelationshipType relationshipType = NLPHelperFunctions.INSTANCE.entityRelationshipType(config);
        Object object = config.getOrDefault("writeRelationshipProperty", "score");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String relationshipProperty = (String)object;
        Object object2 = config.getOrDefault("write", (Object)false);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean storeGraph = (Boolean)object2;
        Object object3 = config.getOrDefault("scoreCutoff", (Object)0.0);
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Number");
        Number scoreCutoff = (Number)object3;
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        Iterable iterable = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        void var12_12 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, client.entities(batch, (int)index)));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            item$iv$iv2 = (Pair)item$iv$iv3;
            collection = destination$iv$iv;
            boolean bl = false;
            batch = (List)item$iv$iv2.component1();
            List result = (List)item$iv$iv2.component2();
            collection.add(new GCPVirtualEntitiesGraph(result, batch, relationshipType, relationshipProperty, scoreCutoff));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void graph;
            item$iv$iv2 = (GCPVirtualEntitiesGraph)item$iv$iv3;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(storeGraph ? graph.createAndStore(this.tx) : graph.create());
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.gcp.classify.stream", mode=Mode.READ)
    @Description(value="Classifies a document into categories.")
    @NotNull
    public final Stream<NodeValueErrorMapResult> classifyStream(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.INSTANCE.verifyKey(config, "key");
        GCPClient client = this.gcpClient(config);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, client.classify((List<? extends Node>)batch, (int)index)));
        }
        Stream<NodeValueErrorMapResult> stream = ((List)destination$iv$iv).stream().flatMap(arg_0 -> GCPProcedures.classifyStream$lambda$6(classifyStream.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"flatMap(...)");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.gcp.classify.graph", mode=Mode.WRITE)
    @Description(value="Classifies a document into categories.")
    @NotNull
    public final Stream<VirtualGraph> classifyGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List batch;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.INSTANCE.verifyKey(config, "key");
        GCPClient client = this.gcpClient(config);
        RelationshipType relationshipType = NLPHelperFunctions.INSTANCE.categoryRelationshipType(config);
        Object object = config.getOrDefault("writeRelationshipProperty", "score");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String relationshipProperty = (String)object;
        Object object2 = config.getOrDefault("write", (Object)false);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean storeGraph = (Boolean)object2;
        Object object3 = config.getOrDefault("scoreCutoff", (Object)0.0);
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Number");
        Number scoreCutoff = (Number)object3;
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        Iterable iterable = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        void var12_12 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)batch, client.classify(batch, (int)index)));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            item$iv$iv2 = (Pair)item$iv$iv3;
            collection = destination$iv$iv;
            boolean bl = false;
            batch = (List)item$iv$iv2.component1();
            List result = (List)item$iv$iv2.component2();
            collection.add(new GCPVirtualClassificationGraph(result, batch, relationshipType, relationshipProperty, scoreCutoff));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void graph;
            item$iv$iv2 = (GCPVirtualClassificationGraph)item$iv$iv3;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(storeGraph ? graph.createAndStore(this.tx) : graph.create());
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    private final GCPClient gcpClient(Map<String, ? extends Object> config) {
        GCPClient gCPClient;
        Object object = config.getOrDefault("unsupportedDummyClient", (Object)false);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean useDummyClient = (Boolean)object;
        if (useDummyClient) {
            Log log = this.log;
            Intrinsics.checkNotNull((Object)log);
            gCPClient = new DummyGCPClient(config, log);
        } else {
            Log log = this.log;
            Intrinsics.checkNotNull((Object)log);
            gCPClient = new RealGCPClient(config, log);
        }
        return gCPClient;
    }

    private static final Stream entitiesStream$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Stream classifyStream$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }
}

