/*
 * Decompiled with CFR 0.152.
 */
package apoc.redis;

import apoc.redis.RedisConfig;
import apoc.redis.RedisConnection;
import io.lettuce.core.Range;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ByteArrayRedisConnection
extends RedisConnection<byte[]> {
    private final RedisCommands<byte[], byte[]> commands;

    public ByteArrayRedisConnection(String uri, RedisConfig config) {
        super(uri, config);
        StatefulRedisConnection connection = this.client.connect((RedisCodec)new ByteArrayCodec());
        this.commands = connection.sync();
    }

    @Override
    public byte[] get(byte[] key) {
        return (byte[])this.commands.get((Object)key);
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        return (byte[])this.commands.setGet((Object)key, (Object)value);
    }

    @Override
    public long append(byte[] key, byte[] value) {
        return this.commands.append((Object)key, (Object)value);
    }

    @Override
    public long incrby(byte[] key, long amount) {
        return this.commands.incrby((Object)key, amount);
    }

    @Override
    public long hdel(byte[] key, List<Object> fields) {
        return this.commands.hdel((Object)key, (Object[])this.toBytesArray(fields));
    }

    @Override
    public boolean hexists(byte[] key, byte[] field) {
        return this.commands.hexists((Object)key, (Object)field);
    }

    @Override
    public byte[] hget(byte[] key, byte[] field) {
        return (byte[])this.commands.hget((Object)key, (Object)field);
    }

    @Override
    public long hincrby(byte[] key, byte[] field, long amount) {
        return this.commands.hincrby((Object)key, (Object)field, amount);
    }

    @Override
    public boolean hset(byte[] key, byte[] field, byte[] value) {
        return this.commands.hset((Object)key, (Object)field, (Object)value);
    }

    @Override
    public Map<String, Object> hgetall(byte[] key) {
        return this.commands.hgetall((Object)key).entrySet().stream().collect(Collectors.toMap(e -> new String((byte[])e.getKey()), Map.Entry::getValue));
    }

    @Override
    public long push(byte[] key, List<Object> values) {
        return this.conf.isRight() ? this.commands.rpush((Object)key, (Object[])this.toBytesArray(values)) : this.commands.lpush((Object)key, (Object[])this.toBytesArray(values));
    }

    @Override
    public byte[] pop(byte[] key) {
        return this.conf.isRight() ? (byte[])this.commands.rpop((Object)key) : (byte[])this.commands.lpop((Object)key);
    }

    @Override
    public List<Object> lrange(byte[] key, long start2, long stop2) {
        return new ArrayList<Object>(this.commands.lrange((Object)key, start2, stop2));
    }

    @Override
    public long sadd(byte[] key, List<Object> members) {
        return this.commands.sadd((Object)key, (Object[])this.toBytesArray(members));
    }

    @Override
    public byte[] spop(byte[] key) {
        return (byte[])this.commands.spop((Object)key);
    }

    @Override
    public long scard(byte[] key) {
        return this.commands.scard((Object)key);
    }

    @Override
    public List<Object> smembers(byte[] key) {
        return new ArrayList<Object>(this.commands.smembers((Object)key));
    }

    @Override
    public List<Object> sunion(List<Object> keys) {
        return new ArrayList<Object>(this.commands.sunion((Object[])this.toBytesArray(keys)));
    }

    @Override
    public long zadd(byte[] key, Object ... scoresAndMembers) {
        return this.commands.zadd((Object)key, scoresAndMembers);
    }

    @Override
    public long zcard(byte[] key) {
        return this.commands.zcard((Object)key);
    }

    @Override
    public List<Object> zrangebyscore(byte[] source, long min, long max) {
        return new ArrayList<Object>(this.commands.zrangebyscore((Object)source, Range.create((Object)min, (Object)max)));
    }

    @Override
    public long zrem(byte[] source, List<Object> members) {
        return this.commands.zrem((Object)source, (Object[])this.toBytesArray(members));
    }

    @Override
    public byte[] eval(String script, ScriptOutputType outputType, List<Object> keys, List<Object> values) {
        return (byte[])this.commands.eval(script, outputType, (Object[])this.toBytesArray(keys), (Object[])this.toBytesArray(values));
    }

    @Override
    public boolean copy(byte[] source, byte[] destination) {
        return this.commands.copy((Object)source, (Object)destination);
    }

    @Override
    public long exists(List<Object> key) {
        return this.commands.exists((Object[])this.toBytesArray(key));
    }

    @Override
    public boolean pexpire(byte[] key, long time, boolean isExpireAt) {
        return isExpireAt ? this.commands.pexpireat((Object)key, time) : this.commands.pexpire((Object)key, time);
    }

    @Override
    public boolean persist(byte[] key) {
        return this.commands.persist((Object)key);
    }

    @Override
    public long pttl(byte[] key) {
        return this.commands.pttl((Object)key);
    }

    @Override
    public String info() {
        return this.commands.info();
    }

    @Override
    public String configSet(String parameter, String value) {
        return this.commands.configSet(parameter, value);
    }

    @Override
    public Map<String, Object> configGet(String parameter) {
        return Collections.unmodifiableMap(this.commands.configGet(parameter));
    }

    private byte[][] toBytesArray(List<Object> fields) {
        return (byte[][])fields.stream().map(byte[].class::cast).toArray(x$0 -> new byte[x$0][]);
    }
}

