/*
 * Decompiled with CFR 0.152.
 */
package apoc.redis;

import apoc.Extended;
import apoc.redis.RedisConfig;
import apoc.redis.RedisConnection;
import apoc.result.BooleanResult;
import apoc.result.ListResult;
import apoc.result.LongResult;
import apoc.result.MapResult;
import apoc.result.ObjectResult;
import io.lettuce.core.ScriptOutputType;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class Redis {
    @Procedure
    @Description(value="apoc.redis.getSet(uri, key, value, {config}) | Execute the 'SET key value' command and return old value stored (or null if did not exists)")
    public Stream<ObjectResult> getSet(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="value") Object value, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new ObjectResult(connection.getSet(key, value))));
    }

    @Procedure
    @Description(value="apoc.redis.get(uri, key, {config}) | Execute the 'GET key' command")
    public Stream<ObjectResult> get(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new ObjectResult(connection.get(key))));
    }

    @Procedure
    @Description(value="apoc.redis.append(uri, key, value, {config}) | Execute the 'APPEND key value' command")
    public Stream<LongResult> append(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="value") Object value, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new LongResult(Long.valueOf(connection.append(key, value)))));
    }

    @Procedure
    @Description(value="apoc.redis.incrby(uri, key, amount, {config}) | Execute the 'INCRBY key increment' command")
    public Stream<LongResult> incrby(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="amount") long amount, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new LongResult(Long.valueOf(connection.incrby(key, amount)))));
    }

    @Procedure
    @Description(value="apoc.redis.hdel(uri, key, fields, {config}) | Execute the 'HDEL key fields' command")
    public Stream<LongResult> hdel(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="fields") List<Object> fields, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new LongResult(Long.valueOf(connection.hdel(key, fields)))));
    }

    @Procedure
    @Description(value="apoc.redis.hexists(uri, key, field, {config}) | Execute the 'HEXISTS key field' command")
    public Stream<BooleanResult> hexists(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="field") Object field, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new BooleanResult(connection.hexists(key, field))));
    }

    @Procedure
    @Description(value="apoc.redis.hget(uri, key, field, {config}) | Execute the 'HGET key field' command")
    public Stream<ObjectResult> hget(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="field") Object field, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new ObjectResult(connection.hget(key, field))));
    }

    @Procedure
    @Description(value="apoc.redis.hincrby(uri, key, field, amount, {config}) | Execute the 'HINCRBY key field amount' command")
    public Stream<LongResult> hincrby(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="field") Object field, @Name(value="amount") long amount, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new LongResult(Long.valueOf(connection.hincrby(key, field, amount)))));
    }

    @Procedure
    @Description(value="apoc.redis.hgetall(uri, key, {config}) | Execute the 'HGETALL key' command")
    public Stream<MapResult> hgetall(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new MapResult(connection.hgetall(key))));
    }

    @Procedure
    @Description(value="apoc.redis.hset(uri, key, field, value, {config}) | Execute the 'HSET key field value' command and returns true if it is a new field in the hash or false if the field already exists")
    public Stream<BooleanResult> hset(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="field") Object field, @Name(value="value") Object value, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new BooleanResult(connection.hset(key, field, value))));
    }

    @Procedure
    @Description(value="apoc.redis.push(uri, key, values, {config}) | Execute the 'LPUSH key field values' command, or the 'RPUSH' if config right=true (default)")
    public Stream<LongResult> push(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="value") List<Object> values, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new LongResult(Long.valueOf(connection.push(key, values)))));
    }

    @Procedure
    @Description(value="apoc.redis.pop(uri, key, {config}) | Execute the 'LPOP key' command, or the 'RPOP' if config right=true (default)")
    public Stream<ObjectResult> pop(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new ObjectResult(connection.pop(key))));
    }

    @Procedure
    @Description(value="apoc.redis.lrange(uri, key, start, stop, {config}) | Execute the 'LRANGE key start stop' command")
    public Stream<ListResult> lrange(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="start") long start2, @Name(value="stop") long stop2, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new ListResult(connection.lrange(key, start2, stop2))));
    }

    @Procedure
    @Description(value="apoc.redis.sadd(uri, key, members, {config}) | Execute the 'SADD key members' command")
    public Stream<LongResult> sadd(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="members") List<Object> members, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new LongResult(Long.valueOf(connection.sadd(key, members)))));
    }

    @Procedure
    @Description(value="apoc.redis.scard(uri, key, {config}) | Execute the 'SCARD key' command")
    public Stream<LongResult> scard(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new LongResult(Long.valueOf(connection.scard(key)))));
    }

    @Procedure
    @Description(value="apoc.redis.spop(uri, key, {config}) | Execute the 'SPOP key' command")
    public Stream<ObjectResult> spop(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new ObjectResult(connection.spop(key))));
    }

    @Procedure
    @Description(value="apoc.redis.smembers(uri, key, {config}) | Execute the 'SMEMBERS key' command")
    public Stream<ListResult> smembers(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new ListResult(connection.smembers(key))));
    }

    @Procedure
    @Description(value="apoc.redis.sunion(uri, keys, {config}) | Execute the 'SUNION keys' command")
    public Stream<ListResult> sunion(@Name(value="uri") String uri, @Name(value="keys") List<Object> keys, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new ListResult(connection.sunion(keys))));
    }

    @Procedure
    @Description(value="apoc.redis.zadd(uri, keys, scoresAndMembers, {config}) | Execute the 'ZADD key scoresAndMembers' command, where scoresAndMembers is a list of score,member,score,member,...")
    public Stream<LongResult> zadd(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="value") List<Object> scoresAndMembers, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new LongResult(Long.valueOf(connection.zadd(key, scoresAndMembers.stream().map(score -> score instanceof Number ? Double.valueOf(((Number)score).doubleValue()) : score).toArray())))));
    }

    @Procedure
    @Description(value="apoc.redis.zcard(uri, key, {config}) | Execute the 'ZCARD key' command")
    public Stream<LongResult> zcard(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new LongResult(Long.valueOf(connection.zcard(key)))));
    }

    @Procedure
    @Description(value="apoc.redis.zrangebyscore(uri, key, min, max, {config}) | Execute the 'ZRANGEBYSCORE key min max' command")
    public Stream<ListResult> zrangebyscore(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="min") long min, @Name(value="max") long max, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new ListResult(connection.zrangebyscore(key, min, max))));
    }

    @Procedure
    @Description(value="apoc.redis.zrem(uri, key, members, {config}) | Execute the 'ZREM key members' command")
    public Stream<LongResult> zrem(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="members") List<Object> members, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new LongResult(Long.valueOf(connection.zrem(key, members)))));
    }

    @Procedure
    @Description(value="apoc.redis.eval(uri, script, outputType, keys, values, {config}) | Execute the 'EVAL script' command. In the parameters provided to the procedure, keys are bound to the KEYS[n] like special array of the Lua script and values are bound to the ARGV[n] like special array of the Lua script.")
    public Stream<ObjectResult> eval(@Name(value="uri") String uri, @Name(value="script") String script, @Name(value="outputType") String outputType, @Name(value="keys") List<Object> keys, @Name(value="values") List<Object> values, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new ObjectResult(connection.eval(script, ScriptOutputType.valueOf((String)outputType), keys, values))));
    }

    @Procedure
    @Description(value="apoc.redis.copy(uri, source, destination, {config}) | Execute the 'COPY source destination' command and returns true if source was copied and false otherwise")
    public Stream<BooleanResult> copy(@Name(value="uri") String uri, @Name(value="source") Object source, @Name(value="destination") Object destination, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new BooleanResult(connection.copy(source, destination))));
    }

    @Procedure
    @Description(value="apoc.redis.exists(uri, keys, {config}) | Execute the 'EXISTS keys' command")
    public Stream<LongResult> exists(@Name(value="uri") String uri, @Name(value="keys") List<Object> keys, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new LongResult(Long.valueOf(connection.exists(keys)))));
    }

    @Procedure
    @Description(value="apoc.redis.pexpire(uri, key, time, isExpireAt {config}) | Execute the 'PEXPIRE key time' command, or the 'PEPXPIREAT' if isExpireAt=true")
    public Stream<BooleanResult> pexpire(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="time") long time, @Name(value="isExpireAt") boolean isExpireAt, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new BooleanResult(connection.pexpire(key, time, isExpireAt))));
    }

    @Procedure
    @Description(value="apoc.redis.persist(uri, key, {config}) | Execute the 'PERSIST key' command")
    public Stream<BooleanResult> persist(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new BooleanResult(connection.persist(key))));
    }

    @Procedure
    @Description(value="apoc.redis.pttl(uri, key, {config}) | Execute the 'PTTL key' command")
    public Stream<LongResult> pttl(@Name(value="uri") String uri, @Name(value="key") Object key, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new LongResult(Long.valueOf(connection.pttl(key)))));
    }

    @Procedure
    @Description(value="apoc.redis.info(uri, {config}) | Execute the 'INFO' command")
    public Stream<ObjectResult> info(@Name(value="uri") String uri, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new ObjectResult((Object)connection.info())));
    }

    @Procedure
    @Description(value="apoc.redis.configGet(uri, parameter, {config}) | Execute the 'CONFIG GET parameter' command")
    public Stream<MapResult> configGet(@Name(value="uri") String uri, @Name(value="parameter") String parameter, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new MapResult(connection.configGet(parameter))));
    }

    @Procedure
    @Description(value="apoc.redis.configSet(uri, parameter, {config}) | Execute the 'CONFIG SET parameter value' command")
    public Stream<ObjectResult> configSet(@Name(value="uri") String uri, @Name(value="parameter") String parameter, @Name(value="value") String value, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.withConnection(uri, config, connection -> Stream.of(new ObjectResult((Object)connection.configSet(parameter, value))));
    }

    private <T> T withConnection(String uri, Map<String, Object> config, Function<RedisConnection, T> action) {
        try (RedisConnection connection = new RedisConfig(config).getCodec().getRedisConnection(uri, config);){
            T t = action.apply(connection);
            return t;
        }
    }
}

