/*
 * Decompiled with CFR 0.152.
 */
package apoc.redis;

import apoc.redis.RedisConfig;
import apoc.redis.RedisConnection;
import io.lettuce.core.Range;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StringRedisConnection
extends RedisConnection<String> {
    private final RedisCommands<String, String> commands;

    public StringRedisConnection(String uri, RedisConfig config) {
        super(uri, config);
        StatefulRedisConnection connection = this.client.connect((RedisCodec)new StringCodec(this.conf.getCharset()));
        this.commands = connection.sync();
    }

    @Override
    public String get(String key) {
        return (String)this.commands.get((Object)key);
    }

    @Override
    public String getSet(String key, String value) {
        return (String)this.commands.setGet((Object)key, (Object)value);
    }

    @Override
    public long append(String key, String value) {
        return this.commands.append((Object)key, (Object)value);
    }

    @Override
    public long incrby(String key, long amount) {
        return this.commands.incrby((Object)key, amount);
    }

    @Override
    public long hdel(String key, List<Object> fields) {
        return this.commands.hdel((Object)key, (Object[])this.toStringArray(fields));
    }

    @Override
    public boolean hexists(String key, String field) {
        return this.commands.hexists((Object)key, (Object)field);
    }

    @Override
    public String hget(String key, String field) {
        return (String)this.commands.hget((Object)key, (Object)field);
    }

    @Override
    public long hincrby(String key, String field, long amount) {
        return this.commands.hincrby((Object)key, (Object)field, amount);
    }

    @Override
    public boolean hset(String key, String field, String value) {
        return this.commands.hset((Object)key, (Object)field, (Object)value);
    }

    @Override
    public Map<String, Object> hgetall(String key) {
        return Collections.unmodifiableMap(this.commands.hgetall((Object)key));
    }

    @Override
    public long push(String key, List<Object> values) {
        return this.conf.isRight() ? this.commands.rpush((Object)key, (Object[])this.toStringArray(values)) : this.commands.lpush((Object)key, (Object[])this.toStringArray(values));
    }

    @Override
    public String pop(String key) {
        return this.conf.isRight() ? (String)this.commands.rpop((Object)key) : (String)this.commands.lpop((Object)key);
    }

    @Override
    public List<Object> lrange(String key, long start2, long stop2) {
        return new ArrayList<Object>(this.commands.lrange((Object)key, start2, stop2));
    }

    @Override
    public long sadd(String key, List<Object> members) {
        return this.commands.sadd((Object)key, (Object[])this.toStringArray(members));
    }

    @Override
    public String spop(String key) {
        return (String)this.commands.spop((Object)key);
    }

    @Override
    public long scard(String key) {
        return this.commands.scard((Object)key);
    }

    @Override
    public List<Object> smembers(String key) {
        return new ArrayList<Object>(this.commands.smembers((Object)key));
    }

    @Override
    public List<Object> sunion(List<Object> keys) {
        return new ArrayList<Object>(this.commands.sunion((Object[])this.toStringArray(keys)));
    }

    @Override
    public long zadd(String key, Object ... scoresAndMembers) {
        return this.commands.zadd((Object)key, scoresAndMembers);
    }

    @Override
    public long zcard(String key) {
        return this.commands.zcard((Object)key);
    }

    @Override
    public List<Object> zrangebyscore(String source, long min, long max) {
        return new ArrayList<Object>(this.commands.zrangebyscore((Object)source, Range.create((Object)min, (Object)max)));
    }

    @Override
    public long zrem(String source, List<Object> members) {
        return this.commands.zrem((Object)source, (Object[])this.toStringArray(members));
    }

    @Override
    public String eval(String script, ScriptOutputType outputType, List<Object> keys, List<Object> values) {
        return (String)this.commands.eval(script, outputType, (Object[])this.toStringArray(keys), (Object[])this.toStringArray(values));
    }

    @Override
    public boolean copy(String source, String destination) {
        return this.commands.copy((Object)source, (Object)destination);
    }

    @Override
    public long exists(List<Object> key) {
        return this.commands.exists((Object[])this.toStringArray(key));
    }

    @Override
    public boolean pexpire(String key, long time, boolean isExpireAt) {
        return isExpireAt ? this.commands.pexpireat((Object)key, time) : this.commands.pexpire((Object)key, time);
    }

    @Override
    public boolean persist(String key) {
        return this.commands.persist((Object)key);
    }

    @Override
    public long pttl(String key) {
        return this.commands.pttl((Object)key);
    }

    @Override
    public String info() {
        return this.commands.info();
    }

    @Override
    public String configSet(String parameter, String value) {
        return this.commands.configSet(parameter, value);
    }

    @Override
    public Map<String, Object> configGet(String parameter) {
        return Collections.unmodifiableMap(this.commands.configGet(parameter));
    }

    private String[] toStringArray(List<Object> fields) {
        return (String[])fields.stream().map(String.class::cast).toArray(String[]::new);
    }
}

