/*
 * Decompiled with CFR 0.152.
 */
package apoc.systemdb;

import apoc.ApocConfig;
import apoc.Description;
import apoc.Extended;
import apoc.export.cypher.ExportFileManager;
import apoc.export.cypher.FileManagerFactory;
import apoc.export.util.ExportConfig;
import apoc.export.util.ProgressReporter;
import apoc.result.ExportProgressInfo;
import apoc.result.ProgressInfo;
import apoc.result.RowResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.systemdb.SystemDbConfig;
import apoc.systemdb.metadata.ExportMetadata;
import apoc.util.collection.Iterables;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class SystemDb {
    public static final String REMOTE_SENSITIVE_PROP = "password";
    public static final String USER_SENSITIVE_PROP = "credentials";
    @Context
    public ApocConfig apocConfig;
    @Context
    public GraphDatabaseService db;

    @Admin
    @Procedure(name="apoc.systemdb.export.metadata")
    @Description(value="apoc.systemdb.export.metadata($conf) - export the apoc feature saved in system db (that is: customProcedures, triggers, uuids, and dvCatalogs) in multiple files called <FILE_NAME>.<FEATURE_NAME>.<DB_NAME>.cypher")
    public Stream<ExportProgressInfo> metadata(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        SystemDbConfig conf = new SystemDbConfig(config);
        String fileName = conf.getFileName();
        this.apocConfig.checkWriteAllowed(null, fileName);
        ExportProgressInfo progressInfo = new ExportProgressInfo(fileName, null, "cypher");
        ProgressReporter progressReporter = new ProgressReporter(null, null, (ProgressInfo)progressInfo);
        ExportFileManager cypherFileManager = FileManagerFactory.createFileManager((String)(fileName + ".cypher"), (boolean)true, (ExportConfig)ExportConfig.EMPTY);
        this.withSystemDbTransaction(tx -> {
            tx.getAllNodes().stream().flatMap(node -> StreamSupport.stream(node.getLabels().spliterator(), false).map(label -> ExportMetadata.Type.from(label, conf)).filter(Optional::isPresent).map(Optional::get).flatMap(type -> type.export((Node)node, progressReporter).stream())).collect(Collectors.groupingBy(Pair::getLeft, Collectors.toList())).forEach((fileNameSuffix, fileContent) -> {
                try (PrintWriter writer = cypherFileManager.getPrintWriter(fileNameSuffix);){
                    String stringStatement = fileContent.stream().map(Pair::getRight).collect(Collectors.joining("\n"));
                    writer.write(stringStatement);
                }
            });
            return null;
        });
        progressReporter.done();
        return Stream.of((ExportProgressInfo)progressReporter.getTotal());
    }

    @Admin
    @Procedure
    public Stream<NodesAndRelationshipsResult> graph() {
        return this.withSystemDbTransaction(tx -> {
            HashMap<Long, VirtualNode> virtualNodes = new HashMap<Long, VirtualNode>();
            for (Node node : tx.getAllNodes()) {
                Map props = node.getAllProperties();
                props.keySet().removeAll(Set.of(REMOTE_SENSITIVE_PROP, USER_SENSITIVE_PROP));
                virtualNodes.put(-node.getId(), new VirtualNode(-node.getId(), (Label[])Iterables.asArray(Label.class, (Iterable)node.getLabels()), props));
            }
            List<Relationship> relationships = tx.getAllRelationships().stream().map(rel -> new VirtualRelationship(-rel.getId(), (Node)virtualNodes.get(-rel.getStartNodeId()), (Node)virtualNodes.get(-rel.getEndNodeId()), rel.getType(), rel.getAllProperties())).collect(Collectors.toList());
            return Stream.of(new NodesAndRelationshipsResult(Iterables.asList(virtualNodes.values()), relationships));
        });
    }

    @Admin
    @Procedure
    public Stream<RowResult> execute(@Name(value="DDL commands, either a string or a list of strings") Object ddlStringOrList, @Name(value="params", defaultValue="{}") Map<String, Object> params) {
        List commands;
        if (ddlStringOrList instanceof String) {
            commands = Collections.singletonList((String)ddlStringOrList);
        } else if (ddlStringOrList instanceof List) {
            commands = (List)ddlStringOrList;
        } else {
            throw new IllegalArgumentException("don't know how to handle " + String.valueOf(ddlStringOrList) + ". Supply either a string or a list of strings");
        }
        Transaction tx = this.apocConfig.getSystemDb().beginTx();
        return (Stream)commands.stream().flatMap(command -> tx.execute(command, params).stream().map(RowResult::new)).onClose(() -> {
            boolean isOpen = ((TransactionImpl)tx).isOpen();
            if (isOpen) {
                tx.commit();
            }
            tx.close();
        });
    }

    private <T> T withSystemDbTransaction(Function<Transaction, T> function) {
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            T result = function.apply(tx);
            tx.commit();
            T t = result;
            return t;
        }
    }

    public static class NodesAndRelationshipsResult {
        public List<Node> nodes;
        public List<Relationship> relationships;

        public NodesAndRelationshipsResult(List<Node> nodes, List<Relationship> relationships) {
            this.nodes = nodes;
            this.relationships = relationships;
        }
    }
}

